import React, {useMemo, useState} from 'react';
import ChatPanel from './chat/panel';
import StudentList from './student-list';
import useChatText from '../hooks/use-chat-text';
import { VolumeOff, VolumeUp, ImportExport } from '@material-ui/icons';
import {roomStore} from "../stores/room";
import {useRoomState} from "../containers/root-container";
import './room-tools-bar.scss';
import VoiceOverOffIcon from "@material-ui/icons/VoiceOverOff";
import RecordVoiceOverIcon from "@material-ui/icons/RecordVoiceOver";
import Category from "@material-ui/icons/Category";
import ImportContacts from "@material-ui/icons/ImportContacts";
import SettingsApplicationsIcon from '@material-ui/icons/SettingsApplications';
import SettingsPowerIcon from '@material-ui/icons/SettingsPower';
import {TOOL_TYPE} from "../utils/types";


type Props = {
  // zoomScale: number
  // zoomChange: (scale: number) => void
  onClick: (type: string) => void
  // onClickBoardLock: () => void
};
export default function RoomToolsBar (props: any) {
// export const RoomToolsBar: React.FC<Props> = ({onClick}) => {
  const roomState = useRoomState();
  const changeTool = async () => {
    console.log(roomStore.state.course.currentTool);
    if (roomStore.state.course.currentTool == TOOL_TYPE.WHITEBOARD) {
      await roomStore.setCurrentTool(TOOL_TYPE.COURSE_WARE)
    } else {
      await roomStore.setCurrentTool(TOOL_TYPE.WHITEBOARD)
    }
  }
  const {currentTool} = useMemo(() => {
    return {
      currentTool: roomStore.state.course.currentTool
    }
  }, [roomState]);

  const {muteAudio} = useMemo(() => {
    return {
      muteAudio: roomState.course.muteAudio
    }
  }, [roomState.course]);
  const audioOn = async () => {
    console.log('audioOn');
    await roomStore.allStudentMuteOn()
  }
  const audioOff = async () => {
    console.log('audioOff');
    await roomStore.allStudentMuteOff()
  }
  const randomStageUp = async () => {
    await roomStore.randomStageUp()
  }

  return (
    <>
      <div className={'room-tool-box'}>

        {roomStore.state.me.role == 'teacher' ?
          <>
            {muteAudio
              ? <div className="tool-btn" onClick={audioOn}><VoiceOverOffIcon/></div>
              : <div onClick={audioOff} className="tool-btn"><RecordVoiceOverIcon/></div>
            }
            {currentTool == TOOL_TYPE.WHITEBOARD
              ? <div className="tool-btn" onClick={changeTool}><ImportContacts/></div>
              : <div onClick={changeTool} className="tool-btn"><Category/></div>
            }
          </>: null }



        <div className="tool-btn" onClick={(evt: any) => {
          props.onClick("setting");
        }}><SettingsApplicationsIcon/></div>
        <div className="tool-btn" onClick={(evt: any) => {
          props.onClick("exit");
        }}><SettingsPowerIcon/></div>
        {/*<div className="tool-btn"><ImportExport onClick={randomStageUp}></ImportExport></div>*/}
      </div>
    </>
  )
}
