import React, {useRef, useEffect, useMemo, useState} from 'react';
import Icon from './icon';
import './video-player.scss';
import { AgoraElectronStream, StreamType, nativeRTCClient as nativeClient } from '../utils/agora-electron-client';
import { useRoomState } from '../containers/root-container';
import { platform } from '../utils/platform';
import {makeStyles} from "@material-ui/core/styles";

const contentMode = 0;


const useStyles = makeStyles({
  style1 : {
    display: 'flex',
    flexDirection: 'column',
    width: '100%', // 'calc(100% - 280px)'
    height: '100%'
  },
  style2 : {
    display: 'flex',
    flexDirection: 'row'
  },
  style3:{
    height: 30,
    flex: 1
  },
  style4: {
    height: 30,
    width: 100,
    flex: 0
  },
  frm: {
    flex: 1,
    border: 0
  }
});
const CourseWareFrame: React.FC = () => {
  const classes = useStyles();
  const ref = useRef<any>('');
  const [src, setSrc] = useState('')
  const changSrc = (evt: any) => {
    setSrc(ref.current.value);
  }

  return (
    <div className={classes.style1}>
      <div className={classes.style2}>
        <input type="text" ref={ref} className={classes.style3} />
        <button onClick={changSrc} className={classes.style4}>GO</button>
      </div>

      <iframe src={src} className={classes.frm}></iframe>
    </div>
  )
}

export default React.memo(CourseWareFrame);
