import React, {useMemo, useState} from 'react';
import ChatPanel from './chat/panel';
import StudentList from './student-list';
import useChatText from '../hooks/use-chat-text';
import { VolumeOff, VolumeUp, ImportExport } from '@material-ui/icons';
import {roomStore} from "../stores/room";
import {useRoomState} from "../containers/root-container";
import './room-tools-bar.scss';

export default function RoomToolsBar (props: any) {
  const roomState = useRoomState();
  const {muteAudio} = useMemo(() => {
    return {
      muteAudio: roomState.course.muteAudio
    }
  }, [roomState.course]);
  const audioOn = async () => {
    console.log('audioOn');
    await roomStore.allStudentMuteOn()
  }
  const audioOff = async () => {
    console.log('audioOff');
    await roomStore.allStudentMuteOff()
  }
  const randomStageUp = async () => {
    await roomStore.randomStageUp()
  }
  return (
    <>
      <div className={'room-tool-box'}>
        {muteAudio ? <div className="tool-btn" onClick={audioOn}><VolumeUp></VolumeUp></div> : <div onClick={audioOff} className="tool-btn"><VolumeOff></VolumeOff></div> }
        <div className="tool-btn"><ImportExport onClick={randomStageUp}></ImportExport></div>
      </div>
    </>
  )
}
