import React, { useEffect, useRef, useState } from 'react';
import './toast.scss';
import {useGlobalState} from '../containers/root-container';
import { isEmpty } from 'lodash';
import {roomStore} from "../stores/room";



interface UserStarsProps {
  id?: string,
  streamID: number
  // stars: number
}

export default function UserStars({id, streamID}: UserStarsProps) {
  const [star, setStar]  = useState<number>(0);
  useEffect(() => {
    console.log('roomStore.state.userStars change, streamID',streamID)
    if (streamID) {
      const u = roomStore.state.users.get(`${streamID}`)
      if (u) {
        console.log('u.stars', u.stars);
        setStar(u.stars || 0);
      }
    }
    // setStar()
  }, [roomStore.state.users]);





  return (
    <div className='star'>
      <div className="medal"></div>
      <div className="medal-bg">
          <span className="points">
            {star}
          </span>
      </div>

    </div>
  )
}
