import React, { useEffect, useRef, useState } from 'react';
import './toast.scss';
import {useGlobalState, useRoomState} from '../containers/root-container';
import { isEmpty } from 'lodash';
import {roomStore} from "../stores/room";
import EmojiEventsIcon from "@material-ui/icons/EmojiEvents";
import {eventBus} from "../stores/EventBus";
import Link from "@material-ui/core/Link";
import EmojiEventsOutlinedIcon from '@material-ui/icons/EmojiEventsOutlined';
import {makeStyles} from "@material-ui/core/styles";


const useStyles = makeStyles({
  emojiEvent: {
    width: 18,
    marginLeft: 3,
    marginRight: 3,
    height: 24,
    color: '#fff',
    lineHeight: 24,
    opacity: .8,
    cursor:'pointer'
  }
});
export enum StarsButtonType {
  BIG, SMALL, TEXT
}
interface AddStarsButtonProps {
  type: StarsButtonType
  uid: number
}

// const VideoPlayer: React.FC<VideoPlayerProps> = ({}) => {}
export default function AddStarsButton({type, uid}: AddStarsButtonProps) {
  const me = useRoomState().me;
  const style = useStyles();
  const addStar = async () => {
    if (me.role != 'teacher') {
      return
    }
    eventBus.emit('showAddStartDialog', {uid})
  }


  return (

    <>
      {
        StarsButtonType.BIG === type
          ?<div className="tool-btn" onClick={addStar}><EmojiEventsIcon/></div>
          : null
      }
      {
        StarsButtonType.SMALL === type
          ? <EmojiEventsOutlinedIcon  onClick={addStar} className={style.emojiEvent}></EmojiEventsOutlinedIcon>
          : null
      }
      {
        StarsButtonType.TEXT === type
          ? <Link component="button" onClick={addStar}>奖励</Link>
          : null
      }
      </>
  )
}
