import React, {useEffect, useLayoutEffect, useMemo, useRef, useState} from 'react';
// import VideoMarquee from '../../components/video-marquee';
import MediaBoard from '../../components/mediaboard';
// import Roomboard from '../../components/roomboard';
import './small-class.scss';
import CourseWareFrame from "../../components/courseware-frame";
import VideoShowList from "../../components/video-stage-list";
import {ToolsSwitcherController} from "../../components/tools-switcher-controller";
import {roomStore} from "../../stores/room";
import {TOOL_TYPE} from "../../utils/types";
// import {platform} from "../../utils/platform";
// import AgoraWebClient from "../../utils/agora-rtc-client";
// import {AgoraElectronClient} from "../../utils/agora-electron-client";
import {useRoomState} from "../../containers/root-container";
import {RoomMessage} from "../../utils/agora-rtm-client";
import Icon from "../../components/icon";
// import RoomToolsBar from "../../components/room-tools-bar";

export default function SmallClass() {

  const [tool, setTool] = useState(true);
  const roomState = useRoomState();
  const changeTool = async () => {
    console.log(roomStore.state.course.currentTool);
    if (roomStore.state.course.currentTool == TOOL_TYPE.WHITEBOARD) {
      await roomStore.setCurrentTool(TOOL_TYPE.COURSE_WARE)
    } else {
      await roomStore.setCurrentTool(TOOL_TYPE.WHITEBOARD)
    }
  }
  const {currentTool} = useMemo(() => {
    return {
      currentTool: roomStore.state.course.currentTool
    }
  }, [roomState]);

  const rtmLock = useRef<boolean>(false);
  const handleClick = (evt: any) => {
    if (rtmLock.current) return;
    console.log('handleClick hands_up', evt.currentTarget);
    const elem = evt.currentTarget;
    if (elem.classList.contains('disabled')) {
      return;
    }
    // if (type === 'hands_up') {
      if (roomStore.state.course.teacherId) {
        elem.classList.add('disabled');
        setTimeout(() => {
          console.log('remove disabled class');
          elem.classList.remove('disabled');
        }, 10 * 1000)
        rtmLock.current = true;
        roomStore.rtmClient.sendPeerMessage(roomStore.state.course.teacherId,
          // {cmd: RoomMessage.applyCoVideo}
          {cmd: RoomMessage.handsUp}
        )
          .then((result: any) => {
            console.log("peerMessage result ", result);
            if (!result) {
              evt.currentTarget.classList.remove('disabled');
            }
          })
          .catch(console.warn)
          .finally(() => {
            rtmLock.current = false;
          })
      }
    // }
    /*
    if (type === 'hands_up_end') {
      if (roomStore.state.course.teacherId) {
        rtmLock.current = true;
        roomStore.rtmClient.sendPeerMessage(roomStore.state.course.teacherId,
          {cmd: RoomMessage.cancelCoVideo})
          .then((result: any) => {
            console.log("peerMessage result ", result);
          })
          .catch(console.warn)
          .finally(() => {
            rtmLock.current = false;
          })
      }
    }
    */
  }

  useEffect(() => {

  }, [roomStore.state.course.currentTool]);
  return (
    <div className="room-container">
      {/*<VideoMarquee />*/}
      <VideoShowList/>
      <div className="container">
        {/*{roomStore.state.me.role == 'teacher' ?<ToolsSwitcherController  onClick={() => {*/}
        {/*  changeTool();*/}
        {/*}}/> : null}*/}

        {currentTool == TOOL_TYPE.WHITEBOARD
          ? <MediaBoard />
          : <CourseWareFrame></CourseWareFrame>}


        <Icon
          data='hands_up'
          onClick={handleClick}
          className={`items hands_up ${false ? 'active' : ''}`}
        />

        {/*{ roomStore.state.me.role == 'teacher' ? <Roomboard currentActive={'media'} /> : null}*/}
      </div>
    </div>
  )
}
