import React from 'react';
import BuildIcon from '@material-ui/icons/Build';
import {makeStyles} from "@material-ui/core/styles";
import {Link} from "react-router-dom";

export type ToolsSwitcherControllerProps = {
  // zoomScale: number
  // zoomChange: (scale: number) => void
  onClick: () => void
  // onClickBoardLock: () => void
};
const toolsStyle = makeStyles({
  button: {
    width: '42px!important',
    lineHeight: 42,
    cursor: 'pointer',
    userSelect: 'none',
    display: 'flex',
    alignItems: 'center',
    boxSizing: 'border-box',
    position: 'absolute',
    left: 10,
    bottom: 10,
    height: 42,
    background: '#fff',
    boxShadow: '0 2px 4px 0 rgba(0,0,0,.1)',
    borderRadius: 6,
    border: '1px solid #dbe2e5',
    zIndex:9,
  },
  icon: {
    margin: '0 auto'
  }
});
export const ToolsSwitcherController: React.FC<ToolsSwitcherControllerProps> = ({onClick}) => {
  const classes = toolsStyle();

  return (
    <div className={`tool-switcher-controls ${classes.button}`} onClick={() => onClick()}>
      <BuildIcon className={classes.icon}></BuildIcon>
      {/*<div className="zoom-icon" onClick={() => this.props.onClick()}>*/}
      {/*</div>*/}
      {/*<div className="zoom-hold"></div>*/}
      {/*<div className="zoom-size">{Math.ceil(this.props.zoomScale * 100)} %</div>*/}
      {/*<div className="zoom-items">*/}
      {/*  <div className="item zoom-in" onClick={() => this.moveRuleIndex(-1)}>-</div>*/}
      {/*  <div className="item zoom-out" onClick={() => this.moveRuleIndex(+1)}>+</div>*/}
      {/*</div>*/}
      {/*<div className="lock-board" onClick={() => this.props.onClickBoardLock() }></div>*/}
    </div>
  );
}


