import React, { useRef, useEffect, useState, useLayoutEffect } from 'react';
import VideoPlayer from './video-player';
import Icon from './icon';
import {ExpandMore, ExpandLess} from '@material-ui/icons';
import './video-stage-list.scss';
import useStream from '../hooks/use-streams';
import { AgoraMediaStream } from '../utils/types';
import {STAGE_NUM} from "../utils/consts";
import MemberHolder from "./member-holder";


function VideoShowList() {


  const {teacher, students, onPlayerClick} = useStream();




  const ref = useRef<boolean>(false);

  useEffect(() => {
    return () => {
      ref.current = true;
    }
  }, []);

  const [showFull, setShowFull] = useState<boolean>(false);
  const toggleShowFull = (evt: any) => {
    !ref.current && setShowFull(!showFull);
  }
  // useLayoutEffect(() => {
  //   if (!students.length) return;
  //   !ref.current && setShowMore(showScrollbar());
  // }, [students]);



  return (
    <div className="video-show-list-container">
      <div className="show-platform">
        <div className="on-show">
          {teacher ?
            <div className="camera">
              <svg viewBox="0 0 7 5"></svg>
              <VideoPlayer
                role="teacher"
                domId={`dom-${teacher.streamID}`}
                id={`${teacher.streamID}`}
                streamID={teacher.streamID}
                stream={teacher.stream}
                account={teacher.account}
                audio={Boolean(teacher.audio)}
                video={Boolean(teacher.video)}
                local={Boolean(teacher.local)}
                handleClick={onPlayerClick}
              />
            </div>
            :
            <div className="camera">
              <svg viewBox="0 0 7 5"></svg>
              <VideoPlayer role="teacher" account={'teacher'} video audio streamID={0} />
            </div>
          }

          {[...Array(6)].map((x, i) =>{
              // return <div className="camera">
              //   <div key={`stage${i}`} className="agora-video-view  camera-holder">{i}</div>
              // </div>  ;
              const student = students && students.slice(0,STAGE_NUM)[i];

              return <div className="camera" key={`stage_video${i}`}>
                <svg viewBox="0 0 7 5"></svg>
                {student ? <VideoPlayer
                  role="student"
                  domId={`dom-${student.streamID}`}
                  id={`${student.streamID}`}
                  account={student.account}
                  streamID={student.streamID}
                  stream={student.stream}
                  video={student.video}
                  audio={student.audio}
                  local={student.local}
                  handleClick={onPlayerClick}
                /> : <div key={`stage_holder${i}`} className="agora-video-view  camera-holder">{i}</div>
                }
              </div>  ;
            }
          )}
          {/* stageStudents ? stageStudents.map((student: AgoraMediaStream, key: number) => (
            <VideoPlayer
              role="student"
              domId={`dom-${student.streamID}`}
              key={`stage${key}${student.streamID}`}
              id={`${student.streamID}`}
              account={student.account}
              streamID={student.streamID}
              stream={student.stream}
              video={student.video}
              audio={student.audio}
              local={student.local}
              handleClick={onPlayerClick}
            />
          )) : null */}
        </div>
        <div className="waiting-list">
          <div className="member-wrapper" style={{ display: showFull ? "flex" : "none" }}>



            {/*[...Array(12)].map((x, i) =>{
                return <div className="member">
                  <MemberHolder
                    role="student"
                    key={`wait${i}${i}`}
                    id={`${i}`}
                    account={`user${i}`}
                    streamID={i}
                    stream={null}
                    video={false}
                    audio={false}
                  />
                </div>  ;
              }
            )*/}


            { students ? students.slice(STAGE_NUM).map((student: AgoraMediaStream, key: number) => (
              // <VideoPlayer
              //   role="student"
              //   domId={`dom-${student.streamID}`}
              //   key={`wait${key}${student.streamID}`}
              //   id={`${student.streamID}`}
              //   account={student.account}
              //   streamID={student.streamID}
              //   stream={student.stream}
              //   video={student.video}
              //   audio={student.audio}
              //   local={student.local}
              //   handleClick={onPlayerClick}
              // />
              <div className="member" key={`wait${key}${student.streamID}`}>
                {/*<div key={`wait${i}`} className="camera-holder">{i}</div>*/}
                <MemberHolder
                  role="student"
                  id={`${student.streamID}`}
                  account={student.account}
                  streamID={student.streamID}
                  stream={student.stream}
                  video={student.video}
                  audio={student.audio}
                  handleClick={onPlayerClick}
                />
              </div>
            )) : null }
          </div>
        </div>

        {
          !showFull
            ? <div className='toggle-full-student-list' onClick={toggleShowFull}><span style={{ fontSize: 12}}>展开全部</span>
              <ExpandMore></ExpandMore></div>
            : <div className='toggle-full-student-list' onClick={toggleShowFull}><span style={{ fontSize: 12}}>收起</span>
              <ExpandLess></ExpandLess></div>
        }


      </div>
    </div>
  )
}
export default React.memo(VideoShowList);
