import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { useGlobalState } from '../containers/root-container';

const useStyles = makeStyles(theme => ({
  progress: {
    margin: theme.spacing(2),
    color: '#44A2FC'
  },
  container: {
    position: 'absolute',
    top: '0px',
    left: '0px',
    height: '100%',
    width: '100%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor:'rgba(0, 0, 0, 0.5)',
    // opacity: 0.8,
    zIndex: 10
  },
  textWrap:{
    padding: 32,
  }
}));

export const Permission: React.FC<{}> = () => {
  const classes = useStyles();
  return (
    <div className={classes.container}>
      <div>
        <div className="custom-card">
          <div className="flex-item cover">
            <div className="preview-video">
              <div className="permission-placeholder"></div>
            </div>
          </div>
          <div className="flex-item card">
            <div className={classes.textWrap}>
              <h3>提示</h3>
              <p>请先开启摄像头、麦克风权限，<b>否则将无法正常上课！！！</b></p>

              <p><b>第一步</b>：按照如下方法，设置摄像头/麦克风权限为<b>“允许”</b>：
                点击浏览器地址旁边的小锁头，在弹出的窗口中，设置摄像头/麦克风权限为<b>“允许”</b>。</p>

              <p><b>第二步</b>：设置完成后，根据提示，点击<b>“重新加载”</b>。</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default function PermissionContainer () {

  const state = useGlobalState();

  const permission = state.permission;

  return (
    permission ? <Permission /> : null
  )
}
