import {
    Label,
    MySprite
} from './Unit';

/**
 * 根据父级组件大小设置字体大小
 * @param parWidth 
 * @param label 
 */
export function setFontSize(parWidth : number, label: Label){

    if(!label){
      return;
    }

    let w = label.width;

    let h = label.height;

    let r = Math.sqrt( w * w + h * h)/2;

    //如果宽度超过，则缩小字体
    if(r > parWidth/2){
      
      shrinkFont(parWidth, label);
    }
    else{
      magnifyingFontSize(parWidth, label);
    }
  }

  export function shrinkFont(parWidth : number, label: Label){
    if(!label){
      return;
    }

    let w = label.width;

    let h = label.height;

    let r = Math.sqrt( w * w + h * h)/2;

    //如果宽度超过，则缩小字体
    if(r > parWidth/2){
      
      let fontSize = label.fontSize;

      fontSize = fontSize - 2;

      label.fontSize = fontSize;

      label.refreshSize();


      shrinkFont(parWidth, label);

    }
  }

  export function magnifyingFontSize(parWidth : number, label: Label){

    if(!label){
      return;
    }

    let w = label.width;

    let h = label.height;

    let r = Math.sqrt( w * w + h * h)/2;

    //如果宽度超过，则缩小字体
    if(r < parWidth/2){
      
      let fontSize = label.fontSize;

      fontSize = fontSize + 2;

      label.fontSize = fontSize;

      label.refreshSize();

      magnifyingFontSize(parWidth, label);

    }
  }


  /**
   * 获取按钮图片
   * @param text 文本内容
   * @param font 字体
   * @param fontColor
   */
  export function getBtnPic(text, font, fontColor){

    const btn = new MySprite();
    btn.init(this.images.get('btn'));
    btn.setScaleXY(this.mapScale);

    let btnText = new Label();
    btnText.text = text;
    btnText.textAlign='middle';
    btnText.fontSize = 50;
    btnText.fontName = font;
    btnText.fontColor = fontColor;
    btnText.refreshSize();
    
    btnText.x = -btnText.width/2;
    btnText.y = 0;
    btn.addChild(btnText);
    btn.childDepandAlpha = true;

    return btn;
  }

  export function getRandomItemFromArr(arr){

    if(!arr){
      return;
    }

    let length = arr.length;

    let index = Math.ceil(Math.random()*100000000)%length;

    return arr[index];
  }