// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    currentInputIndex: null,
    start () {
        this.currentInputIndex = 0;
        this.initEventListener();
    },

    initEventListener() {
        const returnBtn = cc.find("buttons/return", this.node);
        returnBtn.on("click", ()=>{
            this.node.emit("onCancel");
            this.hide();
        })

        const okBtn = cc.find("buttons/ok", this.node);
        okBtn.on("click", ()=>{
            const selectedContainer = cc.find("mainContainer/selected", this.node);
            const allData = [];
            selectedContainer.children.forEach((child, index)=>{
                child.myData.currentIndex = index;
                allData.push(child.myData)
            })
            this.node.emit("onEnter", allData);
            this.hide();
        })

        this.node.on("show", options => {
            this.show(options);
        })
    },

    show(options) {
        this.node.opacity = 255;
        this.node.x = 0;
        this.node.y = 0;

        const template = cc.find("mainContainer/options/_word", this.node);
        const optionsContainer = cc.find("mainContainer/options", this.node);
        const selectedContainer = cc.find("mainContainer/selected", this.node);
        options.forEach(item => {
            const newWord = cc.instantiate(template);
            newWord.name = "word";
            newWord.getComponent(cc.Label).string = item.word;
            newWord.active = true;
            newWord.myData = {
                selected: false,
                currentIndex: -1,
                option: item,
            };

            optionsContainer.addChild(newWord);

            newWord.on("click", ()=>{
                if(newWord.myData.selected) {
                    selectedContainer.removeChild(newWord)
                    optionsContainer.addChild(newWord)
                    newWord.myData.selected = false;
                } else {
                    optionsContainer.removeChild(newWord)
                    selectedContainer.addChild(newWord)
                    newWord.myData.selected = true;
                }
            })
        });
        
        cc.tween(this.node).to(0.1, {opacity: 255}).call(()=>{

        }).start();
    },

    hide() {
        const optionsContainer = cc.find("mainContainer/options", this.node);
        const selectedContainer = cc.find("mainContainer/selected", this.node);
        this.node.opacity = 255;
        cc.tween(this.node).to(0.1, {opacity: 0}).call(()=>{
            this.node.x = 5000;
            optionsContainer.children.forEach(child=>{
                if(child.name != "_word") {
                    child.destroy();
                }
            })
            selectedContainer.removeAllChildren();
        }).start();  
    }
    // update (dt) {},
});
