// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property({displayName: "标题内容", })
    titleName: string = "请选择答案";

    @property({type: cc.Float, displayName: "窗口宽度", })
    width: number = 1000;

    @property({type: cc.Float, displayName: "标题高度", })
    headerHeight: number = 150;

    @property({type: cc.Float, displayName: "选项高度", })
    optionHeight: number = 120;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        this.node.active = false;
        this.initSize();
        this.initTitle(this.titleName);
        this.initEventListener();
    }

    initTitle(title) {
        cc.find("center/header/title", this.node).getComponent(cc.Label).string = title;
    }

    initSize() {
        const center = cc.find("center", this.node);
        const header = cc.find("center/header", this.node);
        const list = cc.find("center/list", this.node);

        center.width = this.width;
        header.width = this.width;
        list.width = this.width;

        this.node.x = 0;
        this.node.y = 0;

        const itemTemplate = cc.find("center/list/layout_options/item_tempate", this.node);
        itemTemplate.x = this.width / 2;
        itemTemplate.width = this.width;

        itemTemplate.height = this.optionHeight;
    }

    initEventListener() {
        const closeBtn = cc.find("center/header/close", this.node);
        closeBtn.on("click", ()=>{
            this.node.emit("onCancel");
            this.hide();
        })

        this.node.on("show", (option, type="textList") => {
            this.show(option, type);
        })

        const rightWrongLayout = cc.find("center/list/layout_right_wrong", this.node);
        const rightBtn =  cc.find("right", rightWrongLayout);
        const wrongBtn =  cc.find("wrong", rightWrongLayout);

        rightBtn.on("click", ()=>{
            this.node.emit("onSelected", true);
            this.hide();
        })
        wrongBtn.on("click", ()=>{
            this.node.emit("onSelected", false);
            this.hide();
        })
    }

    show(option, type) {
        this.node.opacity = 0;
        this.node.active = true;
        cc.tween(this.node).to(0.1, {
            opacity: 255
        }).start();

        const center = cc.find("center", this.node);
        const list = cc.find("center/list", this.node);
        
        if(type == "textList") {
            this.initTitle("请选择答案");
            const listLayout = cc.find("center/list/layout_options", this.node);
            const itemTemplate = cc.find("center/list/layout_options/item_tempate", this.node);
            listLayout.active = true;

            option.forEach((item, index) => {
                const optionNode = cc.instantiate(itemTemplate);
                // 第一个选项不显示顶部分隔条
                if(index == 0) {
                    cc.find("line_top", optionNode).active = false;
                }
                optionNode.name = `option_${index}`
                const text = cc.find("text", optionNode);
                text.getComponent(cc.Label).string = item.label;
                optionNode.on("click", ()=>{
                    this.node.emit("onSelected", item);
                    this.hide();
                })
                optionNode.active = true;
                listLayout.addChild(optionNode);
            });
    
            center.height = option.length * this.optionHeight + this.headerHeight;
            list.height = option.length * this.optionHeight;
            listLayout.height = option.length * this.optionHeight;
        } else {
            const rightWrongLayout = cc.find("center/list/layout_right_wrong", this.node);
            const rightIcon = cc.find("right/icon_right", rightWrongLayout);
            const laughIcon = cc.find("right/icon_laugh", rightWrongLayout);
            const textTrue = cc.find("right/text_true", rightWrongLayout);
            const textYes = cc.find("right/text_yes", rightWrongLayout);
            const wrongIcon = cc.find("wrong/icon_wrong", rightWrongLayout);
            const cryIcon = cc.find("wrong/icon_cry", rightWrongLayout);
            const textFalse = cc.find("wrong/text_false", rightWrongLayout);
            const textNo = cc.find("wrong/text_no", rightWrongLayout);

            if(type == "rightWrong_icon") {
                this.initTitle("请选择答案");
                rightIcon.active = true;
                laughIcon.active = false;
                textTrue.active = false;
                textYes.active = false;
                wrongIcon.active = true;
                cryIcon.active = false;
                textFalse.active = false;
                textNo.active = false;
            } else if(type == "rightWrong_face") {
                this.initTitle("请选择表情");
                rightIcon.active = false;
                laughIcon.active = true;
                textTrue.active = false;
                textYes.active = false;
                wrongIcon.active = false;
                cryIcon.active = true;
                textFalse.active = false;
                textNo.active = false;
            } else if(type == "rightWrong_T_F") {
                this.initTitle("请选择答案");
                rightIcon.active = false;
                laughIcon.active = false;
                textTrue.active = true;
                textYes.active = false;
                wrongIcon.active = false;
                cryIcon.active = false;
                textFalse.active = true;
                textNo.active = false;
            } else if(type == "rightWrong_Yes_No") {
                this.initTitle("请选择答案");
                rightIcon.active = false;
                laughIcon.active = false;
                textTrue.active = false;
                textYes.active = true;
                wrongIcon.active = false;
                cryIcon.active = false;
                textFalse.active = false;
                textNo.active = true;
            }
            
            rightWrongLayout.active = true;
            center.height = 350 + this.headerHeight;
            list.height = 350;
        }
        
    }

    hide() {
        cc.tween(this.node).to(0.1, {
            opacity: 0
        }).call(()=>{
            const listLayout = cc.find("center/list/layout_options", this.node);
            const rightWrongLayout = cc.find("center/list/layout_right_wrong", this.node);
            listLayout.active = false;
            rightWrongLayout.active = false;

            this.node.active = false;
            // 销毁非模板节点的所有子节点
            listLayout.children.forEach(child=>{
                if(child.name != "item_tempate") {
                    child.destroy();
                }
            })
        }).start();
    }

    // update (dt) {}
}
