import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  HostListener,
  ApplicationRef,
  ChangeDetectorRef,
  AfterViewInit,
  ViewChild,
  ElementRef
} from '@angular/core';
import { NzMessageService } from 'ng-zorro-antd';
import { NzModalService } from 'ng-zorro-antd/modal';
import { v4 as uuidv4 } from 'uuid';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy, AfterViewInit {

  // 储存数据用
  saveKey = "OP72";
  // 储存对象
  item;
  // JSON粘贴数据模态框
  showPasteModal = false;
  // 直接设置JSON数据
  jsonData = "";
  // 不覆盖背景数据
  withoutBgData = false;
  // 快速创建热区的字符串
  fastHotZoneStr = ""
  // 显示配置检查模态框
  showConfigCheckModal = false;
  // 配置检查结果
  configCheckResult = ""

  // 题目类型
  TEXT_SELECT = "0";
  IMAGE_SELECT = "1";
  AUDIO_PLAY = "2";
  HOT_ZONE_RADIO = "3";
  HOT_ZONE_CHECKBOX = "4";
  TEXTINPUT = "5";
  CONNECTION = "6";
  PRONUNCIATION_ASSESSMENT = "7";
  RIGHT_OR_WRONG = "8";
  CROSSWORD_PUZZLE = "9";
  SORT_WORDS = "10";
  CONNECTION_CHOICE = "11";
  TEXTINPUT_GROUP = "12";
  VIDEO_PLAY = "13";
  DRAWING = "14";
  DRAWING_CHECK = "15";
  CONNECTION_2LEVEL = "16";

  // 评分体系
  RS_15_5L_FAF = "0";
  RS_20_5L_FAF = "4";
  RS_25_5L_FAF = "1";
  RS_30_5L_FAF = "2";
  RS_40_5L_FAF = "5";
  RS_100_3L_FAF = "3";
  RS_120_3L_FAF = "6";

  // 评分体系 清单
  ratingSystemList = [
    {label: "15分 5段 - FAF", value: this.RS_15_5L_FAF},
    {label: "20分 5段 - FAF", value: this.RS_20_5L_FAF},
    {label: "25分 5段 - FAF", value: this.RS_25_5L_FAF},
    {label: "30分 5段 - FAF", value: this.RS_30_5L_FAF},
    {label: "40分 5段 - FAF", value: this.RS_40_5L_FAF},
    {label: "100分 3段 - FAF", value: this.RS_100_3L_FAF},
    {label: "120分 3段 - FAF", value: this.RS_120_3L_FAF},
  ]

  // 保存锁
  saveLock = true;

  @ViewChild('customHotZone', {static: true}) customHotZone: ElementRef;

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef, private nzMessageService: NzMessageService, private modal: NzModalService) {

  }

  ngOnInit() {
    this.item = {};
    // 获取存储的数据
    (<any>window).courseware.getData((data) => {
      if (data) {
        this.item = data;
      }
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
    }, this.saveKey);
  }

  saveHotZone(group, e) {
    const {bgItem, hotZoneItemArr} = e;
    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;
    this.save();
    this.nzMessageService.success('热区数据已保存');
  }

  // 快速创建热区
  handleFastCreatHotZoneItems() {
    this.fastHotZoneStr = this.fastHotZoneStr.replace(/，/g, ",");
    const hotZoneNames = this.fastHotZoneStr.split(",");
    hotZoneNames.forEach((hotZoneName, index) => {
      this.customHotZone["addHotZone"](hotZoneName);
    })
    this.fastHotZoneStr = "";
    this.nzMessageService.success('创建成功，需要保存热区');
  }

  // 添加背景图切片
  addBgImageSlice() {
    if(!this.item.hotZoneBgSliceList) {
      this.item.hotZoneBgSliceList = [];
    }
    this.item.hotZoneBgSliceList.push({
      image_url: ""
    })
    this.save()
  }

  // 添加热区配置
  addHotZoneConfig() {
    if(!this.item.hotZoneConfigArr) {
      this.item.hotZoneConfigArr = [];
    }
    this.item.hotZoneConfigArr.push({
      hotZoneType: "",
      linkHotZoneIndex: -1,
      audio_url: "",
      video_url: "",
      score: "0",
      unselectedStyle: "none",
      selectedStyle: "border",
      rightOrWrongStyleType: "symbol",
      inputText: "",
      keyWordMatch: false,
      isCaseInsensitive: false,
      openAnswer: false,
      useSelectOptionList: false,
      keyWordMatchInOrder: false,
      capitalizedFirstLetter: false,
      notAdaptContraction: false,
      textAlignLeft: false,
      selectOptionList: [
        
      ],
      contentList: [
        
      ]
    })
    this.save()
  }

  // 添加热区配置
  deleteHotZoneConfig(index) {
    if(!this.item.hotZoneConfigArr) {
      this.item.hotZoneConfigArr = [];
      return
    }

    this.item.hotZoneConfigArr.splice(index,1)
    this.save()
  }

  // 复制一个内容配置
  copyHotZoneConfig(index) {
    const copyItem = JSON.parse(JSON.stringify(this.item.hotZoneConfigArr[index]));
    this.item.hotZoneConfigArr.splice(index, 0, copyItem)
    this.save();
  }

  // 添加热区内容配置
  addHotZoneConfigItem(it) {
    if(!it.contentList) {
      it.contentList = [];
    }
  
    it.contentList = [
      ...it.contentList,
      this.getDefaultConfigContentItem()
    ];
  
    this.save();
  }

  // 删除热区内容配置
  deleteHotZoneConfigItem(it, index) {
    if(!it.contentList) {
      it.contentList = [];
    }

    it.contentList.splice(index, 1);
    it.contentList = [
      ...it.contentList
    ];

    this.save();
  }

  // 添加文字选项
  addHotzoneSelectOption(it) {
    if(!it.selectOptionList) {
      it.selectOptionList = [];
    }
  
    it.selectOptionList = [
      ...it.selectOptionList,
      {
        text: "", optionShowText: ""
      }
    ];
  
    this.save();
  }

  // 删除文字选项
  deleteHotzoneSelectOption(it, index) {
    if(!it.selectOptionList) {
      it.selectOptionList = [];
    }

    it.selectOptionList.splice(index, 1);
    it.selectOptionList = [
      ...it.selectOptionList
    ];

    this.save();
  }

  // 获取默认热区内容配置
  getDefaultConfigContentItem() {
    return {
      uuid: uuidv4(),
      text: "", // 文字选项(值)
      optionShowText: "", // 选项展示值
      image_url: "", // 图片选项
      hotZoneIndex: null, // 关联热区
      score: 0, // 默认比分
      isCorrect: false, // 是否为正确答案 [单选题]
      isCheck: false, // 是否需要勾选  [多选题]
      linkedShowText: "", // 被连接时显示的内容 [连线题]
      selectStartHotZoneIndex: null, // 起点热区索引 [连线题]
      selectEndHotZoneIndex: null, // 终点热区索引 [连线题]
      selectEndHotZoneShowIndex: null, // 被连接后 需要显示内容的热区 [连线题]
      selectStartHotZoneIndex_1: null, // 起点1热区索引 [两级连线题]
      selectEndHotZoneIndex_1: null, // 终点1热区索引 [两级连线题]
      selectStartHotZoneIndex_2: null, // 起点2热区索引 [两级连线题]
      selectEndHotZoneIndex_2: null, // 终点2热区索引 [两级连线题]

      inputText: "", // 输入文字 [文字输入组]
      keyWordMatch: false, // 关键词匹配 [文字输入组]
      keyWordMatchInOrder: false, // 有序关键词 [文字输入组]
      isCaseInsensitive: false, // 大小写不敏感 [文字输入组]
      openAnswer: false, // 开放性答案 [文字输入组]
      capitalizedFirstLetter: false, // 首字母大写 [文字输入组]
      notAdaptContraction: false, // 不进行缩写适配 [文字输入组]
      textAlignLeft: false, // 文字居左对齐 [文字输入组]

      drawingCheckCorrectColors: [], // 正确颜色 [评分画图题]
      drawingCheckStrictEqual: false, // 严格相等 [评分画图题]
    }
  }

  // 文字选择题 是否 使用独立选项配置
  handleUserSelectOptionListChange(it) {
    // 新增的配置 修复已有模板缺少这个字段的问题 
    if(!it.selectOptionList) {
      it.selectOptionList = [];
    }
    this.save();
  }

  // 添加分数组
  addScoreConfig() {
    if(!this.item.scoreConfigArr) {
      this.item.scoreConfigArr = [];
    }
    this.item.scoreConfigArr.push({
      linkHotZoneIndex: -1
    })
    this.save()
  }

  // 删除分数组
  deleteScoreConfig(index) {
    if(!this.item.scoreConfigArr) {
      this.item.scoreConfigArr = [];
      return;
    }
    this.item.scoreConfigArr.splice(index, 1);
    this.save()
  }

  // 复制数据
  copyChangeData() {
    const jsonData = this.item;
    const oInput = document.createElement('input');
    oInput.value = JSON.stringify(jsonData);
    document.body.appendChild(oInput);
    oInput.select(); // 选择对象
    document.execCommand('Copy'); // 执行浏览器复制命令
    document.body.removeChild(oInput);
    this.nzMessageService.success('复制成功');
  }

  // 直接从JSON设置数据
  handlePasteData() {
    try {
      const data = JSON.parse(this.jsonData);
      if(this.withoutBgData) {
        const bgItem = JSON.parse(JSON.stringify(this.item.bgItem));
        data.bgItem = bgItem
      }
      this.item = data;
      this.showPasteModal = false;
      this.nzMessageService.success('数据导入成功');
      this.save();
    } catch (e) {
      this.nzMessageService.error('导入失败，请检查是否是标准的JSON格式');
    }
  }

  // 点击检查配置
  handleConfigCheck() {
    this.configCheckResult = ""
    const hotZoneIndexErr = [];
    const scoreConfigErr = [];
    const otherInfo = [];
    let allScoreIndex = []
    let totalScore = 0;
    this.item.scoreConfigArr.forEach(config => {
      if(Array.isArray(config.linkHotZoneIndexArr)) {
        // 检查内容配置序号配置是否正确
        allScoreIndex = allScoreIndex.concat(config.linkHotZoneIndexArr);
        config.linkHotZoneIndexArr.forEach(hotZoneConfigIndex => {
          const hotZoneConfg = this.item.hotZoneConfigArr[hotZoneConfigIndex]
          if(hotZoneConfg != undefined) {
            switch(hotZoneConfg.hotZoneType) {
              // 文字选项检查
              case this.TEXT_SELECT: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 分数检查
                  if(contentItem.score != null && !isNaN(Number(contentItem.score)) && Number(contentItem.score) > 0) {
                    totalScore += Number(contentItem.score);
                  } else {
                    scoreConfigErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 分数配置为0或者有异常`)
                  }
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                break;
              // 热区单选
              case this.HOT_ZONE_RADIO: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 热区多选
              case this.HOT_ZONE_CHECKBOX: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 分数检查
                  if(contentItem.score != null && !isNaN(Number(contentItem.score)) && Number(contentItem.score) > 0) {
                    totalScore += Number(contentItem.score);
                  } else {
                    scoreConfigErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 分数配置为0或者有异常`)
                  }
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 文字输入
              case this.TEXTINPUT:
                // 热区配置检查
                if(hotZoneConfg.linkHotZoneIndex == null || hotZoneConfg.linkHotZoneIndex == undefined || hotZoneConfg.linkHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 关联热区为空`)
                }
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                break;
              // 连线组
              case this.CONNECTION:
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 分数检查
                  if(contentItem.score != null && !isNaN(Number(contentItem.score)) && Number(contentItem.score) > 0) {
                    totalScore += Number(contentItem.score);
                  } else {
                    scoreConfigErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 分数配置为0或者有异常`)
                  }
                  // 起点热区配置检查
                  if(contentItem.selectStartHotZoneIndex == null || contentItem.selectStartHotZoneIndex == undefined || contentItem.selectStartHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 连线起点热区为空`)
                  }
                  // 终点热区配置检查
                  if(contentItem.selectEndHotZoneIndex == null || contentItem.selectEndHotZoneIndex == undefined || contentItem.selectEndHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 连线终点热区为空`)
                  }
                });
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 判断对错
              case this.RIGHT_OR_WRONG: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 分数检查
                  if(contentItem.score != null && !isNaN(Number(contentItem.score)) && Number(contentItem.score) > 0) {
                    totalScore += Number(contentItem.score);
                  } else {
                    scoreConfigErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 分数配置为0或者有异常`)
                  }
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 纵横字谜
              case this.CROSSWORD_PUZZLE: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 单词排序
              case this.SORT_WORDS:
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                // 关联热区配置检查
                if(hotZoneConfg.linkHotZoneIndex == null || hotZoneConfg.linkHotZoneIndex == undefined || hotZoneConfg.linkHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 关联热区为空`)
                }
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 语音评测
              case this.PRONUNCIATION_ASSESSMENT:
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                // 关联热区配置检查
                if(hotZoneConfg.linkHotZoneIndex == null || hotZoneConfg.linkHotZoneIndex == undefined || hotZoneConfg.linkHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 关联热区为空`)
                }
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                break;
              // 连线选择
              case this.CONNECTION_CHOICE:
                // 分数检查
                if(hotZoneConfg.score != null && !isNaN(Number(hotZoneConfg.score)) && Number(hotZoneConfg.score) > 0) {
                  totalScore += Number(hotZoneConfg.score);
                } else {
                  scoreConfigErr.push(`内容${hotZoneConfigIndex+1}: 分数配置为0或者有异常`)
                }
                // 关联热区配置检查
                if(hotZoneConfg.linkHotZoneIndex == null || hotZoneConfg.linkHotZoneIndex == undefined || hotZoneConfg.linkHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 关联热区为空`)
                }
                // 结果显示热区配置检查
                if(hotZoneConfg.linkResultShowHotZoneIndex == null || hotZoneConfg.linkResultShowHotZoneIndex == undefined || hotZoneConfg.linkResultShowHotZoneIndex < 0) {
                  hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1}: 结果显示热区为空`)
                }
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                break;
              // 文字输入组
              case this.TEXTINPUT_GROUP: 
                hotZoneConfg.contentList.forEach((contentItem, contentIndex) => {
                  // 分数检查
                  if(contentItem.score != null && !isNaN(Number(contentItem.score)) && Number(contentItem.score) > 0) {
                    totalScore += Number(contentItem.score);
                  } else {
                    scoreConfigErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 分数配置为0或者有异常`)
                  }
                  // 热区配置检查
                  if(contentItem.selectHotZoneIndex == null || contentItem.selectHotZoneIndex == undefined || contentItem.selectHotZoneIndex < 0) {
                    hotZoneIndexErr.push(`内容${hotZoneConfigIndex+1} - 内容清单${contentIndex+1}: 关联热区为空`)
                  }
                });
                break;
              default:;
            }
          }
        });
      }
    });

    if(this.item.basicScore != null && !isNaN(Number(this.item.basicScore)) && Number(this.item.basicScore) > 0) {
      totalScore += Number(this.item.basicScore);
      otherInfo.push(`配置了基础分: ${this.item.basicScore}`)
    }

    if(this.item.ratingSystem) {
      const ratingSys = this.ratingSystemList.find(item => item.value == this.item.ratingSystem);
      if(ratingSys == undefined) {
        otherInfo.push(`评分体系: 未知错误`)
      } else {
        otherInfo.push(`评分体系: ${ratingSys.label}`)
      }
    } else {
      otherInfo.push(`评分体系: 空`)
    }

    // 取整 防止有很长的小数 - 有的分值是5.000000000000004这种
    let _totalScore = Math.floor(totalScore * 100) / 100;
    totalScore = parseFloat(_totalScore + "");
    
    this.item.hotZoneConfigArr.forEach((content, contentIndex) => {
      if(content.hotZoneType != this.AUDIO_PLAY && content.hotZoneType != this.VIDEO_PLAY && content.hotZoneType != this.DRAWING) {
        if(allScoreIndex.indexOf(contentIndex) == -1) {
          scoreConfigErr.push((`内容${contentIndex+1}: 没有被配置到题目内容中，请检查分数配置`))
        }
      }
    });

    if(hotZoneIndexErr.length == 0) {
      this.configCheckResult += "【热区配置检查】通过\n"
    } else {
      this.configCheckResult += `【热区配置检查】${hotZoneIndexErr.length}处\n`
      this.configCheckResult += hotZoneIndexErr.join("\n");
    }

    if(scoreConfigErr.length == 0) {
      this.configCheckResult += "\n\n【分数配置检查】通过\n"
    } else {
      this.configCheckResult += `\n\n【分数配置检查】${scoreConfigErr.length}处\n`
      this.configCheckResult += scoreConfigErr.join("\n");
    }

    if(otherInfo.length == 0) {
      this.configCheckResult += "\n\n【其他信息】无\n"
    } else {
      this.configCheckResult += `\n\n【其他信息】${otherInfo.length}条\n`
      this.configCheckResult += otherInfo.join("\n");
    }

    this.configCheckResult += `\n\n总分：【${totalScore}】`

  }

  // 点击跳转到页面底部
  handleClickScrollBottom() {
    window.scrollTo(0, document.documentElement.scrollHeight)
  }

  ngAfterViewInit() {

  }

  ngOnChanges() {

  }

  ngOnDestroy() {

  }

  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item=null) {
    if (!item) {
      item = this.item;
    }

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, item=null) {
    if (item == null) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  onVideoUploadSuccess(e, key, item=null) {
    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    if(this.saveLock) {
      console.warn("数据锁开启，修改未保存")
    } else {
      (<any>window).courseware.setData(this.item, null, this.saveKey);
      this.refresh();
      console.log(this.item)
    }
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}
