cc.Class({
    extends: cc.Component,

    properties: {
        camera: cc.Camera,
        // _canvas: null
    },

   
    init (drawPanelCenter) {

        this.drawPanelCenter = drawPanelCenter;
        const box = this.drawPanelCenter.box;
        
        const canvas = cc.find("Canvas");

        if (!this.camera) {
            this.camera = this.node.addComponent(cc.Camera); 
        }
        // this.camera.alignWithScreen = false;
        // this.camera.orthoSize = 400;

        // this.camera.backgroundColor = new cc.Color(0, 0, 0, 0);

        // console.log(" this.drawPanelCenter.box: ",  this.drawPanelCenter.box);

        let texture = new cc.RenderTexture();
        
        // texture.setPremultiplyAlpha(true);

        texture.initWithSize( canvas.width, canvas.height, cc.RenderTexture.DepthStencilFormat.RB_FMT_S8);
        this.camera.targetTexture = texture;
        this.texture = texture;
    },
   
  
    
    // show on the canvas
    showImage (img) {

        // console.log('img: ', img);
        let texture = new cc.Texture2D();
        texture.initWithElement(img);

        texture.setPremultiplyAlpha(true);


        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);

        console.log("spriteFrame.getRect(): ", spriteFrame.getRect());

        // spriteFrame.setRect( this.drawPanelCenter.box );

        let node = new cc.Node();
        let sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;
        // node.x += 100;

        // sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;

        // const box = this.drawPanelCenter.box

        // const rect = new cc.Rect(box.x +3.5, box.y + 70.5, box.width, box.height)
        // spriteFrame.setRect( rect );

        // this.drawPanelCenter.addChild(node, 1);
        // if (this.drawLinePicCallback) {
        //     this.drawLinePicCallback(node);
        // }

        return node;

        node.zIndex = cc.macro.MAX_ZINDEX;
        node.parent = cc.director.getScene();
        // set position
        let width = cc.winSize.width;
        let height = cc.winSize.height;
        node.x = width / 2;
        node.y = height / 2;
        // node.on(cc.Node.EventType.TOUCH_START, () => {
        //     node.parent = null;
        //     node.destroy();
        // });

        // this.captureAction(node, width, height);
    },
    // sprite action
    captureAction (capture, width, height) {
        let scaleAction = cc.scaleTo(1,0.3);
        let targetPos = cc.v2(width - width / 6,  height / 4);
        let moveAction = cc.moveTo(1, targetPos); 
        let spawn = cc.spawn(scaleAction, moveAction);
        capture.runAction(spawn);
        let blinkAction = cc.blink(0.1, 1);
        // scene action
        this.node.runAction(blinkAction);
    },




    cleanTouchPointArr(touchPointArr) {
        for (let i=0; i<touchPointArr.length; i++) {
            if (touchPointArr[i]) {
                touchPointArr[i].removeFromParent();
            }
        }
    },
});
