import EventMgr from '../../script/EventMgr'
import BezierRender from "./bezier-render";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Page extends cc.Component {
    @property({ type: cc.Node, displayName: "图片节点" })
    public page: cc.Node = null

    @property({ type: BezierRender, displayName: "贝塞尔曲线" })
    public bezierRender: BezierRender = null

    // @property({ type: VerletRender, displayName: "Verlet积分算法" })
    // public verletRender: VerletRender = null

    onLoad() {
        EventMgr.on("page_to_left", (msg, page) => {
            console.log(this.node.data, page)
            if(this.node.data && this.node.data.page == page) {
                // 判断是否是当前实例进行翻页
                this.pageToLeft();
            }
        }, null)
        EventMgr.on("page_to_right", (msg, page) => {
            if(this.node.data && this.node.data.page == page) {
                // 判断是否是当前实例进行翻页
                this.pageToRight();
            }
        }, null)
    }
    
    pageToAngle(angle) {
        this.bezierRender.updateAngle(angle)
    }

    pageToLeft() {
        let angle = 0;
        let inter = setInterval(() => {
            angle += 15;
            if (angle > 180) {
                angle = 180;
                clearInterval(inter);
            }
            this.bezierRender.updateAngle(angle)
        }, 30)
    }
    pageToRight() {
        let angle = 180;
        let inter = setInterval(() => {
            angle -= 15;
            if (angle < 0) {
                angle = 0;
                clearInterval(inter);
            }
            this.bezierRender.updateAngle(angle)
        }, 30)
    }
}
