cc.Class({
    extends: require('./textureRenderUtils'),

  
    start () {
   
    },

    capture(drawPanelCenter, touchPointArr, id) {
        this.init(drawPanelCenter);
        // create capture
        this.createCanvas();
        var img = this.createImg();
        
        return new Promise((resovle, reject) => {
            this.scheduleOnce(() => {
                const picNode = this.showImage(img);
                picNode.id = id;
                // this.cleanTouchPointArr(touchPointArr);
                drawPanelCenter.addChild(picNode, 1);
                if (this.drawLinePicCallback) {
                    this.drawLinePicCallback(picNode);
                }
                resovle(picNode)
            }, 1);
        })
    },

     // create the img element
     createImg () {
        // return the type and dataUrl
        var dataURL = this._canvas.toDataURL("image/jpg");
        var img = document.createElement("img");
        img.src = dataURL;
        return img;
    },

    clearCanvas () {
        let ctx = this._canvas.getContext('2d');
        ctx.clearRect(0, 0, this._canvas.width, this._canvas.height);
    },

      // create the canvas and context, filpY the image Data
      createCanvas () {
        let width = this.texture.width;
        let height = this.texture.height;
        if (!this._canvas) {
            this._canvas = document.createElement('canvas');

            this._canvas.width = width;
            this._canvas.height = height;
        }
        else {
            this.clearCanvas();
        }
        let ctx = this._canvas.getContext('2d');
        this.camera.render();
        let data = this.texture.readPixels();
        // write the render data
        let rowBytes = width * 4; 
        for (let row = 0; row < height; row++) {
            let srow = height - 1 - row;
            let imageData = ctx.createImageData(width, 1);
            let start = srow * width * 4;
            for (let i = 0; i < rowBytes; i++) {
                imageData.data[i] = data[start + i];
            }

            ctx.putImageData(imageData, 0, row);
        }
        return this._canvas;
    },
});