// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    start () {
        this.moveDis = 0;
        this.startX = 0;
        this.isMoving = false;
        this.node.on(cc.Node.EventType.TOUCH_START, (e)=>{
            this.startX = e.getLocationX();
        })
        
        this.node.on(cc.Node.EventType.TOUCH_MOVE, (e)=>{
            if(!this.isMoving && Math.abs(this.startX - e.getLocationX()) > 50) {
                this.node.emit("myMoveStart", this.startX);
                this.isMoving = true;
            }
            this.node.emit("myTouchMoving", e.getLocationX())
        })

        this.node.on(cc.Node.EventType.TOUCH_END, (e)=>{
            this.isMoving = false;
            this.node.emit("myMoveEnd");
        })
    },

    // update (dt) {},
});
