"use strict";
cc._RF.push(module, 'f4edeRi+NdAabqAkVYRwFjK', 'ET04');
// ET04/scene/ET04.js

"use strict";

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * 主场景 v1.2
 */
cc.Class({
  "extends": cc.Component,
  properties: {
    // 标题
    title: {
      "default": null,
      type: cc.Label
    },
    // 选项容器（带声音）
    sounds_container: {
      "default": null,
      type: cc.Node
    },
    // 选项容器（图片）
    pic_container: {
      "default": null,
      type: cc.Node
    },
    // 选项（带声音）
    op_sound: {
      "default": null,
      type: cc.Prefab
    },
    // 选项（图片）
    op_pic: {
      "default": null,
      type: cc.Prefab
    },
    // 声音，0-进入，1-结束
    sounds: {
      "default": [],
      type: [cc.AudioClip]
    },
    particle_paper: {
      "default": null,
      type: cc.Node
    },
    _opSoundPos: [],
    // 选框位置
    _opPicPos: [],
    // 图片位置
    _rightCount: 0 // 正确个数

  },
  onEnable: function onEnable() {
    cc.game.on("RIGHT", this.answerRight, this);
  },
  onDisable: function onDisable() {
    cc.game.off("RIGHT", this.answerRight, this);
  },
  // 生命周期 onLoad
  onLoad: function onLoad() {
    this.initSceneData();
    this.initSize(); // 开启碰撞检查

    var manager = cc.director.getCollisionManager();
    manager.enabled = true;
  },
  _imageResList: null,
  _audioResList: null,
  _animaResList: null,
  initSceneData: function initSceneData() {
    this._imageResList = [];
    this._audioResList = [];
    this._animaResList = [];
  },
  _designSize: null,
  // 设计分辨率
  _frameSize: null,
  // 屏幕分辨率
  _mapScaleMin: null,
  // 场景中常用缩放（取大值）
  _mapScaleMax: null,
  // 场景中常用缩放（取小值）
  _cocosScale: null,
  // cocos 自缩放 （较少用到）
  initSize: function initSize() {
    // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
    var screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height;
    var design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height;
    var f = screen_size >= design_size;
    cc.Canvas.instance.fitHeight = f;
    cc.Canvas.instance.fitWidth = !f;
    var frameSize = cc.view.getFrameSize();
    this._frameSize = frameSize;
    this._designSize = cc.view.getDesignResolutionSize();
    var sx = cc.winSize.width / frameSize.width;
    var sy = cc.winSize.height / frameSize.height;
    this._cocosScale = Math.min(sx, sy);
    sx = frameSize.width / this._designSize.width;
    sy = frameSize.height / this._designSize.height;
    this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
    this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
  },
  // 生命周期 start
  start: function start() {
    var _this = this;

    var getData = this.getData.bind(this);

    if (window && window.courseware) {
      getData = window.courseware.getData;
    }

    getData(function (data) {
      console.log("data:", data);
      _this.data = data || _this.getDefaultData();
      _this.data = JSON.parse(JSON.stringify(_this.data));

      _this.preloadItem();
    });
  },
  getData: function getData(cb) {
    cb(this.getDefaultData());
  },
  getDefaultData: function getDefaultData() {
    var dataJson = '{"title":"hello","audio_title":"http://staging-teach.cdn.ireadabc.com/f7fb9f71ab7d460ac2f78c85efba7610.mp3","options":[{"pic_url":"http://staging-teach.cdn.ireadabc.com/004be996ea209e366951a7c4b6a3e55f.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/785b0bc1766658373e4ebdcbd694a088.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/5433aa00faced2d5e02f9cecce63ba09.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/784cd4188bf126d6c3c9395d9a807619.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/784cd4188bf126d6c3c9395d9a807619.mp3"}]}';
    var data = JSON.parse(dataJson);
    return data;
  },
  preloadItem: function preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.addPreloadAnima();
    this.preload();
  },
  addPreloadImage: function addPreloadImage() {
    for (var i = 0; i < this.data.options; i++) {
      this._imageResList.push({
        url: this.data.options[i]["pic_url_" + i]
      });
    }
  },
  addPreloadAudio: function addPreloadAudio() {
    for (var i = 0; i < this.data.total; i++) {
      this._audioResList.push({
        url: this.data.options[i]["audio_url_" + i]
      });
    }
  },
  addPreloadAnima: function addPreloadAnima() {},
  preload: function preload() {
    var _this2 = this;

    var preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);

    cc.assetManager.loadAny(preloadArr, null, null, function (err, data) {
      _this2.loadEnd();

      if (window && window["air"]) {
        window["air"].hideAirClassLoading();
      }

      cc.debug.setDisplayStats(false);
    });
  },
  loadEnd: function loadEnd() {
    this.initData();
    this.initAudio();
    this.initView();
  },
  _cantouch: null,
  initData: function initData() {
    // 所有全局变量 默认都是null
    this._cantouch = true;
  },
  audioBtn: null,
  initAudio: function initAudio() {
    var audioNode = cc.find("Canvas/res/audio");

    var getAudioByResName = function getAudioByResName(resName) {
      return audioNode.getChildByName(resName).getComponent(cc.AudioSource);
    };

    this.audioBtn = getAudioByResName("btn");
  },
  initView: function initView() {
    this.initBg();
    this.initPic();
    this.playSound(0); // 初始化title

    this.title.string = this.data.title;
    var self = this;
    var scale = 1;
    var count = this.data.options.length - 4;

    if (count > 0) {
      scale = 1 - count * 0.16;
    }

    this.pic_container.scale = scale;
    this.sounds_container.scale = scale;

    for (var i = 0; i < this.data.options.length; i++) {
      var op_s = cc.instantiate(this.op_sound);
      op_s.getComponent("op_sound")._opId = i;
      op_s.getComponent("op_sound")._soundUrl = this.data.options[i].audio_url;
      this.sounds_container.addChild(op_s);
      var op_p = cc.instantiate(this.op_pic);
      op_p.getComponent("op_pic")._opId = i;
      op_p.getComponent("op_pic")._scale = scale;
      op_p.getComponent("op_pic")._picUrl = this.data.options[i].pic_url;
      this.pic_container.addChild(op_p);
    }

    this.scheduleOnce(function () {
      self.pic_container.getComponent(cc.Layout).enabled = false;
      self.sounds_container.getComponent(cc.Layout).enabled = false;

      for (var _iterator = _createForOfIteratorHelperLoose(this.sounds_container.children), _step; !(_step = _iterator()).done;) {
        var o = _step.value;

        this._opSoundPos.push(o.getPosition());
      }

      for (var _iterator2 = _createForOfIteratorHelperLoose(this.pic_container.children), _step2; !(_step2 = _iterator2()).done;) {
        var _o = _step2.value;

        this._opPicPos.push(_o.getPosition());
      }

      this._opPicPos.sort(this.randomsort);

      this._opSoundPos.sort(this.randomsort);

      for (var _i = 0; _i < this.sounds_container.children.length; _i++) {
        this.sounds_container.children[_i].setPosition(this._opSoundPos[_i]);

        this.pic_container.children[_i].setPosition(this._opPicPos[_i]);

        this.pic_container.children[_i].getComponent("op_pic")._ori_pos = this._opPicPos[_i];

        this.pic_container.children[_i].getComponent("op_pic").setPic();
      }
    }, 0.5);
  },
  initBg: function initBg() {
    var bgNode = cc.find("Canvas/bg");
    bgNode.scale = this._mapScaleMax;
  },
  pic1: null,
  pic2: null,
  initPic: function initPic() {
    var _this3 = this;

    var canvas = cc.find("Canvas");
    var maxW = canvas.width * 0.7;
    this.getSprNodeByUrl(this.data.pic_url, function (sprNode) {
      var picNode1 = sprNode;
      picNode1.scale = maxW / picNode1.width;
      picNode1.baseX = picNode1.x;
      canvas.addChild(picNode1);
      _this3.pic1 = picNode1;
      var labelNode = new cc.Node();
      labelNode.color = cc.Color.YELLOW;
      var label = labelNode.addComponent(cc.Label);
      label.string = _this3.data.text;
      label.fontSize = 60;
      label.lineHeight = 60;
      label.font = cc.find("Canvas/res/font/BRLNSDB").getComponent("cc.Label").font;
      picNode1.addChild(labelNode);
    });
    this.getSprNodeByUrl(this.data.pic_url_2, function (sprNode) {
      var picNode2 = sprNode;
      picNode2.scale = maxW / picNode2.width;
      canvas.addChild(picNode2);
      picNode2.x = canvas.width;
      picNode2.baseX = picNode2.x;
      _this3.pic2 = picNode2;
      var labelNode = new cc.Node();
      var label = labelNode.addComponent(cc.RichText);
      var size = 60;
      label.font = cc.find("Canvas/res/font/BRLNSDB").getComponent(cc.Label).font;
      label.string = "<outline color=#751e00 width=4><size=" + size + "><color=#ffffff>" + _this3.data.text + "</color></size></outline>";
      label.lineHeight = size;
      picNode2.addChild(labelNode);
    });
  },
  // ------------------------------------------------
  getSprNode: function getSprNode(resName) {
    var sf = cc.find("Canvas/res/img/" + resName).getComponent(cc.Sprite).spriteFrame;
    var node = new cc.Node();
    node.addComponent(cc.Sprite).spriteFrame = sf;
    return node;
  },
  getSpriteFrimeByUrl: function getSpriteFrimeByUrl(url, cb) {
    cc.loader.load({
      url: url
    }, function (err, img) {
      var spriteFrame = new cc.SpriteFrame(img);

      if (cb) {
        cb(spriteFrame);
      }
    });
  },
  getSprNodeByUrl: function getSprNodeByUrl(url, cb) {
    var node = new cc.Node();
    var spr = node.addComponent(cc.Sprite);
    this.getSpriteFrimeByUrl(url, function (sf) {
      spr.spriteFrame = sf;

      if (cb) {
        cb(node);
      }
    });
  },
  playAudioByUrl: function playAudioByUrl(audio_url, cb) {
    if (cb === void 0) {
      cb = null;
    }

    if (audio_url) {
      cc.assetManager.loadRemote(audio_url, function (err, audioClip) {
        cc.audioEngine.play(audioClip, false);
      });
    }
  },
  // 播放声音
  playSound: function playSound(index) {
    cc.audioEngine.playEffect(this.sounds[index], false);
  },
  randomsort: function randomsort(a, b) {
    return Math.random() > 0.5 ? 1 : -1;
  },
  playTitle: function playTitle() {
    cc.assetManager.loadRemote(this.data.audio_title, function (err, audioClip) {
      cc.audioEngine.playEffect(audioClip, false);
    });
  },
  answerRight: function answerRight() {
    this._rightCount++;

    if (this._rightCount == this.data.options.length) {
      this.scheduleOnce(function () {
        this.playSound(1);
        this.particle_paper.active = true;
        this.scheduleOnce(function () {
          this.particle_paper.active = false;
        }, 5);
      }, 1);
    }
  } // ------------------------------------------

});

cc._RF.pop();