/**
 * 主场景 v1.2
 */

cc.Class({
    extends: cc.Component,

    properties: {
        // 标题
        title: {
            default: null,
            type: cc.Label,
        },

        // 选项容器（带声音）
        sounds_container: {
            default: null,
            type: cc.Node,
        },

        // 选项容器（图片）
        pic_container: {
            default: null,
            type: cc.Node,
        },

        // 选项（带声音）
        op_sound: {
            default: null,
            type: cc.Prefab,
        },

        // 选项（图片）
        op_pic: {
            default: null,
            type: cc.Prefab,
        },

        // 声音，0-进入，1-结束
        sounds: {
            default: [],
            type: [cc.AudioClip],
        },

        particle_paper: {
            default: null,
            type: cc.Node,
        },

        _opSoundPos: [], // 选框位置
        _opPicPos: [], // 图片位置
        _rightCount: 0, // 正确个数
    },

    onEnable() {
        cc.game.on("RIGHT", this.answerRight, this);
    },

    onDisable() {
        cc.game.off("RIGHT", this.answerRight, this);
    },

    // 生命周期 onLoad
    onLoad() {
        this.initSceneData();
        this.initSize();

        // 开启碰撞检查
        var manager = cc.director.getCollisionManager();
        manager.enabled = true;
    },

    _imageResList: null,
    _audioResList: null,
    _animaResList: null,
    initSceneData() {
        this._imageResList = [];
        this._audioResList = [];
        this._animaResList = [];
    },

    _designSize: null, // 设计分辨率
    _frameSize: null, // 屏幕分辨率
    _mapScaleMin: null, // 场景中常用缩放（取大值）
    _mapScaleMax: null, // 场景中常用缩放（取小值）
    _cocosScale: null, // cocos 自缩放 （较少用到）

    initSize() {
        // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
        let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height;
        let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height;
        let f = screen_size >= design_size;
        cc.Canvas.instance.fitHeight = f;
        cc.Canvas.instance.fitWidth = !f;

        const frameSize = cc.view.getFrameSize();
        this._frameSize = frameSize;

        this._designSize = cc.view.getDesignResolutionSize();

        let sx = cc.winSize.width / frameSize.width;
        let sy = cc.winSize.height / frameSize.height;
        this._cocosScale = Math.min(sx, sy);

        sx = frameSize.width / this._designSize.width;
        sy = frameSize.height / this._designSize.height;
        this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
        this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
    },

    // 生命周期 start
    start() {
        let getData = this.getData.bind(this);
        if (window && window.courseware) {
            getData = window.courseware.getData;
        }

        getData((data) => {
            console.log("data:", data);
            this.data = data || this.getDefaultData();
            this.data = JSON.parse(JSON.stringify(this.data));
            this.preloadItem();
        });
    },

    getData(cb) {
        cb(this.getDefaultData());
    },

    getDefaultData() {
        const dataJson =
            '{"title":"hello","audio_title":"http://staging-teach.cdn.ireadabc.com/f7fb9f71ab7d460ac2f78c85efba7610.mp3","options":[{"pic_url":"http://staging-teach.cdn.ireadabc.com/004be996ea209e366951a7c4b6a3e55f.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/785b0bc1766658373e4ebdcbd694a088.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/5433aa00faced2d5e02f9cecce63ba09.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/fff5204fc774e932bcd597b4094b0852.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/784cd4188bf126d6c3c9395d9a807619.mp3"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/9298013cc63aa40035dbd18f1f8380a8.jpeg","audio_url":"http://staging-teach.cdn.ireadabc.com/784cd4188bf126d6c3c9395d9a807619.mp3"}]}';
        const data = JSON.parse(dataJson);
        return data;
    },

    preloadItem() {
        this.addPreloadImage();
        this.addPreloadAudio();
        this.addPreloadAnima();
        this.preload();
    },

    addPreloadImage() {
        for (var i = 0; i < this.data.options; i++) {
            this._imageResList.push({ url: this.data.options[i]["pic_url_" + i] });
        }
    },

    addPreloadAudio() {
        for (var i = 0; i < this.data.total; i++) {
            this._audioResList.push({ url: this.data.options[i]["audio_url_" + i] });
        }
    },

    addPreloadAnima() {},

    preload() {
        const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
        cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
            this.loadEnd();
            if (window && window["air"]) {
                window["air"].hideAirClassLoading();
            }

            cc.debug.setDisplayStats(false);
        });
    },

    loadEnd() {
        this.initData();
        this.initAudio();
        this.initView();
    },

    _cantouch: null,
    initData() {
        // 所有全局变量 默认都是null
        this._cantouch = true;
    },

    audioBtn: null,
    initAudio() {
        const audioNode = cc.find("Canvas/res/audio");

        const getAudioByResName = (resName) => {
            return audioNode.getChildByName(resName).getComponent(cc.AudioSource);
        };

        this.audioBtn = getAudioByResName("btn");
    },

    initView() {
        this.initBg();
        this.initPic();

        this.playSound(0);
        // 初始化title
        this.title.string = this.data.title;
        var self = this;

        let scale = 1;
        let count = this.data.options.length;
        switch(count) {
            case 1: scale = 1; break;
            case 2: scale = 1; break;
            case 3: scale = 1; break;
            case 4: scale = 1; break;
            case 5: scale = 0.85; break;
            case 6: scale = 0.7; break;
            case 7: scale = 0.6; break;
            case 8: scale = 0.5; break;
            case 9: scale = 0.45; break;
            case 10: scale = 0.4; break;
            case 11: scale = 0.37; break;
            case 12: scale = 0.35; break;
            case 13: scale = 0.32; break;
            case 14: scale = 0.3; break;
            case 15: scale = 0.28; break;
            case 16: scale = 0.26; break;
            case 17: scale = 0.24; break;
            case 18: scale = 0.22; break;
            case 19: scale = 0.2; break;
            case 20: scale = 0.18; break;
            default: scale = 0.16;
        }

        this.pic_container.scale = scale;
        this.sounds_container.scale = scale;

        for (let i = 0; i < this.data.options.length; i++) {
            const op_s = cc.instantiate(this.op_sound);
            op_s.getComponent("op_sound")._opId = i;
            op_s.getComponent("op_sound")._soundUrl = this.data.options[i].audio_url;
            this.sounds_container.addChild(op_s);

            const op_p = cc.instantiate(this.op_pic);
            op_p.getComponent("op_pic")._opId = i;
            op_p.getComponent("op_pic")._scale = scale;
            op_p.getComponent("op_pic")._picUrl = this.data.options[i].pic_url;
            this.pic_container.addChild(op_p);
        }

        this.scheduleOnce(function () {
            self.pic_container.getComponent(cc.Layout).enabled = false;
            self.sounds_container.getComponent(cc.Layout).enabled = false;
            for (let o of this.sounds_container.children) {
                this._opSoundPos.push(o.getPosition());
            }
            for (let o of this.pic_container.children) {
                this._opPicPos.push(o.getPosition());
            }

            this._opPicPos.sort(this.randomsort);
            this._opSoundPos.sort(this.randomsort);

            for (let i = 0; i < this.sounds_container.children.length; i++) {
                this.sounds_container.children[i].setPosition(this._opSoundPos[i]);
                this.pic_container.children[i].setPosition(this._opPicPos[i]);
                this.pic_container.children[i].getComponent("op_pic")._ori_pos = this._opPicPos[i];
                this.pic_container.children[i].getComponent("op_pic").setPic();
            }
        }, 0.5);
    },

    initBg() {
        const bgNode = cc.find("Canvas/bg");
        bgNode.scale = this._mapScaleMax;
    },

    pic1: null,
    pic2: null,
    initPic() {
        const canvas = cc.find("Canvas");
        const maxW = canvas.width * 0.7;

        this.getSprNodeByUrl(this.data.pic_url, (sprNode) => {
            const picNode1 = sprNode;
            picNode1.scale = maxW / picNode1.width;
            picNode1.baseX = picNode1.x;
            canvas.addChild(picNode1);
            this.pic1 = picNode1;

            const labelNode = new cc.Node();
            labelNode.color = cc.Color.YELLOW;
            const label = labelNode.addComponent(cc.Label);
            label.string = this.data.text;
            label.fontSize = 60;
            label.lineHeight = 60;
            label.font = cc.find("Canvas/res/font/BRLNSDB").getComponent("cc.Label").font;
            picNode1.addChild(labelNode);
        });

        this.getSprNodeByUrl(this.data.pic_url_2, (sprNode) => {
            const picNode2 = sprNode;
            picNode2.scale = maxW / picNode2.width;
            canvas.addChild(picNode2);
            picNode2.x = canvas.width;
            picNode2.baseX = picNode2.x;
            this.pic2 = picNode2;

            const labelNode = new cc.Node();
            const label = labelNode.addComponent(cc.RichText);
            const size = 60;
            label.font = cc.find("Canvas/res/font/BRLNSDB").getComponent(cc.Label).font;
            label.string = `<outline color=#751e00 width=4><size=${size}><color=#ffffff>${this.data.text}</color></size></outline>`;
            label.lineHeight = size;
            picNode2.addChild(labelNode);
        });
    },

    // ------------------------------------------------
    getSprNode(resName) {
        const sf = cc.find("Canvas/res/img/" + resName).getComponent(cc.Sprite).spriteFrame;
        const node = new cc.Node();
        node.addComponent(cc.Sprite).spriteFrame = sf;
        return node;
    },

    getSpriteFrimeByUrl(url, cb) {
        cc.loader.load({ url }, (err, img) => {
            const spriteFrame = new cc.SpriteFrame(img);
            if (cb) {
                cb(spriteFrame);
            }
        });
    },

    getSprNodeByUrl(url, cb) {
        const node = new cc.Node();
        const spr = node.addComponent(cc.Sprite);
        this.getSpriteFrimeByUrl(url, (sf) => {
            spr.spriteFrame = sf;
            if (cb) {
                cb(node);
            }
        });
    },

    playAudioByUrl(audio_url, cb = null) {
        if (audio_url) {
            cc.assetManager.loadRemote(audio_url, (err, audioClip) => {
                cc.audioEngine.play(audioClip, false);
            });
        }
    },

    // 播放声音
    playSound(index) {
        cc.audioEngine.playEffect(this.sounds[index], false);
    },

    randomsort(a, b) {
        return Math.random() > 0.5 ? 1 : -1;
    },

    playTitle() {
        cc.assetManager.loadRemote(this.data.audio_title, (err, audioClip) => {
            cc.audioEngine.playEffect(audioClip, false);
        });
    },

    answerRight() {
        this._rightCount++;
        if (this._rightCount == this.data.options.length) {
            this.scheduleOnce(function () {
                this.playSound(1);
                this.particle_paper.active = true;

                this.scheduleOnce(function () {
                    this.particle_paper.active = false;
                }, 5);
            }, 1);
        }
    },

    // ------------------------------------------
});
