/**
 * 选项，图片
 */

cc.Class({
    extends: cc.Component,

    properties: {
        // 图片
        pic: {
            default: null,
            type: cc.Sprite,
        },

        // 图片选中底图
        pic_selected: {
            default: null,
            type: cc.Node,
        },

        // 声音，0-正确，1-错误
        sounds: {
            default: [],
            type: [cc.AudioClip],
        },

        _opId: 0, // 选项id
        _ori_pos: null, // 初始位置
        _isEnter: false, // 是否碰到对的选框
        _isContact: false, // 是否碰到了选项框
        _soundOp: null, // 碰到的选框
        _picUrl: null, // 图片地址
        _spriteFrame: null,
        _width: null,
        _height: null,
        _isMoved: false,
        _scale: 1,
        _canMove: true, // 移动开关 防止其他卡片还没有完成移动 就触发了新的卡片移动
    },

    onEnable() {
        cc.game.on("SELECT", this.selected, this);
        cc.game.on("MOVE_CONTROL", this.moveControl, this);
    },

    onDisable() {
        cc.game.off("SELECT", this.selected, this);
        cc.game.on("MOVE_CONTROL", this.moveControl, this);
    },

    onLoad() {
        this.scheduleOnce(function () {
            this._ori_pos = this.node.getPosition();
        }, 0.5);

        this.node.on("touchstart", this.onTouchStart, this);
        this.node.on("touchmove", this.onTouchMove, this);
        this.node.on("touchend", this.onTouchEnd, this);
        this.node.on("touchcancel", this.onTouchEnd, this);
    },

    setPic() {
        cc.loader.load({ url: this._picUrl }, (err, img) => {
            let frame = new cc.SpriteFrame(img);
            let frameSize = frame.getOriginalSize();
            this._spriteFrame = frame;

            let scale = 1;

            let scaleX = cale = 168 / frameSize.width;
            let scaleY = cale = 168 / frameSize.height;
            scale = scaleX <= scaleY ? scaleX : scaleY

            this.pic.spriteFrame = frame;
            this.pic.node.width = frameSize.width * scale;
            this.pic.node.height = frameSize.height * scale;

            this._width = this.pic.node.width;
            this._height = this.pic.node.height;
        });
    },

    onTouchStart(event) {
        if(!this._canMove) {
            // 禁止移动
            return
        }
        this.pic_selected.active = true;
        cc.game.emit("SELECT", this._opId);
    },

    //触摸移动；
    onTouchMove(touch, event) {
        if(!this._canMove) {
            // 禁止移动
            return
        }
        let delta = touch.getDelta();
        this.node.x += delta.x / this._scale;
        this.node.y += delta.y / this._scale;

        this._isMoved = true;
    },
    onTouchEnd() {
        if (this._isContact && !this._soundOp.node.getComponent("op_sound")._isRight) {
            if (this._isEnter) {
                console.log("enter right");
                cc.game.emit("STOP_ALL_AUDIO");
                this.playSound(0);
                this._soundOp.node.getComponent("op_sound").correct(this._spriteFrame, this._width, this._height);
                this.node.destroy();
            } else {
                console.log("enter false");
                cc.game.emit("STOP_ALL_AUDIO");
                cc.game.emit("MOVE_CONTROL", false); // 广播事件 全集禁止拖动
                this.playSound(1);
                this.node.active = false;
                this._soundOp.node.getComponent("op_sound").wrong(this._spriteFrame, this._width, this._height);
            }
        } else {
            this.node.setPosition(this._ori_pos);
        }

        if (this._isMoved) {
            this._isMoved = false;
            this.pic_selected.active = false;
        }
    },

    // 移动控制
    moveControl(status) {
        this._canMove = status?true:false;
    },

    /**
     * 当碰撞产生的时候调用
     * @param  {Collider} other 产生碰撞的另一个碰撞组件
     * @param  {Collider} self  产生碰撞的自身的碰撞组件
     */
    onCollisionEnter: function (other, self) {
        console.log("on collision");
        this._soundOp = other;
        this._isContact = true;
        if (other.getComponent("op_sound")._opId == this._opId) {
            this._isEnter = true;
        }
    },

    /**
     * 当碰撞结束后调用
     * @param  {Collider} other 产生碰撞的另一个碰撞组件
     * @param  {Collider} self  产生碰撞的自身的碰撞组件
     */
    onCollisionExit: function (other, self) {
        console.log("on collision exit");
        this._isEnter = false;
        this._isContact = false;
    },

    // 播放声音
    playSound(index) {
        cc.audioEngine.playEffect(this.sounds[index], false);
    },

    resetPos() {
        this.node.setPosition(this._ori_pos);
    },

    selected(id) {
        if (this._opId == id) {
            return;
        }
        this.pic_selected.active = false;
    },
});
