/**
 * 选项框（带播放按钮）
 */

cc.Class({
    extends: cc.Component,

    properties: {
        // 声音图标
        iconSound: {
            default: null,
            type: cc.Node,
        },

        // 声音图标
        rightFrame: {
            default: null,
            type: cc.Node,
        },

        // 声音图标
        rightPic: {
            default: null,
            type: cc.Sprite,
        },

        // 星星特效
        particle_star: {
            default: null,
            type: cc.Prefab,
        },

        _opId: 0, // 选项id
        _soundUrl: "", // 音频文件地址
        _opPic: null,
        _isRight: false,
        _isPlaying: false,
        _curAudioId: 0,
    },

    onEnable() {
        cc.game.on("STOP_ALL_AUDIO", this.onStopAudio, this);
    },
    onDisable() {
        cc.game.off("STOP_ALL_AUDIO", this.onStopAudio, this);
    },

    /**
     * 播放声音
     */
    play() {
        if (this._soundUrl != "" && !this._isPlaying) {
            cc.game.emit("STOP_ALL_AUDIO");
            this._isPlaying = true;
            cc.assetManager.loadRemote(this._soundUrl, (err, audioClip) => {
                this._curAudioId = cc.audioEngine.play(audioClip, false);
                this.iconSound.getComponent(cc.Animation).play("icon_sound_play");
                cc.audioEngine.setFinishCallback(this._curAudioId, () => {
                    this.iconSound.getComponent(cc.Animation).play("icon_sound_finish");
                    this._isPlaying = false;
                });
            });
        }
    },

    /**
     * 当碰撞产生的时候调用
     * @param  {Collider} other 产生碰撞的另一个碰撞组件
     * @param  {Collider} self  产生碰撞的自身的碰撞组件
     */
    onCollisionEnter: function (other, self) {
        this._opPic = other;
    },

    /**
     * 当碰撞结束后调用
     * @param  {Collider} other 产生碰撞的另一个碰撞组件
     * @param  {Collider} self  产生碰撞的自身的碰撞组件
     */
    onCollisionExit: function (other, self) {
        console.log("on collision exit");
    },

    correct(spriteFrame, width, height) {
        this.rightFrame.active = true;
        this.rightPic.node.width = width;
        this.rightPic.node.height = height;
        this.rightPic.spriteFrame = spriteFrame;

        var par = cc.instantiate(this.particle_star);
        this.node.addChild(par);

        this._isRight = true;

        cc.game.emit("RIGHT");
    },

    wrong(spriteFrame, width, height) {
        this.rightFrame.active = true;
        this.rightPic.node.width = width;
        this.rightPic.node.height = height;
        this.rightPic.spriteFrame = spriteFrame;

        let time = 0.05;
        let action = cc.repeat(
            cc.sequence(cc.moveBy(time, -10, 0), cc.moveBy(time, 10, 0), cc.moveBy(time, 10, 0), cc.moveBy(time, -10, 0)),
            4
        );

        this.node.runAction(action);
        this.scheduleOnce(function () {
            this.rightFrame.active = false;
            this.rightPic.spriteFrame = null;
            this._opPic.node.active = true;
            this._opPic.node.getComponent("op_pic").resetPos();
            cc.game.emit("MOVE_CONTROL", true); // 广播事件 开启拖动
        }, 1.2);
    },

    onStopAudio() {
        if (this._isPlaying) {
            this._isPlaying = false;
            this.iconSound.getComponent(cc.Animation).play("icon_sound_finish");
            cc.audioEngine.stopEffect(this._curAudioId);
        }
    },
});
