import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  ApplicationRef,
  ChangeDetectorRef,
} from "@angular/core";
import { JsonPipe } from "@angular/common";

@Component({
  selector: "app-form",
  templateUrl: "./form.component.html",
  styleUrls: ["./form.component.css"],
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "andy_et06";
  // 储存对象
  item;
  picArr = [];
  answer;

  constructor(
    private appRef: ApplicationRef,
    private changeDetectorRef: ChangeDetectorRef
  ) {}

  createShell() {
    this.item.wordList.push({
      word: "",
      audio: "",
      backWord: "",
      backWordAudio: "",
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {
    this.item = {};
    this.answer = 0;

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {
      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
    }, this.saveKey);
  }

  ngOnChanges() {}

  ngOnDestroy() {}

  init() {
    if (this.item.options) {
      console.log("picarr " + this.picArr);
      this.picArr = this.item.options;
    }
    if (this.item.answer) {
      this.answer = this.item.answer;
    }
  }

  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onImageUploadSuccessByItem(e, item, id = null) {
    if (id != null) {
      item["pic_url_" + id] = e.url;
      console.log("upload pic 1" + e.url);
    } else {
      item.pic_url = e.url;
      console.log("upload pic 2" + e.url);
    }

    this.save();
    console.log("this.item: ", this.picArr);
  }

  onAudioUploadSuccessByItem(e, item, id = null) {
    if (id != null) {
      item["audio_url_" + id] = e.url;
    } else {
      item.audio_url = e.url;
    }
    this.save();
  }

  onSetAnswer() {
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }

  deleteItem(data) {
    const index = this.picArr.indexOf(data);
    if (index !== -1) {
      this.picArr.splice(index, 1);
    }

    this.save();
  }

  addPic() {
    const data = {
      pic_url: "",
      audio_url: "",
      text: "",
    };

    this.picArr.push(data);

    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    this.item.answer = this.answer;
    this.item.options = this.picArr;

    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log("this.item = " + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}
