/**
 * 选项
 */

cc.Class({
    extends: cc.Component,

    properties: {
        title: {
            default: null,
            type: cc.Label,
        },

        pic: {
            default: null,
            type: cc.Sprite,
        },

        picSelected: {
            default: null,
            type: cc.Node,
        },

        soundCorrect: {
            default: null,
            type: cc.AudioClip,
        },

        soundWrong: {
            default: null,
            type: cc.AudioClip,
        },

        stars: {
            default: null,
            type: cc.Node,
        },

        _audioTitle: null,
        _isPlaying: false,
        _isAnswer: false,
        _isDone: false,
        _allowClick: true,
        _count: 0,
    },

    onEnable() {
        cc.game.on("DONE", this.setDone, this);
        cc.game.on("STOPALL", this.stopAllAudio, this);

        this._allowClick = true;
    },
    onDisable() {
        cc.game.off("DONE", this.setDone, this);
        cc.game.off("STOPALL", this.stopAllAudio, this);
    },

    setPic(pic_url) {
        cc.assetManager.loadRemote(pic_url, (err, img) => {
            var frame = new cc.SpriteFrame(img);
            let frameSize = frame.getOriginalSize();

            let targetWidth = 0;
            if (this._count >= 4) {
                targetWidth = 237;
            } else {
                targetWidth = 323;
            }

            let scale = 1;
            scale = targetWidth / frameSize.width;

            this.pic.spriteFrame = frame;
            this.pic.node.width = frameSize.width * scale;
            this.pic.node.height = frameSize.height * scale;

            if (this._count >= 4) {
                scale = 1;
                if (frameSize.height < 187) {
                    scale = 187 / frameSize.height;
                }

                this.pic.node.width = frameSize.width * scale;
                this.pic.node.height = frameSize.height * scale;
            }
        });
    },

    setTitle(title) {
        this.title.string = title;
    },

    clickTitle() {
        if (this._audioTitle != null && !this._isPlaying) {
            cc.game.emit("STOPALL");
            this._isPlaying = true;
            cc.assetManager.loadRemote(this._audioTitle, (err, audioClip) => {
                const audioId = cc.audioEngine.play(audioClip, false);
                cc.audioEngine.setFinishCallback(audioId, () => {
                    this._isPlaying = false;
                });
            });
        }
    },

    clickPic() {
        if (this._isDone || !this._allowClick) {
            return;
        }

        cc.game.emit("STOPALL");
        this.picSelected.active = true;
        if (this._isAnswer) {
            cc.audioEngine.playEffect(this.soundCorrect);
            this.stars.active = true;
            cc.game.emit("DONE");
        } else {
            this._allowClick = false;
            let id = cc.audioEngine.playEffect(this.soundWrong);
            cc.audioEngine.setFinishCallback(id, () => {
                this.picSelected.active = false;
                this._allowClick = true;
            });
        }
    },

    setDone() {
        this._isDone = true;
    },

    stopAllAudio() {
        cc.audioEngine.stopAllEffects();
        this._isPlaying = false;
    },
});
