import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';
import defauleFormData from '../../assets/play/default/formData/defaultData.js'

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {

  _item: any;
  dataArray: Array<Object> = []; 
  contentObj = {
    dataArray: []
  }

  KEY = 'DataKey_East_L226';

  set item(item) {
    this._item = item;
  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef) {

  }

  ngOnInit() {
    this.item = {};
    this.item.contentObj = {};
    const getData = (<any> window).courseware.getData;
    getData((data) => {
      // console.log("读取数据", data)
      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }
      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }
      this.init();
      this.refresh();
      this.save()
    }, this.KEY);
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  saveData(e){
    this.save();
  }

  init() {
    if (Object.keys(this.item.contentObj).length != 0 && this.item.contentObj.version && this.item.contentObj.version==defauleFormData.version) {
      // console.log("读取数据", this.item.contentObj)
      this.contentObj = this.item.contentObj;
      this.dataArray = this.item.contentObj.dataArray;
    } else {
      this.contentObj = defauleFormData;
      this.dataArray = defauleFormData.dataArray
      // console.log("使用默认数据", this.contentObj)
      this.item.contentObj = this.contentObj;
      this.item.contentObj.dataArray = this.dataArray;
    }
  }

  cardItemData(){
    return {
      type: "Text",
      text: "",
      audio_url: "",
      image_url: ""
    };
  }

  cardChoiceData(){
    return { isText: true, text: "", image_url: "" }
  }

  getDefaultPicArr() {
    let arr = []; 
    return arr;
  }

  initData() {

  }


  addChoice(questionIndex) { 
    // let item = this.cardChoiceData();  
    // this.dataArray[questionIndex].choice.incorrect.push(item);
    // this.saveItem();
  }

  onUploadSuccessByItem(e, item, key) { 
    item[key] = e.url; 
    this.save();
  }

  onImageUploadSuccessByItem(e, item) {
    item.image_url = e.url
    this.save(); 
  }
 
  onAudioUploadSuccessByItem(e, item, key) { 
    item[key] = e.url; 
    this.save();
  }

  onTitleAudioUploadSuccess(e) { 
    this.item.contentObj.titleAudio_url = e.url;
    this.save();
  }

  addItem() { 
    let item = this.cardItemData();  
    this.dataArray.push(item);
    this.saveItem();
  }

  deleteItem(index){
    this.dataArray.splice(index,1)
    this.save()
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;
    this.saveItem();
  }

  clickCheckBox() {
    this.saveItem();
  }

  saveItem() {
    this.save();
  }

  save() {
    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();
    console.log("保存", this.item)
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}

