import os
import shutil
from PIL import Image

fileName = os.listdir('./')
withBorder = False
border_left = ""
border_right = ""
imageName = input("图片名：")
if input("是否包含边框? (y/n)：")=="y":
  withBorder = True
if withBorder:
  border_left = input("左边框文件名：")
  border_right = input("右边框文件名：")
number = int(input("数量："))

if os.path.exists('./' + imageName + '/'):
  shutil.rmtree('./' + imageName + '/')

os.mkdir('./' + imageName + '/')
pic = Image.open('./' + imageName + '.PNG')
width = pic.width
height = pic.height

f = open('./' + imageName + '/' + imageName + '_map.txt', 'w')

if withBorder:
  borderImg_left, borderImg_right = Image.open('./' + border_left + '.PNG'), Image.open('./' + border_right + '.PNG')
  for index in range(1, number):
    newpic = pic.resize((width*index, height),Image.ANTIALIAS)
    loc1, loc2, loc3 = (0, 0), (borderImg_left.width, 0), (borderImg_left.width +newpic.width, 0)
    join_pic = Image.new('RGBA', (borderImg_left.width + newpic.width + borderImg_right.width, newpic.height))
    join_pic.paste(borderImg_left, loc1)
    join_pic.paste(newpic, loc2)
    join_pic.paste(borderImg_right, loc3)
    join_pic.save('./' + imageName + '/' + imageName + '_' + str(index) + 'x.PNG')
    f.write('"' + str(width*index) + '": "' + imageName + '_' + str(index) + 'x",\n')
  f.close()
else:
  for index in range(1, number):
    newpic = pic.resize((width*index, height),Image.ANTIALIAS)
    newpic.save('./' + imageName + '/' + imageName + '_' + str(index) + 'x.PNG')
    f.write('"' + str(width*index) + '": "' + imageName + '_' + str(index) + 'x",\n')
  f.close()
  