import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';

const defaultData = {
  version: "1.0",
  bgMusic: "",
  dataArray:[
    {type:"Text", image_url:"", text:"", audio_url:""},
    {type:"Text", image_url:"", text:"", audio_url:""},
    {type:"Text", image_url:"", text:"", audio_url:""},
    {type:"Text", image_url:"", text:"", audio_url:""},
    {type:"Text", image_url:"", text:"", audio_url:""}
  ]
}

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {

  _item: any;
  contentObj = {
    bgMusic:"",
    dataArray:[]
  }
  hotZoneItemArr: Array<Object> = [];
  bgItem: Object;

  KEY = 'DataKey_East_L228';

  set item(item) {
    this._item = item;
  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef) {

  }

  ngOnInit() {
    this.item = {};
    this.item.contentObj = {};
    const getData = (<any> window).courseware.getData;
    getData((data) => {
      // console.log("读取数据", data)
      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }
      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }
      this.init();
      this.refresh();
      this.save()
    }, this.KEY);
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  init() {
    if (Object.keys(this.item.contentObj).length != 0 && this.item.contentObj.version && this.item.contentObj.version==defaultData.version) {
      // console.log("读取数据", this.item.contentObj)
      this.contentObj = this.item.contentObj;
    } else {
      this.contentObj = defaultData;
      // console.log("使用默认数据", this.contentObj)
      this.item.contentObj = this.contentObj;
    }
  }

  cardItemData(){
    return {audio_url:"", type:"text", text:"", image_url:""}
  }

  cardChoiceData(){
    return { isText: true, text: "", image_url: "" }
  }

  getDefaultPicArr() {
    let arr = defaultData; 
    return arr;
  }

  initData() {

  }


  handleMoveItemUp(index){
    if(index!=0){
      this.item.contentObj.dataArray[index] = this.item.contentObj.dataArray.splice(index-1, 1, this.item.contentObj.dataArray[index])[0];
    }else{
      this.item.contentObj.dataArray.push(this.item.contentObj.dataArray.shift());
    }
    this.save()
  }

  handleMoveItemDown(index){
    if(index!=this.item.contentObj.dataArray.length-1){
      this.item.contentObj.dataArray[index] = this.item.contentObj.dataArray.splice(index+1, 1, this.item.contentObj.dataArray[index])[0];
    }else{
      this.item.contentObj.dataArray.unshift( this.item.contentObj.dataArray.splice(index,1)[0]);
    }
    this.save()
  }

  deleteItem(index){
    this.item.contentObj.dataArray.splice(index,1)
    this.save()
  }
  addChoice(questionIndex) { 
    // let item = this.cardChoiceData();  
    // this.dataArray[questionIndex].choice.incorrect.push(item);
    // this.saveItem();
  }

  onImageUploadSuccessByItem(e, item) {
    item.image_url = e.url
    this.save(); 
  }

  onImageUploadSuccess_Container(e) {
    this.item.contentObj.cardContainerSetting.image_url = e.url
    this.save();
  }
 
  onAudioUploadSuccessByItem(e, item) { 
    item.audio_url = e.url; 
    this.save();
  }

  onTitleAudioUploadSuccess(e) {
    this.contentObj.bgMusic = e.url;
    this.save();
  }

  addItem() { 
    let item = this.cardItemData();  
    this.contentObj.dataArray.push(item);
    this.saveItem();
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;
    this.saveItem();
  }

  clickCheckBox() {
    this.saveItem();
  }

  saveItem() {
    this.save();
  }

  save() {
    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();
    // console.log("保存", this.item)
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}

