import {
  Component,
  ElementRef,
  ViewChild,
  OnInit,
  Input,
  OnDestroy,
  HostListener
} from "@angular/core";

import {
  MySprite,
  getMinScale,
  ShapeRect,
  ShapeCircle,
  tweenChange,
  randomSortByArr,
  Label,
  showPopParticle,
  moveItem,
  removeItemFromArr,
  rotateItem,
  hideItem,
  showItem,
  ShapeRectNew,
  scaleItem,
  showBlingBling,
  waterWave,
  jelly
} from "./Unit";

import { localImages, localAudios } from "./resources";

import { Cartoon } from './Cartoon'
import { Subject } from "rxjs";
import { debounceTime, map, takeWhile } from "rxjs/operators";
import * as _ from "lodash";
import TWEEN from "@tweenjs/tween.js";
import { callbackify } from 'util';



const defauleFormData = {
  version: "1.1",
  bgmusic: "",
  dataArray:[
    {type:"Image", image_url:"default_image", text:"", audio_url:""},
    {type:"Image", image_url:"default_image", text:"", audio_url:""},
    {type:"Image", image_url:"default_image", text:"", audio_url:""},
    {type:"Image", image_url:"default_image", text:"", audio_url:""},
    {type:"Image", image_url:"default_image", text:"", audio_url:""}
  ]
}

const zIndexMap = {
  glassJarLeft_B: 1300,
  glassJarLeft_F: 1100,
  glassJarRight_B: 1300,
  glassJarRight_F: 1100,
  glassJarLeft_Highlight: 3299,
  glassJarRight_Highlight: 3299,
  glassJar_B: 1300,
  glassJar_F: 1100,
  glassJar_BH: 3300,
  glassJar_FH: 3100,

  CandyMachine_glass_bg: 2000,
  CandyMachine_rotate_bg: 2000,
  CandyMachine_glass_cover: 2099,
  CandyMachine_Exit_bg: 2100,
  CandyMachine_base : 2200,
  CandyMachine_decorate: 2205,
  CandyMachine_btn_go: 2210,
  CandyMachine_hightlight: 2000,

  question_candy_background: 2300,
  question_candy_btn_open: 2310,
  question_candy_unopen: 2150,

  question_candy_SugarBall: 3200,
  question_candy_wrapper: 3150,
}

@Component({
  selector: "app-play",
  templateUrl: "./play.component.html",
  styleUrls: ["./play.component.scss"]
})

export class PlayComponent implements OnInit, OnDestroy {
  
  g_cartoon = new Cartoon()

  // ------------  全局数据  ------------
  g_stage; //中心舞台
  g_background_color = "#rgb(0,0,0,0)"
  g_enableMapDown = true; // 触摸使能
  g_enableMapUp = true; // 抬起使能
  g_enableMapMove = true; // 移动ss使能
  g_canvasLeft;
  g_canvasTop;
  g_animationId: any;
  g_mapScale = 1; // 缩放比例
  g_KEY = "DataKey_East_L228";
  g_canvasWidth = 1280;
  g_canvasHeight = 720;
  g_canvasBaseW = 1280;
  g_canvasBaseH = 720;
  g_winResizeEventStream = new Subject();
  g_clickX; // 点击坐标 X
  g_clickY; // 点击坐标 Y
  g_ctx; // canvas 实例
  g_data; // 数据
  g_formData; // 核心表单数据
  g_teacherFlag = false; // 默认角色
  g_currentUser;
  // ------------------------------------

  // ------------  私有数据  ------------
  m_mapDownQueue = {} //按下事件处理队列
  m_mapDownArray = [] //按下事件处理队列
  m_mapDownObject = []
  m_mapUpQueue = {} //抬起事件处理队列
  m_mapMoveArray = [] //移动事件处理队列
  m_mapMoveObject = []
  m_endPageArr;
  m_showPetalFlag;
  m_elementPetalArr;
  m_showElementPetalFlag;
  m_PetalImage = "_scrap-pic-"  // 飘落动画
  m_renderArr // 渲染队列
  m_renderObject = [];
  m_defaultZindex = 0;
  m_setTimeoutIDs = [];
  m_setIntervalIDs = [];
  m_moveAsstantIntervalId = null;
  // ------------------------------------
  
  // ------------  游戏逻辑数据  ------------
  m_allCardIds = []
  m_allCardContentIds = []
  m_runIntervalId = null
  m_runStatus = false;

  m_rightBuffer = []
  m_requestAfterCard = false;
  m_requestID = null;
  m_enableRunway = false;
  m_currentFocusCard = 0;
  m_autoFocusID = null;
  m_enableCamera = false;
  m_nextCardLock = false;
  // ------------------------------------


  // ------------  消息  ------------
  
  // ------------------------------------


  // ------------  调试变量  ------------
  g_EnableStageRuler = false; // 使能舞台背景格尺
  g_ForceChangeDefaultRole = false // 强制当前角色为默认角色
  g_EnableTestSendEvent = false // 发送模拟Web数据
  // ------------------------------------


  // 当数据加载完毕后，执行
  systemReady(){
    this.initGame()
  }
  
  // 屏幕尺寸变化后执行
  handleScreenResize(){
    // this.initSystem();
    this.restartGame()
  }

  // 映射预加载图片[网路]资源 返回包含图片路径的数组
  mapToImageArray(contentObj){
    let array = []
    contentObj.dataArray.forEach(item => {
      if(item.type == "Image"){
        array.push(item.image_url)
      }
    });
    return array
  }

  // 映射预加载音频[网路]资源 返回包含音频路径的数组
  mapToAduioArray(contentObj){
    let array = []
    contentObj.dataArray.forEach(item => {
      if(item.audio_url){
        array.push(item.audio_url)
      }
    })
    return array
  }

  restartGame() {
    this.initSystem();
    this.cleanSystemVar()
    this.cleanGameVar()
    this.initGame()
  }


  // ------------------------------------------------------------------------------
  // 游戏核心处理区
  // ------------------------------------------------------------------------------
  // ------------------------------------------------------------------------------
  // 
  // 
  // 
  // ------------------------------------------------------------------------------
  // ------------------------------------------------------------------------------

  initGame(){
    this.initBackground();
    this.initRoll();
    this.initLights()
    this.initBillboard();
    this.initCamera();
    this.initCards();
    this.initShowCard();
    this.initStartButton()
  }

  cleanGameVar(){
    if(this.m_autoFocusID){
      clearTimeout(this.m_autoFocusID)
    }
    this.m_allCardIds = []
    this.m_allCardContentIds = []
    this.m_runIntervalId = null
    this.m_runStatus = false;
    this.m_rightBuffer = []
    this.m_requestAfterCard = false;
    this.m_requestID = null;
    this.m_enableRunway = false;
    this.m_currentFocusCard = 0;
    this.m_autoFocusID = null;
    this.m_enableCamera = false;
    this.m_nextCardLock = false;
  }

  endGame(){
   
  }

  startGame(){
    this.m_enableCamera = true;
    this.autoRollRun();
    this.g_cartoon.playAudio("sm-run", false ,null, true, (audio)=>{
      audio.volume = 0.3
    })
  }
  
  initBackground(){
    let element = this.g_cartoon.createCartoonElementImage("background-main", "main-bg", this.g_canvasWidth, this.g_canvasHeight, this.g_canvasWidth/2, this.g_canvasHeight/2);
    this.render(element.ref)
  }

  initStartButton(){
    let element = this.g_cartoon.createCartoonElementImage("start-button", "button_start", 434, 92, this.g_canvasWidth/2, this.g_canvasHeight/2, true);
    let element_black = this.g_cartoon.createCartoonElementImage("background-black-main", "_bg_1280_720", this.g_canvasWidth, this.g_canvasHeight, this.g_canvasWidth/2, this.g_canvasHeight/2);
    
    element.out = (callback?)=>{
      tweenChange(element.ref, {x:this.g_canvasWidth + 500*this.g_mapScale}, 0.3, ()=>{
        tweenChange(element_black.ref, {alpha:0}, 0.1, ()=>{
          element.ref.visible = false;
          element_black.ref.visible = false;
          element_black.ref.x = this.g_canvasWidth + 500*this.g_mapScale
          callback && callback()
        })

        element.ref.visible = false;
        callback && callback()
      })
    }

    this.subscribeMapDownEvent(element.id, ()=>{
      this.g_cartoon.playAudio("sm-click-start")
      element.out(()=>{
        this.startGame();
        this.g_enableMapDown = true;
      })
    })
    this.render(element.ref,999)
    this.render(element_black.ref,998)
  }

  initRoll(){
    let element = this.g_cartoon.createCartoonElementImageFunc("Camera-Roll", "Image-02", (w,h)=>{
      return {
        sx: this.g_canvasWidth / w,
        sy: 290*this.g_mapScale / h
      }
    }, (w,h)=>{
      return {
        x: this.g_canvasWidth / 2,
        y: this.g_cartoon.getOrigin().y+536*this.g_mapScale
      }
    });
    this.render(element.ref)
  }

  initBillboard(){
    let element = this.g_cartoon.createCartoonElementImageFunc("Billboard", "Image-04", (w,h)=>{
      return {
        sx: 464*this.g_mapScale / w,
        sy: 114*this.g_mapScale / h
      }
    }, (w,h)=>{
      return {
        x: this.g_canvasWidth / 2,
        y: this.g_cartoon.getOrigin().y+(47+h/2)*this.g_mapScale
      }
    });
    this.render(element.ref)
  }

  initCamera(){
    let element = this.g_cartoon.createCartoonElementImageFunc("Camera", "cam", (w,h)=>{
      return {
        sx: 108*this.g_mapScale / w,
        sy: 108*this.g_mapScale / h
      }
    }, (w,h)=>{
      return {
        x: this.g_cartoon.getOrigin().x + (1106+w/2)*this.g_mapScale, //+(+h/2)*this.g_mapScale,
        y: this.g_cartoon.getOrigin().y + (89+h/2)*this.g_mapScale//+(1106+w/2)*this.g_mapScale
      }
    });

    let element_highlight = this.g_cartoon.createCartoonElementImage("Camera-highlight", "camera_highlight",150, 148, 0, 0);
    element_highlight.ref.alpha = 0;

    element.hightlight = (status, callback?)=>{
      if(status){
        tweenChange(element_highlight.ref, {alpha:1}, 0.1, ()=>{
          callback && callback()
        })
      }else{
        tweenChange(element_highlight.ref, {alpha:0}, 0.1, ()=>{
          callback && callback()
        })
      }
    }
    element.ref.addChild(element_highlight.ref)

    this.subscribeMapDownEvent(element.id, ()=>{
      if(this.m_enableCamera){
        element.hightlight(true)
        this.m_enableCamera = false;
        this.m_enableRunway = false;
        this.g_cartoon.stopAudio("sm-run")
        clearTimeout(this.m_autoFocusID)
        this.g_cartoon.playAudio("sm-camera")
        this.g_cartoon.getCartoonElement(`card-show`).show(()=>{
          this.g_enableMapDown = true
        })
      }else{
        this.g_enableMapDown = true
      }
    })
    this.render(element.ref)
  }
  
  // 选择卡片
  initCards(){
    let repeatNum = Math.floor(this.g_canvasWidth / (249*this.g_mapScale)) + 2
    let boundingBox = this.g_cartoon.getCartoonElement('Camera-Roll').ref.getBoundingBox()
    let cardWidth = 265*this.g_mapScale
    let cardNumber = Math.ceil(this.g_canvasWidth/cardWidth);
    let cardDetailArray = this.g_formData.dataArray
    for(let index=0; index<(cardDetailArray.length) * repeatNum; index++){
      let newCard = this.createCard(index,index*cardWidth,boundingBox.y,cardDetailArray[index%cardDetailArray.length]);
      if(index>=cardNumber){
        newCard.ref.x = -999
        newCard.waiting = true;
        this.m_rightBuffer.push(newCard.id)
      }
      if(newCard.ref.x + 115*this.g_mapScale > this.g_canvasWidth){
        this.m_enableRunway = true;
      }
      this.render(newCard.ref)
    }
  }

  createCard(index,x,y,data){
    this.m_allCardIds.push(`card-bckground-${index}`)
    this.m_allCardContentIds.push(`card-content-${index}`)

    // 背景
    let element = this.g_cartoon.createCartoonElementImageFunc(`card-bckground-${index}`, "Image-01", (w,h)=>{
      return {
        sx: 249*this.g_mapScale/w,
        sy: 230*this.g_mapScale/h
      }
    }, (w,h)=>{
      return {
        x: x + (w/2)*this.g_mapScale + 14*this.g_mapScale,
        y: y + 145*this.g_mapScale
      }
    })
    element.content = null;

    // 内容
    let cardContent = this.g_cartoon.createCartoonElementImage(`card-content-${index}`, "Image-05", 210, 210, 0, 0)
    element.ref.addChild(cardContent.ref)

    if(data.type=="Image"){
      let cardImage = this.g_cartoon.createImage(data.image_url, (w,h)=>{
        let sx = 200 / w;
        let sy = 200 / h;
        return {
          sx: Math.min(sx,sy),
          sy: Math.min(sx,sy)
        }
      }, (w,h)=>{
        return {
          x: 0,
          y:0
        }
      })
      element.ref.addChild(cardImage)
    }else{


      let textContainer = this.g_cartoon.createImage("Image-05", (w,h)=>{
        return {
          sx: 165 / w,
          sy: 165 / h
        }
      }, (w,h)=>{
        return {
          x: 0,
          y:0
        }
      })
      textContainer.alpha = 0

      let text = this.g_cartoon.createLabel(data.text, "BerlinSansFBDemi-Bold", null, 50)
      let lineNum = data.text.split(" ")
      text.maxSingalLineWidth = 165
      text.fontColor = "#e05e14";
      if(lineNum.length>1){
        textContainer.y = -(lineNum.length * 50) / 2 + 50
      }

      textContainer.addChild(text)
      element.ref.addChild(textContainer)
    }

    // 高亮
    let cardContentHighlight = this.g_cartoon.createCartoonElementImage(`card-content-highlight-${index}`, "card-hightlight", 256, 285, 5, -4)
    if(index==0){
      cardContentHighlight.ref.alpha = 1;
      cardContentHighlight.ref.visible = true;
    }else{
      cardContentHighlight.ref.alpha = 0;
      cardContentHighlight.ref.visible = false;
    }
    element.ref.addChild(cardContentHighlight.ref)

    element.moveLeft = (distance)=>{
      element.ref.x -= distance
      if(element.content){
        element.content.ref.x -= distance;
      }

      if(cardContentHighlight.ref.visible){
        if(!this.m_nextCardLock && element.ref.x<=0){
          this.nextFocus()
        }
      }
    }

    element.readyGoOut = (x)=>{
      element.ref.x = x
      if(element.content){
        element.content.ref.x = x;
      }
    }

    element.showHighlight = (callback?)=>{
      cardContentHighlight.ref.visible = true;
      tweenChange(cardContentHighlight.ref, {alpha:1}, 0.3, ()=>{
        callback && callback()
      })
    }

    element.hideHighlight = ()=>{
      tweenChange(cardContentHighlight.ref, {alpha:0}, 0.3)
      cardContentHighlight.ref.visible = false;
    }

    return element;
  }

  // 跑道启停控制
  autoRollRun(){
    if(!this.m_enableRunway){
      return;
    }
    let step = Math.floor(5*this.g_mapScale*10000)/20000;
    let cardElement = null;
    this.m_runIntervalId = setInterval(()=>{
      this.m_allCardIds.forEach((id)=>{
        if(!this.m_enableRunway){
          return;
        }
        cardElement = this.g_cartoon.getCartoonElement(id)
        cardElement.moveLeft(step)
        this.cardRecyclingAndPreparation(id)
      })
      this.m_runStatus = true;
    }, 40)
  }

  // 卡片回收与准备控制
  cardRecyclingAndPreparation(id){
    let ele = this.g_cartoon.getCartoonElement(id)
    let x = ele.ref.x;
    let width = 257*this.g_mapScale;
    if( (x + width*0.5) < this.g_canvasWidth && ( (x+ width*0.5) > this.g_canvasWidth-14*this.g_mapScale) && !this.m_requestAfterCard ){
      if(this.m_requestID  != id){
        this.m_requestAfterCard = true;
        this.m_requestID = id
      }
    }

    if(this.m_rightBuffer[0] && this.m_requestAfterCard){
      this.m_requestAfterCard = false;
      this.g_cartoon.getCartoonElementRef(this.m_rightBuffer[0]).alpha = 0;
      this.g_cartoon.getCartoonElement(this.m_rightBuffer[0]).readyGoOut(this.g_cartoon.getCartoonElementRef(this.m_requestID).x + width + 14*this.g_mapScale)
      tweenChange(this.g_cartoon.getCartoonElementRef(this.m_rightBuffer[0]), {alpha: 1}, 0.2)
      this.g_cartoon.getCartoonElement(this.m_rightBuffer[0]).waiting = false;
      this.m_rightBuffer.splice(0,1)
    }

    if( x < -0.5*width && !this.g_cartoon.getCartoonElement(id).waiting){
      this.g_cartoon.getCartoonElement(id).waiting = true;
      this.m_rightBuffer.push(id)
    }
  }

  nextFocus(callback?){
    this.m_nextCardLock = true;
    let all = this.m_allCardIds.length
    let current = this.m_currentFocusCard
    let next = -1
    if(all == (current+1)){
      next = 0;
    }else{
      next = current + 1
    }

    if(current != -1){
      this.g_cartoon.getCartoonElement(this.m_allCardIds[current]).hideHighlight()
    }
    this.g_cartoon.getCartoonElement(this.m_allCardIds[next]).showHighlight(()=>{
      this.m_nextCardLock = false;
      callback && callback()
    })
    this.m_currentFocusCard = next;
  }

  initShowCard(){
    let element = this.g_cartoon.createCartoonElementImageFunc(`card-show`, "Image-05", (w, h)=>{
      return {
        sx: 340*this.g_mapScale / w,
        sy: 340*this.g_mapScale / h,
      }
    }, (w, h)=>{
      return {
        x: this.g_canvasWidth/2,
        y: this.g_canvasHeight/2 + 50*this.g_mapScale
      }
    })
    element.ref.visible = false;
    element.ref.setScaleXY(0)

    let closeBntton = this.g_cartoon.createCartoonElementImage(`card-show-close`, "close", 50, 50, 100, -100)
    element.ref.addChild(closeBntton.ref)

    let cardHighlight = this.g_cartoon.createCartoonElementImage(`card-highlight`, "highlight", 677*0.6, 660*0.6, 0, -25)
    element.ref.children.unshift(cardHighlight.ref)

    let clickTarget = this.g_cartoon.createCartoonElementImage(`card-click-target`, "Image-05", 170, 170, 0, 0)
    clickTarget.ref.alpha = 0;
    element.ref.addChild(clickTarget.ref)

    let textContent = this.g_cartoon.createLabel("", "BerlinSansFBDemi-Bold", null, 50)
    let imageContent =  this.g_cartoon.createImage("Image-05", (w,h)=>{
      let sx = 165 / w;
      let sy = 165 / h;
      return {
        sx: Math.min(sx,sy),
        sy: Math.min(sx,sy)
      }
    }, (w,h)=>{
      return {
        x: 0,
        y:0
      }
    })

    element.textContent = textContent;
    element.imageContent = imageContent;
    element.audio_url = null
    element.setContent = (data)=>{
      if(data.type=="Image"){
        element.imageContent = this.g_cartoon.createImage(data.image_url, (w,h)=>{
          let sx = 165 / w;
          let sy = 165 / h;
          return {
            sx: Math.min(sx,sy),
            sy: Math.min(sx,sy)
          }
        }, (w,h)=>{
          return {
            x: 0,
            y:0
          }
        })
        element.ref.addChild(element.imageContent)
      }else{
        let textContainer = this.g_cartoon.createImage("Image-05", (w,h)=>{
          return {
            sx: 165 / w,
            sy: 165 / h
          }
        }, (w,h)=>{
          return {
            x: 0,
            y:0
          }
        })
        textContainer.alpha = 0

        let text = this.g_cartoon.createLabel(data.text, "BerlinSansFBDemi-Bold", null, 50)
        let lineNum = data.text.split(" ").length
        text.maxSingalLineWidth = 165
        text.fontColor = "#e05e14";
        if(lineNum>1){
          textContainer.y = -(lineNum * 50) / 2 + 50
        }

        textContainer.addChild(text)
        element.textContent = textContainer
        element.ref.addChild(textContainer)
      }
      if(data.audio_url){
        element.audio_url = data.audio_url
      }
    }

    element.show = (callback?)=>{
      element.setContent(this.g_formData.dataArray[this.m_currentFocusCard % this.g_formData.dataArray.length])
      element.ref.visible = true;
      tweenChange(element.ref, {scaleX: element.ref.initScaleX, scaleY: element.ref.initScaleY}, 0.3, ()=>{
        this.g_cartoon.playAudio(element.audio_url)
        callback && callback()
      })
    }

    element.hide = (callback?)=>{
      element.audio_url = null;
      this.g_cartoon.stopAudio(element.audio_url)
      tweenChange(element.ref, {scaleX: 0, scaleY: 0}, 0.3, ()=>{
        element.ref.visible = false;
        let textIndex = element.ref.children.indexOf(element.textContent)
        let imageIndex = element.ref.children.indexOf(element.imageContent)
        if(textIndex!=-1){
          element.ref.children.splice(textIndex,1)
        }
        if(imageIndex!=-1){
          element.ref.children.splice(imageIndex,1)
        }
        this.g_cartoon.playAudio("sm-run", false, null, true, (audio)=>{
          audio.volume = 0.3
        })
        callback && callback()
      })
      
    }

    this.subscribeMapDownEvent(clickTarget.id, ()=>{
      this.g_cartoon.stopAudio(element.audio_url)
      this.g_cartoon.playAudio(element.audio_url)
      this.g_enableMapDown = true;
    })

    this.subscribeMapDownEvent(closeBntton.id, ()=>{
      this.g_cartoon.stopAudio(element.audio_url)
      this.m_enableCamera = true;
      element.hide(()=>{
        this.g_cartoon.getCartoonElement("Camera").hightlight(false)
        this.m_enableRunway = true;
        this.g_enableMapDown = true
      })
    })

     this.render(element.ref)
  }

// 灯光
initLights(){
  let totalLightCount = Math.ceil(this.g_canvasWidth / (38*this.g_mapScale))
  let baseY = this.g_cartoon.getCartoonElement('Camera-Roll').ref.y
  let height = this.g_cartoon.getCartoonElement('Camera-Roll').ref.height*this.g_mapScale
  let pos_y = [
    baseY - height/2 + 15*this.g_mapScale,
    baseY + height/2 - 15*this.g_mapScale
  ]
  let base_x = 24*this.g_mapScale;
  for(let line=0; line<2; line++){
    for(let row=0; row<totalLightCount; row++){
      this.render(this.createLights(line,row,base_x,pos_y,true).ref)
    }
  }
  for(let line=0; line<2; line++){
    for(let row=0; row<totalLightCount; row++){
      this.render(this.createLights(line,row,base_x,pos_y,false).ref)
    }
  }
  this.runWaterLights(totalLightCount)
}

createLights(line, row, base_x, pos_y, stuats){
  if(stuats){
    let element = this.g_cartoon.createCartoonElementImage(`water-light-${line}-${row}-on`, "light-on", 38*this.g_mapScale, 35*this.g_mapScale, base_x + row*38*this.g_mapScale, pos_y[line])
    element.ref.visible = false;
    return element;
  }else{
    let element = this.g_cartoon.createCartoonElementImage(`water-light-${line}-${row}-off`, "light-off", 16*this.g_mapScale, 18*this.g_mapScale, base_x + row*38*this.g_mapScale, pos_y[line])
    return element;
  }
}

lightOn(line, row){
  this.g_cartoon.getCartoonElementRef(`water-light-${line}-${row}-on`).visible = true;
  this.g_cartoon.getCartoonElementRef(`water-light-${line}-${row}-off`).visible = false;
}
lightOff(line, row){
  this.g_cartoon.getCartoonElementRef(`water-light-${line}-${row}-on`).visible = false;
  this.g_cartoon.getCartoonElementRef(`water-light-${line}-${row}-off`).visible = true;
}

runWaterLights(totalLightCount){
  let runTime = 3//Math.floor(totalLightCount/5)
  for(let count=0; count<runTime; count++){
    this.m_setTimeoutIDs.push(setTimeout(()=>{
      let count_l0 = 0;
      let dir_l0 = true;
      this.m_setIntervalIDs.push(setInterval(()=>{
        this.lightOff(0,count_l0)
        if(dir_l0){
          count_l0++
        }else{
          count_l0--
        }
        if(count_l0 >= totalLightCount){
          count_l0--
          dir_l0 =! dir_l0;
        }else if(count_l0 <= -1){
          count_l0++
          dir_l0 =! dir_l0;
        }
        this.lightOn(0,count_l0)
      },100))

      let count_l1 = totalLightCount-1;
      let dir_l1 = true;
      this.m_setIntervalIDs.push(setInterval(()=>{
        this.lightOff(1,count_l1)
        if(dir_l1){
          count_l1++
        }else{
          count_l1--
        }
        if(count_l1 >= totalLightCount){
          count_l1--
          dir_l1 =! dir_l1;
        }else if(count_l1 <= -1){
          count_l1++
          dir_l1 =! dir_l1;
        }
        this.lightOn(1,count_l1)
      },100))
    }, count*500))
  }
}












  





































  // --------------------------------------------------
  // --------------  Template function  ---------------
  // --------------------------------------------------
  // --------------------------------------------------
  // --------------------------------------------------
  // 
  //                                  _________
  //                                 /         /.
  //           .-------------.      /_________/ |
  //         /             / |      |         | |
  //        /+============+\ |      | |====|  | |
  //        ||C:\>        || |      |         | |
  //        ||            || |      | |====|  | |
  //        ||            || |      |   ___   | |
  //        ||            || |      |  |166|  | |
  //        ||            ||/@@@    |   ---   | |
  //        \+============+/    @   |_________|./.
  //                          @          ..  ....'
  //        ..................@     __.'.'  ''
  //      /oooooooooooooooo//     ///
  //      /................//     /_/
  //      ------------------
  //
  // --------------------------------------------------

  @ViewChild("canvas") canvas: ElementRef;
  @ViewChild("wrap") wrap: ElementRef;
  @HostListener("window:resize", ["$event"])
  onResize(event) {
    this.g_winResizeEventStream.next();
  }
  ngOnDestroy() {
    window["curCtx"] = null;
    window.cancelAnimationFrame(this.g_animationId);
  }
  ngOnInit() {
    const getData = (<any>window).courseware.getData;
    getData(data => {
      if (window['air'].airClassInfo.user.classRole == 'tea') {
        if(!this.g_ForceChangeDefaultRole){
          this.g_teacherFlag = true;
        }
      }
      this.g_currentUser = window['air'].airClassInfo.user;
      if (data && typeof data == "object") {
        this.g_data = data;
        this.g_formData = data.contentObj;
      } else {
        this.g_data = {};
      }

      if (!this.g_data.contentObj) {
        this.g_data.contentObj = {};
        this.g_formData = {};
      }
     
      this.initDefaultData();
      this.initAudio();
      this.initImg();
      
       // 预加载资源
       this.g_cartoon.loadResources().then(() => {
        window["air"].hideAirClassLoading(this.g_KEY, this.g_data);
        this.initSystem();
        this.update();
        this.systemReady()
      });

      this.initListener();
    }, this.g_KEY);
  }

  // ----------------------------------
  // 初始化默认数据
  // ----------------------------------
  initDefaultData() {
    if ( Object.keys(this.g_formData).length===0 ) {
      // console.log("Init default form data")
      this.g_formData = defauleFormData;
    }
  }


  // ----------------------------------
  // 初始化音乐
  // ----------------------------------
  initAudio() {
    const contentObj = this.g_formData;
    if (!contentObj) {
      return;
    }
    // 添加用户上传音效
    let images:Array<string> = this.mapToAduioArray(contentObj)
    images.forEach(image => {
      this.g_cartoon.addAudio( image, image );
    });

    // 添加本地音效
    for( var key in localAudios ){
      this.g_cartoon.addAudio( key, localAudios[key] );
    }
  }

  // ----------------------------------
  // 初始化图片
  // ----------------------------------
  initImg() {
    const contentObj = this.g_formData;
    if (contentObj) {
      const addPicUrl = url => {
        if (url) {
          this.g_cartoon.addImage(url, url);
        }
      };
      let images:Array<string> = this.mapToImageArray(contentObj)
      images.forEach(image => {
        addPicUrl(image)
      });
    }
    // 添加本地图片
    for( var key in localImages ){
     this.g_cartoon.addImage( key, localImages[key] );
    }
  }


  mapDown(event) {
    let myStopPropagation = false;
    if (!this.g_enableMapDown) {
      return;
    }

    this.m_mapDownArray.forEach((item)=>{
      if(!myStopPropagation){
        if (this.checkClickTarget(this.g_cartoon.getCartoonElementRef(item.id))) {
          this.g_enableMapDown = false;
          if(item.callback()){
            myStopPropagation = true;
          }
        }
      }
    })


  }

  mapMove(event) {
    let myStopPropagation = false;
    if (!this.g_enableMapMove) {
      return;
    }

    this.m_mapMoveArray.forEach((item)=>{
      if(!myStopPropagation){
        if (this.checkClickTarget(this.g_cartoon.getCartoonElementRef(item.id))) {
          this.g_enableMapMove = false;
          if(item.callback()){
            myStopPropagation = true;
          }
        }
      }
    })
  }

  mapUp(event) {
    if (!this.g_enableMapUp) {
      return;
    }
    for(let cartoonID in this.m_mapUpQueue){
      if (this.checkClickTarget(this.g_cartoon.getCartoonElementRef(cartoonID))) {
        this.g_enableMapUp = false;
        this.m_mapUpQueue[cartoonID]();
      }
    }
  }


  update() {
    this.g_animationId = window.requestAnimationFrame(this.update.bind(this));
    // 清除画布内容
    this.g_ctx.clearRect(0, 0, this.g_canvasWidth, this.g_canvasHeight);
    TWEEN.update();
    this.updateArr(this.m_renderArr);
    this.updateArr(this.m_endPageArr);
    this.updateArr(this.m_elementPetalArr);
  }


  updateItem(item) {
    if (item) {
      item.update();
    }
  }


  updateArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].update(this);
    }
  }


  initListener() {
    this.g_winResizeEventStream.pipe(debounceTime(500)).subscribe(data => {
      this.renderAfterResize();
    });

    if (this.IsPC()) {
      this.canvas.nativeElement.addEventListener("mousedown", event => {
        setMxMyByMouse(event);
        this.mapDown(event);
      });

      this.canvas.nativeElement.addEventListener("mousemove", event => {
        setMxMyByMouse(event);
        this.mapMove(event);
      });

      this.canvas.nativeElement.addEventListener("mouseup", event => {
        setMxMyByMouse(event);
        this.mapUp(event);
      });

      const setMxMyByMouse = event => {
        this.g_clickX = event.offsetX;
        this.g_clickY = event.offsetY;
      };
    } else {
      this.canvas.nativeElement.addEventListener("touchstart", event => {
        setMxMyByTouch(event);
        this.mapDown(event);
      });

      this.canvas.nativeElement.addEventListener("touchmove", event => {
        setMxMyByTouch(event);
        this.mapMove(event);
      });

      this.canvas.nativeElement.addEventListener("touchend", event => {
        setMxMyByTouch(event);
        this.mapUp(event);
      });

      this.canvas.nativeElement.addEventListener("touchcancel", event => {
        setMxMyByTouch(event);
        this.mapUp(event);
      });

      const setMxMyByTouch = event => {
        if (event.touches.length <= 0) {
          return;
        }

        if (this.g_canvasLeft == null) {
          setParentOffset();
        }

        this.g_clickX = event.touches[0].pageX - this.g_canvasLeft;
        this.g_clickY = event.touches[0].pageY - this.g_canvasTop;
      };

      const setParentOffset = () => {
        const rect = this.canvas.nativeElement.getBoundingClientRect();
        this.g_canvasLeft = rect.left;
        this.g_canvasTop = rect.top;
      };
    }
  }

  showArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = true;
    }
  }

  hideArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = false;
    }
  }

  IsPC() {
    if (window["ELECTRON"]) {
      return false; // 封装客户端标记
    }
    if (
      document.body.ontouchmove !== undefined &&
      document.body.ontouchmove !== undefined
    ) {
      return false;
    } else {
      return true;
    }
  }

  renderAfterResize() {
    this.g_canvasWidth = this.wrap.nativeElement.clientWidth;
    this.g_canvasHeight = this.wrap.nativeElement.clientHeight;
    this.update();
    this.handleScreenResize()
  }

  checkClickTarget(target) {
    if (!target) {
      return false;
    }
    const rect = target.getBoundingBox();
    if (this.checkPointInRect(this.g_clickX, this.g_clickY, rect)) {
      return true;
    }
    return false;
  }


  getWorlRect(target) {
    let rect = target.getBoundingBox();
    if (target.parent) {
      const pRect = this.getWorlRect(target.parent);
      rect.x += pRect.x;
      rect.y += pRect.y;
    }
    return rect;
  }

  checkPointInRect(x, y, rect) {
    if (x >= rect.x && x <= rect.x + rect.width) {
      if (y >= rect.y && y <= rect.y + rect.height) {
        return true;
      }
    }
    return false;
  }


  getPosByAngle(angle, len) {
    const radian = (angle * Math.PI) / 180;
    const x = Math.sin(radian) * len;
    const y = Math.cos(radian) * len;
    return { x, y };
  }


  getPosDistance(sx, sy, ex, ey) {
    const _x = ex - sx;
    const _y = ey - sy;
    const len = Math.sqrt(Math.pow(_x, 2) + Math.pow(_y, 2));
    return len;
  }


  subscribeMapDownEvent(id,callback, zIndex?){
    zIndex = zIndex?zIndex:0
    this.m_mapDownObject.push({id:id, zIndex:zIndex?zIndex:1, callback:callback})
    this.m_mapDownObject.sort((a,b)=>{
      return b.zIndex-a.zIndex
    })
    this.m_mapDownArray = []
    this.m_mapDownObject.forEach(item=>{
      this.m_mapDownArray.push(item)
    })
  }

  subscribeMapUpEvent(id,callback){
    this.m_mapUpQueue[id] = callback
  }

  subscribeMapMoveEvent(id, callback, zIndex?){
    zIndex = zIndex?zIndex:0
    this.m_mapMoveObject.push({id:id, zIndex:zIndex?zIndex:1, callback:callback})
    this.m_mapMoveObject.sort((a,b)=>{
      return a.zIndex - b.zIndex
    })
    this.m_mapMoveArray = []
    this.m_mapMoveObject.forEach(item=>{
      this.m_mapMoveArray.push(item)
    })
  }


  // 全局初始化入口，当资源加载完毕后执行
  initSystem() {
    
    this.g_canvasWidth = this.wrap.nativeElement.clientWidth;
    this.g_canvasHeight = this.wrap.nativeElement.clientHeight;

    const sx = this.g_canvasWidth / this.g_canvasBaseW;
    const sy = this.g_canvasHeight / this.g_canvasBaseH;
    const s = Math.min(sx, sy);

    this.g_mapScale = s;
    this.g_cartoon.mapScale = this.g_mapScale;
    this.g_cartoon.clientWidth = this.wrap.nativeElement.clientWidth;
    this.g_cartoon.clientHeight = this.wrap.nativeElement.clientHeight;

    this.m_renderArr = [];
    this.m_renderObject = [];
    this.g_enableMapDown = true;

    this.g_ctx = this.canvas.nativeElement.getContext("2d");
    this.canvas.nativeElement.width = this.g_canvasWidth;
    this.canvas.nativeElement.height = this.g_canvasHeight;
    window["curCtx"] = this.g_ctx;

    // 初始化舞台
    this.initStage();
    this.update();
  }
  

  initStage() {
    const bgWidth = 1280;
    const bgHeight = 720;
    this.g_cartoon.stageWidth = bgWidth*this.g_mapScale;
    this.g_cartoon.stageHeight= bgHeight*this.g_mapScale;

    const imageColor = this.g_cartoon.createCartoonElement("background-color", "ShapeRect").ref;
    // console.log( "stageWidth: " + this.g_cartoon.stageWidth + " stageHeight" + this.g_cartoon.stageHeight)
    // console.log( "clientWidth: " + this.g_cartoon.clientWidth + " clientHeight" + this.g_cartoon.clientHeight)
    // console.log( "canvasWidth: " + this.g_canvasWidth + " canvasHeight" + this.g_canvasHeight)
    // console.log( "mapScale: " + this.g_mapScale )
    imageColor.x = this.g_cartoon.clientWidth / 2 ;
    imageColor.y = this.g_cartoon.clientHeight / 2 ;
    imageColor.setSize(this.g_cartoon.clientWidth, this.g_cartoon.clientHeight);
    imageColor.init();
    imageColor.fillColor = this.g_background_color;
    this.render(imageColor, -999999)

    const image = this.g_cartoon.createCartoonElement("bg_1280_720_Ruler", "MySprite").ref;
    image.init(this.g_cartoon.images.get("_bg_1280_720_Ruler"));
    image.x = this.g_canvasWidth / 2;
    image.y = this.g_canvasHeight /2;
    image.visible = this.g_EnableStageRuler
    this.g_cartoon.setOrigin( image.x-(bgWidth/2*this.g_mapScale), image.y-(bgHeight/2*this.g_mapScale)  )
    this.g_cartoon.setRelativeOrigin( -bgWidth/2, -bgHeight/2)
    image.setScaleXY(this.g_mapScale);
    this.render(image, -999999)
    this.g_stage = image
  }

  render(ele, zIndex?:number){
    this.m_renderObject.push({element:ele, zIndex:zIndex?zIndex:1})
    this.m_renderObject.sort((a,b)=>{
      return a.zIndex - b.zIndex
    })
    this.m_renderArr = []
    this.m_renderObject.forEach(item=>{
      this.m_renderArr.push(item.element)
    })    
  }

  sendServerEvent(key, data) {
    const c = (<any> window).courseware;
    c.sendEvent(key, JSON.stringify(data));
  }

  addServerListener(msg_key, callback) {
    const c = (<any> window).courseware;
    c.onEvent(msg_key, (data,next) => {
      callback(JSON.parse(data))
      next && next();
    });
  }

  randomArray_shuffle(array) {
    var input = array;
    for (var i = input.length-1; i >=0; i--) {
        var randomIndex = Math.floor(Math.random()*(i+1));
        var itemAtIndex = input[randomIndex];
        input[randomIndex] = input[i];
        input[i] = itemAtIndex;
    }
    return input;
  }

  paginationArray(pageNo, pageSize, array) {
    var offset = (pageNo - 1) * pageSize;
    return (offset + pageSize >= array.length) ? array.slice(offset, array.length) : array.slice(offset, offset + pageSize);
  }

  stopAllTimeout(){
    this.m_setTimeoutIDs.forEach(id=>clearTimeout(id))
    this.m_setTimeoutIDs = []
  }

  stopAllInterval(){
    this.m_setIntervalIDs.forEach(id=>clearInterval(id))
    this.m_setIntervalIDs = []
  }

  topOfRenderArray(element){
    let index = this.m_renderArr.indexOf(element)
    if(index !=-1){
      this.m_renderArr.splice(index, 1)
      this.m_renderArr.push(element)
    }   
  }

  setRenderZIndex(element, zIndex){
    let index = null;
    for(let i=0; i<this.m_renderObject.length; i++){
      if( this.m_renderObject[i].element.id == element.id ){
        index = i
      }
    }
    if(index){
      this.m_renderObject.splice(index, 1)
      this.m_renderObject.push({element:element, zIndex:zIndex?zIndex:1})
      this.m_renderObject.sort((a,b)=>{
        return a.zIndex - b.zIndex
      })
  
      this.m_renderArr = []
      this.m_renderObject.forEach(item=>{
        this.m_renderArr.push(item.element)
      })
    }
  }
  
  deleteElementInRender(id){
    let index = null;
    for(let i=0; i<this.m_renderObject.length; i++){
      if( this.m_renderObject[i].element.id == id ){
        index = i
      }
    }
    if(index){
      this.m_renderObject.splice(index, 1)
      this.m_renderObject.sort((a,b)=>{
        return a.zIndex - b.zIndex
      })
      this.m_renderArr = []
      this.m_renderObject.forEach(item=>{
        this.m_renderArr.push(item.element)
      })
    }
  }

  enableMoveAsstant(callback){
    if(this.m_moveAsstantIntervalId){
      clearInterval(this.m_moveAsstantIntervalId)
    }
    this.m_moveAsstantIntervalId = setInterval(()=>{
      callback()
    },50)
  }

  disableMoveAsstant(){
    clearInterval(this.m_moveAsstantIntervalId)
  }

  cleanSystemVar(){
    this.m_mapDownQueue = {}
    this.m_mapDownArray = []
    this.m_mapDownObject = []
    this.m_mapUpQueue = {}
    this.m_mapMoveArray = []
    this.m_mapMoveObject = []
    this.stopAllInterval();
    this.stopAllTimeout()
    this.g_cartoon.stopAllAudio()
  }













  













  












  // --------------------------------------------------
  // --------------  Template function  ---------------
  // --------------------------------------------------
  // --------------------------------------------------
  // --------------------------------------------------
  // 
  //                .-~~~~~~~~~-._       _.-~~~~~~~~~-.
  //            __.'              ~.   .~              `.__
  //          .'//                  \./                  \\`.
  //        .'//                     |                     \\`.
  //      .'// .-~"""""""~~~~-._     |     _,-~~~~"""""""~-. \\`.
  //    .'//.-"                 `-.  |  .-'                 "-.\\`.
  //  .'//______.============-..   \ | /   ..-============.______\\`.
  //.'______________________________\|/______________________________`.
  //
  // --------------------------------------------------
  // showParticle( element_id )                 泡泡效果
  // --------------------------------------------------
  // showEndPatal()  /  stopEndPatal()  花瓣飘落结束动画 
  // --------------------------------------------------
  // showCorrectPatal()                 指定元素上面飘花
  // --------------------------------------------------
  // convertPercentToRadian()   将百分比转换为弧长 第一个参数是百分比，第二个参数是方向 true为逆时针，false为顺时针。用于ShapeCircle换圆弧
  // --------------------------------------------------
  // movePaoWuxian()                        元素抛物线跳
  // --------------------------------------------------
  // showJellyAnimation()------------------------------
  // showBlingStar()----------------------显示星星效果--
  // --------------------------------------------------
  


  // 泡泡
  showParticle(card) {
    let myCard = this.g_cartoon.getCartoonElementRelativePosition(card.id)
    showPopParticle(this.g_cartoon.images.get("_bubble"), { x: myCard.x , y: myCard.y }, this.g_stage);
  }

  // 选择正确动画
  showCorrectPatal(card_id, showTime, callback?) {
    this.m_elementPetalArr = [];
    this.m_showElementPetalFlag = true;
    this.addCorrectPetal(card_id);
    setTimeout(()=>{
      this.m_elementPetalArr = [];
      this.m_showElementPetalFlag = false;
      callback && callback()
    },showTime)
  }
  stopAllCorrectPatal(){
    this.m_elementPetalArr = [];
    this.m_showElementPetalFlag = false;
  }

  addCorrectPetal(card_id) {
    if (!this.m_showElementPetalFlag) {
      return;
    }

    let element = this.g_cartoon.getCartoonElement(card_id)
    const petal = new MySprite(this.g_ctx);

    const id = Math.ceil(Math.random() * 3);
    petal.init(this.g_cartoon.images.get(this.m_PetalImage + id));

    const randomS = (Math.random() * 0.4 + 0.6) * this.g_mapScale * 0.5;
    petal.setScaleXY(randomS);

    const randomR = Math.random() * 360;
    petal.rotation = randomR;

    const randomX = Math.random() * element.ref.width * this.g_mapScale;

    petal.x = element.ref.x - (element.ref.width * this.g_mapScale / 2) + randomX;
    petal.y = element.ref.y - (element.ref.height * this.g_mapScale / 2);

    const randomT = 1 + Math.random() * 2;
    petal["time"] = randomT;

    let randomTR = 360 * Math.random(); // - 180;
    if (Math.random() < 0.5) {
      randomTR *= -1;
    }
    petal["tr"] = randomTR;

    this.m_elementPetalArr.push(petal);
    moveItem(
      petal,
      petal.x,
      element.ref.y + (element.ref.height * this.g_mapScale / 2),
      petal["time"],
      () => {
        removeItemFromArr(this.m_elementPetalArr, petal);
      }
    );
    rotateItem(petal, petal["tr"], petal["time"]);
    setTimeout(() => {
      this.addCorrectPetal(card_id);
    }, 200);
  }


  // 结束动画花瓣飘落
  showEndPatal() {
    this.m_endPageArr = [];
    this.m_showPetalFlag = true;
    this.addPetal();
  }

  stopEndPatal() {
    this.m_endPageArr = [];
    this.m_showPetalFlag = false;
  }

  addPetal() {
    if (!this.m_showPetalFlag) {
      return;
    }
    const petal = this.getPetal();
    this.m_endPageArr.push(petal);
    moveItem(
      petal,
      petal.x,
      this.g_canvasHeight + petal.height * petal.scaleY,
      petal["time"],
      () => {
        removeItemFromArr(this.m_endPageArr, petal);
      }
    );
    rotateItem(petal, petal["tr"], petal["time"]);
    setTimeout(() => {
      this.addPetal();
    }, 100);
  }

  getPetal() {
    const petal = new MySprite(this.g_ctx);

    const id = Math.ceil(Math.random() * 3);
    petal.init(this.g_cartoon.images.get(this.m_PetalImage + id));

    const randomS = (Math.random() * 0.4 + 0.6) * this.g_mapScale;
    petal.setScaleXY(randomS);

    const randomR = Math.random() * 360;
    petal.rotation = randomR;

    const randomX = Math.random() * this.g_canvasWidth;
    petal.x = randomX;
    petal.y = (-petal.height / 2) * petal.scaleY;

    const randomT = 2 + Math.random() * 5;
    petal["time"] = randomT;

    let randomTR = 360 * Math.random(); // - 180;
    if (Math.random() < 0.5) {
      randomTR *= -1;
    }
    petal["tr"] = randomTR;

    return petal;
  }


  showJellyAnimation(element_id){
    let element = this.g_cartoon.getCartoonElement(element_id).ref
    tweenChange(element,{ scaleX: this.g_mapScale * 1.1 , scaleY: this.g_mapScale * 1.1 }, 0.1, ()=>{
      tweenChange(element,{ scaleX: this.g_mapScale * 0.9 , scaleY: this.g_mapScale * 0.9 }, 0.1, ()=>{
        tweenChange(element,{ scaleX: this.g_mapScale , scaleY: this.g_mapScale }, 0.1 )
      })
    })
  }

  showShakeAnimation(element_id){
    let element = this.g_cartoon.getCartoonElement(element_id).ref
    let originX = element.x
    tweenChange(element,{ x: originX - 10*this.g_mapScale }, 0.1, ()=>{
      tweenChange(element,{ x: originX + 10*this.g_mapScale }, 0.1, ()=>{
        tweenChange(element,{ x: originX }, 0.1 )
      })
    })
  }

  convertPercentToRadian(per, direction){
    let radian = 0;
    if(direction) { //逆时针
      if(per*360 > 270){
        radian = 361 - (per*360 - 270)
      }else{
        radian = 270 - per*360
      }
    }else{ //顺时针
      if(per*360 > 90){
        radian = per*360 - 90
      }else{
        radian = 270 + per*360
      }
    }
    return (radian * Math.PI) / 180;
  }

  showBlingStar(element){
    let rect =  element.getBoundingBox()
    showBlingBling(this.g_cartoon.images.get('_star'), rect, element, 0.5, 1, 0.08, 2);
    setTimeout(()=>{
      showBlingBling(this.g_cartoon.images.get('_star'), rect, element, 0.5, 1, 0.08, 1.8);
    },200)
    setTimeout(()=>{
      showBlingBling(this.g_cartoon.images.get('_star'), rect, element, 0.5, 1, 0.08, 1.6);
    },400)
  }

  movePaoWuxian(element,dis,time,callback?){
    let disX = dis.x - element.x
    let disY = (element.y - dis.y) 
    let count = 0
    let runTime = time/5
    let vx = disX/runTime
    let a = -0.05
    let vy0 = disY/runTime - 0.5*a*runTime
    let id = setInterval(()=>{
      element.x += vx
      element.y -= vy0 + a*count
      count++;
      if(count>runTime){
        clearInterval(id)
        callback && callback()
      }
    }, 5);
  }
}

