import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { NzMessageService } from 'ng-zorro-antd/message';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "JJ21";

  baseData = {"templateType":"select","quesArr":[{"itemType":"jump","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/263eeb5c2d8f1be37da46b9905e037ad.jpg","rect":{"x":0,"y":164.59,"width":1218,"height":562.82}},"hotZoneItemArr":[{"id":"1712912928089","index":0,"pic_url":"http://staging-teach.cdn.ireadabc.com/23d48c020f931bd85ddc9daa41270872.png","itemType":"pic","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":0.7215639810426541,"imgSizeW":938,"imgSizeH":128,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"3","posX":609,"posY":241,"anchorGroup":2,"sizeW":200,"sizeH":200,"rect":{"x":270.59,"y":30.23,"width":676.83,"height":92.36}},{"id":"1712913539755","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/aa4e5f49b086499ac4d244e0418183a0.png","itemType":"pic","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":0.7215639810426541,"imgSizeW":870,"imgSizeH":496,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"3","posX":608.995,"posY":399.50004739336487,"sizeW":356.45,"sizeH":357.9,"rect":{"x":295.11,"y":136.46,"width":627.76,"height":357.9}},{"id":"1712914383471","index":2,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"0","posX":644,"posY":192.5000473933649,"checkbox":{"title":"","list":[{"label":"自动换行","value":"warp"}]},"labelArr":[{"type":"inputText","key":"title","title":"标题","value":"问题文本"},{"key":"key","title":"key","value":"ques_text"},{"key":"fontName","title":"字体","value":""},{"key":"fontSize","title":"大小","value":"35"},{"key":"fontColor","title":"颜色","value":"#303030"}],"anchorGroup":2,"sizeW":520,"sizeH":74,"rect":{"x":384,"y":34.41,"width":520,"height":74}},{"id":"1712913945740","index":3,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/f492bd50a95421aa1927d848ccd6933f.json","name":"laba_h_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/3d4901b33bfe7ea80b337cbf7344fc34.json","name":"laba_h_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/4d06e839a30396115249d582da4a9e22.png","name":"laba_h_tex.png"},"dragDot":{"x":609,"y":446},"gIdx":"14","posX":339,"posY":235.00004739336487,"labelArr":[{"type":"inputAudio","key":"title","title":"标题","value":"问题音频"},{"key":"key","title":"key","value":"ques_audio"}],"anchorGroup":2,"sizeW":74.00009478672973,"sizeH":74.00009478672973,"rect":{"x":302,"y":33.41,"width":74,"height":74}},{"id":"1712914551743","index":4,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"8","labelArr":[{"type":"inputText","key":"title","title":"标题","value":"正确答案"},{"key":"key","title":"key","value":"answer_text"}],"rect":{"x":509,"y":181.41,"width":200,"height":200}},{"id":"1712914697060","index":5,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"11","posX":1007,"posY":519.0000473933649,"sizeW":118,"sizeH":118,"rect":{"x":948,"y":295.41,"width":118,"height":118}},{"id":"1712915332341","index":6,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"22","posX":609,"posY":606.5000473933649,"labelArr":[{"key":"distanceX","title":"间距","value":"5"}],"picArr":[{"title":"普通未选中","pic_url":"http://staging-teach.cdn.ireadabc.com/31a3eaee5c9bb4ffad1287596f95b6ad.png"},{"title":"正确未选中","pic_url":"http://staging-teach.cdn.ireadabc.com/0f4773ffd54353a119bef36683909371.png"},{"title":"错误未选中","pic_url":"http://staging-teach.cdn.ireadabc.com/db36596675204a6afa382dcf02ae5e8a.png"},{"title":"普通已选中","pic_url":"http://staging-teach.cdn.ireadabc.com/cea669d13c4ad6922148e65470016062.png"},{"title":"正确已选中","pic_url":"http://staging-teach.cdn.ireadabc.com/20db71c3fc69779dd1a535bf92b72a14.png"},{"title":"错误已选中","pic_url":"http://staging-teach.cdn.ireadabc.com/016b6e204095b4cc97be4b6945d66886.png"}],"anchorGroup":8,"sizeW":200,"sizeH":46,"rect":{"x":509,"y":499.41,"width":200,"height":46}},{"id":"1713432778201","index":7,"itemType":"rect","fontScaleX":0.9515625,"fontScaleY":0.9515625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9515625,"dragDot":{"x":609,"y":446},"gIdx":"21","posX":604,"posY":474.00004739336487,"checkbox":{"title":"","list":[{"label":"自动换行","key":"warp","value":true}]},"labelArr":[{"type":"multResRect","key":"title","title":"标题","value":"中间提示"},{"key":"key","title":"key","value":"tip_res"},{"key":"fontName","title":"字体"},{"key":"fontSize","title":"大小","value":"24"},{"key":"fontColor","title":"颜色","value":"#303030"}],"sizeW":558,"sizeH":288.00009478672973,"rect":{"x":325,"y":165.41,"width":558,"height":288}}]}],"customTypeGroupArr":[{"name":"输入型文本","rect":true,"isShowPos":true,"labelArr":[{"type":"inputText","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"fontName","title":"字体"},{"key":"fontSize","title":"大小"},{"key":"fontColor","title":"颜色"}],"checkbox":{"title":"","list":[{"label":"自动换行","key":"warp","value":false}]},"anchorGroup":true},{"name":"固定型文本","text":true,"audio":true,"isShowPos":true,"labelArr":[{"key":"fontName","title":"字体"},{"key":"fontSize","title":"大小"},{"key":"fontColor","title":"颜色"}]},{"name":"输入型图片","rect":true,"isShowPos":true,"labelArr":[{"type":"inputPic","key":"title","title":"标题"},{"key":"key","title":"key","value":""}]},{"name":"固定型图片","pic":true,"audio":true,"anchorGroup":true,"isShowPos":true},{"name":"输入型动画","rect":true,"isShowPos":true,"labelArr":[{"key":"title","title":"标题"}]},{"name":"固定型动画","rect":true,"anima":true,"audio":true,"isShowPos":true},{"name":"输入型音频","rect":true,"isShowPos":true,"labelArr":[{"type":"inputAudio","key":"title","title":"标题"},{"key":"key","title":"key","value":""}]},{"name":"固定型音频","rect":true,"audio":true,"pic":true,"anim":true,"isShowPos":true},{"name":"数据型文本","data":true,"labelArr":[{"type":"inputText","key":"title","title":"标题"},{"key":"key","title":"key"}]},{"name":"数据型图片","labelArr":[{"type":"inputPic","key":"title","title":"标题","value":""},{"key":"key","title":"key","value":""}]},{"name":"翻页按钮组","rect":true,"audio":true,"isShowPos":true},{"name":"录音按钮组","rect":true,"audio":true,"isShowPos":true},{"name":"文字选项组","rect":true,"picArr":[{"title":"默认图"},{"title":"正确图"},{"title":"错误图"}],"labelArr":[{"type":"inputText","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"fontSize","title":"字体大小"},{"key":"fontName1","title":"普通字体"},{"key":"fontColor1","title":"普通颜色"},{"key":"fontName2","title":"正确字体"},{"key":"fontColor2","title":"正确颜色"},{"key":"fontName3","title":"错误字体"},{"key":"fontColor3","title":"错误颜色"}],"checkbox":{"title":"","list":[{"label":"适配矩形","key":"isScale"}]},"isOption":true,"isShowPos":true,"isCopy":true},{"name":"图片选项组","rect":true,"picArr":[{"title":"输入参考图"},{"title":"默认背景图"},{"title":"正确背景图"},{"title":"错误背景图"}],"labelArr":[{"type":"inputPic","key":"title","title":"标题"},{"key":"key","title":"key"}],"checkbox":{"title":"","list":[{"label":"遮罩","key":"isMask"},{"label":"适配矩形","key":"isScale"}]},"isOption":true,"isShowPos":true,"isCopy":true},{"name":"音频型动画","rect":true,"anima":true,"labelArr":[{"type":"inputAudio","key":"title","title":"标题"},{"key":"key","title":"key"}],"anchorGroup":true,"isShowPos":true,"isCopy":true},{"name":"选项效果组","picArr":[{"title":"正确效果"},{"title":"错误效果"}],"audioArr":[{"title":"正确音效"},{"title":"错误音效"}],"anchorGroup":true,"isCopy":true},{"name":"数组排列区","rect":true,"checkbox":{"title":"","list":[{"label":"横向排列","key":"hor"}]},"labelArr":[{"key":"id","title":"id"},{"key":"distanceX","title":"横向间距"},{"key":"distanceY","title":"纵向间距"}],"isShowPos":true,"isShowSize":true,"isCopy":true},{"name":"文字排列物","rect":true,"picArr":[{"title":"默认图"},{"title":"正确图"},{"title":"错误图"}],"labelArr":[{"type":"listInputText","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"id","title":"id"},{"key":"fontSize","title":"字体大小"},{"key":"fontName1","title":"普通字体"},{"key":"fontColor1","title":"普通颜色"},{"key":"fontName2","title":"正确字体"},{"key":"fontColor2","title":"正确颜色"},{"key":"fontName3","title":"错误字体"},{"key":"fontColor3","title":"错误颜色"}],"radio":{"title":"文字位置","list":[{"label":"开头","key":"start"},{"label":"中间","key":"middle"},{"label":"结尾","key":"end"}]},"isShowPos":true,"isCopy":true},{"name":"图片排列物","rect":true,"picArr":[{"title":"输入参考图"},{"title":"默认背景图"},{"title":"正确背景图"},{"title":"错误背景图"}],"labelArr":[{"type":"listInputPic","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"id","title":"id"}],"checkbox":{"title":"","list":[{"label":"遮罩","key":"isMask"}]},"isShowPos":true,"isCopy":true},{"name":"拖拽文字组","rect":true,"picArr":[{"title":"默认图"},{"title":"正确图"},{"title":"错误图"}],"labelArr":[{"type":"listInputText","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"fontSize","title":"字体大小"},{"key":"fontName1","title":"普通字体"},{"key":"fontColor1","title":"普通颜色"},{"key":"fontName2","title":"正确字体"},{"key":"fontColor2","title":"正确颜色"},{"key":"fontName3","title":"错误字体"},{"key":"fontColor3","title":"错误颜色"}],"checkbox":{"title":"","list":[{"label":"结束块","key":"isEndRect"}]},"isShowPos":true,"isCopy":true},{"name":"拖拽图片组","rect":true,"picArr":[{"title":"输入参考图"},{"title":"默认背景图"},{"title":"正确背景图"},{"title":"错误背景图"}],"labelArr":[{"type":"listInputPic","key":"title","title":"标题"},{"key":"key","title":"key"}],"checkbox":{"title":"","list":[{"label":"遮罩","key":"isMask"},{"label":"结束块","key":"isEndRect"}]},"isShowPos":true,"isCopy":true},{"name":"多类型区域","rect":true,"labelArr":[{"type":"multResRect","key":"title","title":"标题"},{"key":"key","title":"key"},{"key":"fontName","title":"字体"},{"key":"fontSize","title":"大小"},{"key":"fontColor","title":"颜色"}],"checkbox":{"title":"","list":[{"label":"自动换行","key":"warp","value":false}]},"anchorGroup":true,"isShowPos":true,"isCopy":true},{"name":"翻页小点区","rect":true,"picArr":[{"title":"普通未选中"},{"title":"正确未选中"},{"title":"错误未选中"},{"title":"普通已选中"},{"title":"正确已选中"},{"title":"错误已选中"}],"labelArr":[{"key":"distanceX","title":"间距"}],"anchorGroup":true,"isShowPos":true,"isCopy":true}],"isTurnPage":true,"tempItem":{"quesArr":[]}}
  
  // 储存对象
  item;
  //临时储存对象
  tempItem;


  templateTypeArr = [
    {name:"选择题", value: "select"},
    {name:"拖拽题", value: "drag"},
    {name:"语音评测", value: "record"},
    // {name:"连线题", value: "line"},
    // {name:"翻翻卡", value: "flip"},
  ]

  isPreviewTemplate = false;




  customTypeGroupArr = [
    {
      name: '输入型文本',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "fontName", title:"字体"},
        {key: "fontSize", title:"大小"},
        {key: "fontColor", title:"颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '自动换行', key: 'warp', value:false}
        ]
      },
      anchorGroup: true,

    },


    {
      name: '固定型文本',
      text: true,
      audio: true,
      isShowPos: true,
      labelArr: [
        {key: "fontName", title:"字体"},
        {key: "fontSize", title:"大小"},
        {key: "fontColor", title:"颜色"},
      ]
    },


    {
      name: '输入型图片',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputPic", key: "title", title:"标题"},
        {key: "key", title:"key", value:""},
      ]
    },


    {
      name: '固定型图片',
      pic: true,
      audio: true,
      anchorGroup: true,
      isShowPos: true,
    },


    {
      name: '输入型动画',
      rect: true,
      isShowPos: true,
      labelArr: [
        {key: "title", title:"标题"},
      ]
    },

   
    {
      name: '固定型动画',
      rect: true,
      anima: true,
      audio: true,
      isShowPos: true,
    }, 


    {
      name: '输入型音频',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputAudio", key: "title", title:"标题"},
        {key: "key", title:"key", value:""},
      ]
    },


    {
      name: '固定型音频',
      rect: true,
      audio: true,
      pic: true,
      anim: true,
      isShowPos: true,
    },

     
    {
      name: '数据型文本',
      data: true,
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ]
    }, 


    {
      name: '数据型图片',
      // data: true,
      labelArr: [
        {type:"inputPic", key: "title",  title:"标题", value:""},
        {key: "key", title:"key", value:""},
      ]
    }, 

   
    {
      name: '翻页按钮组',
      rect: true,
      audio: true,
      // radio: {
      //   title: "按钮",
      //   list: [
      //     {label: '上一页', key: 'prev'},
      //     {label: '下一页', key: 'next'},
      //     {label: '翻页文本', key: 'text'},
      //   ]
      // },
      isShowPos: true,
    },


    {
      name: '录音按钮组',
      rect: true,
      audio: true,
      isShowPos: true,
    },


    {
      name: '文字选项组',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '适配矩形', key:'isScale'},
        ]
      },
      isOption: true,
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '图片选项组',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"inputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          {label: '适配矩形', key:'isScale'},
        ]
      },
      isOption: true,
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '音频型动画',
      rect: true,
      anima: true,
      labelArr: [
        {type:"inputAudio", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      anchorGroup: true,
      isShowPos: true,
      isCopy: true,
    },
    

    {
      name: '选项效果组',
      picArr: [
        {title: '正确效果'},
        {title: '错误效果'},
      ],
      audioArr: [
        {title: '正确音效'},
        {title: '错误音效'},
      ],
      anchorGroup: true,
      isCopy: true,
    },


    {
      name: '数组排列区',
      rect: true,
      checkbox: {
        title: '',
        list: [
          {label: '横向排列', key:'hor'},
        ]
      },
      // select: {
      //   title: '类型',
      //   list:[
      //     {label: '拖拽开始区', value:'dragStart'},
      //     {label: '拖拽结束区', value:'dragEnd'},
      //   ]
      // },
      labelArr: [
        {key: "id",  title:"id"},
        {key: "distanceX",  title:"横向间距"},
        {key: "distanceY",  title:"纵向间距"},
      ],
      isShowPos: true,
      isShowSize: true,
      isCopy: true,
    },

    {
      name: '文字排列物',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"listInputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "id", title:"id"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],

      radio: {
        title: "文字位置",
        list: [
          {label: '开头', key: 'start'},
          {label: '中间', key: 'middle'},
          {label: '结尾', key: 'end'},
        ]
      },


      // checkbox: {
      //   title: '',
      //   list: [
      //     {label: '结束块', key:'isEndRect'},
      //   ]
      // },

      isShowPos: true,
      isCopy: true,
    },

    {
      name: '图片排列物',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"listInputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "id", title:"id"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          // {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },

    {
      name: '拖拽文字组',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"listInputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '拖拽图片组',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"listInputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },

    {
      name: '多类型区域',
      rect: true,

      labelArr: [
        {type:"multResRect", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "fontName", title:"字体"},
        {key: "fontSize", title:"大小"},
        {key: "fontColor", title:"颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '自动换行', key: 'warp', value:false}
        ]
      },
      anchorGroup: true,
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '翻页小点区',
      rect: true,
      picArr: [
        {title: '普通未选中'},
        {title: '正确未选中'},
        {title: '错误未选中'},
        {title: '普通已选中'},
        {title: '正确已选中'},
        {title: '错误已选中'},
      ],
      labelArr: [
        {key: "distanceX",  title:"间距"},
      ],
      // checkbox: {
      //   title: '',
      //   list: [
      //     {label: '遮罩', key:'isMask'},
      //     {label: '结束块', key:'isEndRect'},
      //   ]
      // },
      anchorGroup: true,
      isShowPos: true,
      isCopy: true,
    },
  ];
 



  curSelectItem;
  isShowKK=false;
  curSelectKK;
  KKArray = [
    "i",
    "ɪ",
    "u",
    "ʊ",
    "ɑ",
    "ʌ",
    "ɝ",
    "ə",
    "ɚ",
    "ɔ",
    "æ",
    "ɛ",
    "e",
    "aɪ",
    "ɔɪ",
    "o",


    "aʊ",
    "p",
    "b",
    "t",
    "d",
    "k",
    "g",
    "tʃ",
    "dʒ",
    "f",
    "v",
    "θ",
    "ð",
    "s",
    "z",
    "ʃ",
    "ʒ",
    "h",
    "m",
    "n",
    "ŋ",
    "l",
    "r",
    "w",
    "j",
  ]
  customTypeGroupArr2 = [
    {
      name: '星星区域',
      rect: true,
    },
    {
      name: '选择区域',
      rect: true,
    },
  ]

  stepArr = [
    {label: '视频时间', value: 'ques'},
  ];

  videoSizeArr = [
    {key: '1920_1080', value: '1920 x 1080'},
    {key: '1280_720', value: '1280 x 720'},
    {key: '940_600', value: '940 x 600'},
  ]

  audioTypeArr = [
    {key: 'begin', info: '第一遍开始音频'},
    {key: 'begin_2', info: '第二遍开始音频'},
    {key: 'finish', info: '第二遍结束音频'},
  ]


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef, 
    private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {


      if (data) {
        this.item = data;
        this.tempItem = data.tempItem;
      }

      this.initItem();


      console.log("this.item: ", JSON.stringify(this.item));
      
      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }

  initItem() {
    if (this.baseData) {
      this.item = this.baseData;
    }

    if (this.tempItem) {
      this.item.tempItem = this.tempItem;
    }
  }

  init() {

    if (!this.item.templateType) {
      this.item.templateType = 'select';
    }

    if (!this.item.quesArr) {
      this.item.quesArr = [];
    }

    // if (!this.item.readingItemArr) {
    //   this.item.readingItemArr = [];
    // }

    if (this.baseData) {
      this.showPreviewTemplate();
    }
  }



  templateTypeChange(e) {
    console.log("in templateTypeChange e: ", e);
    this.item.templateType = e;
    this.save();
  }






  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }


  itemSplitTypeChange(e, it) {
    it.splitType = e;
    this.save();
  }
  videoTypeChange(e) {
    console.log('e: ', e);
    this.item.videoType = e;
    this.save();
  }

  addBtnClick() {
    this.item.quesArr.push({
      itemType: 'jump'
    });
    this.save();
  }



  deleteBtnClick(i) {
    this.item.quesArr.splice(i, 1);
    this.save();
  }



  radioChange(e, item, key) {
    console.log('e: ', e);
    item[key] = e;
    this.save();
  }

  onVideoUploadSuccess(e) {
    console.log('e: ', e);
    this.item.video_url = e.url;
    this.save();
  }

  videoSeeked(e) {

  }

  videoError(e) {

  }

  videoLoaded(e, it) {

  }


  saveHotZone(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    this.save();
  }

  saveHotZone2(group, e) {
    console.log('e2: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem2 = bgItem;
    group.hotZoneItemArr2 = hotZoneItemArr;

    this.save();
  }


  getLRC(evt) {
    this.item.lrcData = evt;
    this.save();

  }

  onVideoUploaded(res, key, item) {
    if (!item) {
      item = this.item;
    }
    console.log('onVideoUploaded: ', res);

    item[key] = res.url;
    this.save();
  }

  isTurnPageChange(e) {
    console.log("e: ", e);
  }
  

  onItemImgUploadSuccess(e, item, key='pic_url') {
    item[key] = e.url;
    // console.log('item: ', item);
    this.save();
  }

  onItemAudioUploadSuccess(e, item, key='audio_url') {
    item[key] = e.url;
    this.save();
    // console.log('item: ', item);
  }

  onDeleteImage(it, key) {
    delete it[key];
    this.save();
  }

  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item) {

    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, it) {
    it[key] = e.url;
    this.save();
  }

  KKBtnClick(it) {
    this.curSelectItem = it;
    this.isShowKK = true
  }

  KKHandleCancel() {
    this.isShowKK = false;
    this.curSelectKK = null;
    this.curSelectItem = null;
  }

  KKHandleOk() {

    // if (!this.curSelectItem.KKText) {
    //   this.curSelectItem.KKText = '';
    // }
    this.curSelectItem.KKText = this.curSelectKK;
   
    this.KKHandleCancel();

    this.save();
  }
 
  saveItemText(it, key) {
    console.log('it: ', it);
    this.save();
  }

  getItemHasInputPic(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputPic';
  }

  getItemHasInputAudio(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputAudio';
  }

  getItemHasInputText(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputText';
  }

  getItemHasTargetType(it, targetType) {
    return it.labelArr && it.labelArr[0]?.type == targetType;
  }

  addListItem(it, key) {

    if (!it[key]) {
      it[key] = [];
    }
    it[key].push({});
  }

  deleteListItem(arr, i) {
    arr.splice(i, 1);
    // this.save();
  }
 

  showPreviewTemplate() {
    this.isPreviewTemplate = true;

      //正常模板显示 赋值数据
      if (this.baseData && this.item.tempItem) {

        this.tempItem = this.item.tempItem;
      } else {
        
        this.tempItem = {}
        this.tempItem.quesArr = [];
        // this.addOnePageBtnClick();
      }

  }

  hidePreviewTemplate() {
    this.isPreviewTemplate = false;
  }

  addOnePageBtnClick() {
    const hotZoneItemArr = this.item?.quesArr[0]?.hotZoneItemArr;
    if (!this.tempItem || !this.tempItem.quesArr) {
      this.tempItem = {quesArr:[]};
    }
    this.tempItem.quesArr.push( 
      JSON.parse(JSON.stringify(hotZoneItemArr))
    );
    
    this.save();
  }

  deletePageBtnClick(i) {
    this.tempItem.quesArr.splice(i, 1);
    this.save();
  }


  /**
   * 储存数据
   */
  save() {

    if (this.tempItem) {
      this.item.tempItem = this.tempItem;
    }

    if (this.customTypeGroupArr) {
      this.item.customTypeGroupArr = this.customTypeGroupArr;
    }

    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();

    console.log('---- item -----')
    console.log(JSON.stringify(this.item));

    this.message.create('success', "保存成功");

  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}