import {
  AfterViewInit,
  Component,
  ElementRef, EventEmitter,
  Input,
  OnChanges,
  OnDestroy,
  OnInit, Output,
  ViewChild
} from '@angular/core';
import {fromEvent, Observable, Subscription} from 'rxjs';

declare global {
  interface Window {
    FBOARD: any;
    FormulaBoard: any;
    __initfp__: any;
    __tmp_fp_input_model__: any;
    __FormulaBoard_js_installed__: any;
  }
}




@Component({
  selector: 'app-formula-input',
  templateUrl: './formula-input.component.html',
  styleUrls: ['./formula-input.component.scss']
})

export class FormulaInputComponent implements OnInit, OnChanges, OnDestroy, AfterViewInit {

  @ViewChild('inputEl', {static: true }) inputEl: ElementRef;
  // @ViewChild('wrapperEl', {static: true }) wrapperEl: ElementRef;
  private fboard: any;

  // [(ngModel)]="item.title" (blur)="save()"
  @Input() ngfModel: any;
  @Output() ngfModelChange = new EventEmitter();
  @Output() ngfBlur = new EventEmitter();

  FB_id = 'FormulaBoard';
  private esc: Subscription;




  constructor() {
    if (!window.__FormulaBoard_js_installed__) {
      window.__FormulaBoard_js_installed__ = true;
      const s = document.createElement('script');
      s.src = 'assets/formula-board/formula-board.js';
      document.head.append(s);
      s.addEventListener('load', () => {
        this.FormulaBoardInit();
      });

    }

  }
  ngOnInit() {

  }
  ngOnChanges() {

  }
  ngOnDestroy(): void {

  }
  valueChanged(evt) {
    console.log('valueChanged', this.ngfModel, evt);
    this.ngfModelChange.emit(evt);
  }
  showFormulaPad(e) {
    // console.log('showFormulaPad', e);
    window.FBOARD.set(e.target.value);
    window.__tmp_fp_input_model__ = this;
    const rect = this.inputEl.nativeElement.getBoundingClientRect();
    const fb = document.getElementById(this.FB_id);
    fb.style.position = 'fixed';
    // @ts-ignore
    const padWidth = $('#' + this.FB_id).outerWidth() * .8;
    // @ts-ignore
    const padHeight = $('#' + this.FB_id).outerHeight() * .8;
    // @ts-ignore
    const ww = $(window).innerWidth();
    // @ts-ignore
    const hh = $(window).innerHeight();
    const left = (ww - padWidth) / 2;
    const top = (hh - padHeight) / 2;

    console.log('left', left);
    fb.style.left = left + 'px';
    fb.style.top = top + 'px';
    fb.style.visibility = 'visible';
  }
  updateValue(val) {
    this.ngfModel = val;
    this.ngfModelChange.emit(val);
  }
  ngAfterViewInit() {}
  FormulaBoardInit() {
    // if (window.__initfp__) {
    //   return;
    // }
    // window.__initfp__ = true;
    window.FBOARD = new window.FormulaBoard({
      // container: this.wrapperEl.nativeElement,
      id: this.FB_id,
      path: 'assets/formula-board/',
      options: {
        width: 1920,
        mode: 'pc',
        bottom: false,
      }});
    document.addEventListener('documentMessage', (e) => {
      // @ts-ignore
      const {type} = e.detail;
      if (type === 'common.setFormula') {
        // @ts-ignore
        const {formula} = e.detail.data.body;
        console.log(formula);
        window.FBOARD.clear();
        // @ts-ignore
        window.__tmp_fp_input_model__.updateValue(formula);
        window.FBOARD.editor.style.visibility = 'hidden';
        this.ngfBlur.emit();
      }
      if (type === 'common.closeModal') {
        window.FBOARD.editor.style.visibility = 'hidden';
      }
    });
  }
}

