import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-anchor-group',
  templateUrl: './anchor-group.component.html',
  styleUrls: ['./anchor-group.component.scss']
})
export class AnchorGroupComponent implements OnDestroy, OnChanges {
  uploading = false;
  progress = 0;

  @Input()
  activeIndex;




  
  @Output()
  save = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();



  uploadUrl;
  uploadData;

  panelVisible = false;
  colorArr = [
    {name: 'red', color: '#ff0000'},
    {name: 'green', color: '#00ff00'},
    {name: 'blue', color: '#0000ff'},
    {name: 'yellow', color: '#ffff00'},
  ]

  // activeIndex: number | null = null;

  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    // this.uploadUrl = (<any> window).courseware.uploadUrl();
    // this.uploadData = (<any> window).courseware.uploadData();

    // window['air'].getUploadCallback = (url, data) => {
    //   this.uploadUrl = url;
    //   this.uploadData = data;
    // };

  }
  ngOnChanges() {
 
  }




  onClick(index: number) {
    console.log(`Square ${index} clicked`);
    this.activeIndex = index;

    this.save.emit(this.activeIndex)
  }

  onClickArrow(direction: string) {
    console.log(`Arrow ${direction} clicked`);
    // 这里可以添加点击箭头后的逻辑
  }


  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }



  ngOnDestroy() {
  }

}
