import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { NzMessageService } from 'ng-zorro-antd/message';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "JJ39_new";

  baseData;
  
  // 储存对象
  item;
  //临时储存对象
  tempItem;


  templateTypeArr = [
    {name:"选择题", value: "select"},
    {name:"拖拽题", value: "drag"},
    {name:"语音评测", value: "record"},
    // {name:"连线题", value: "line"},
    // {name:"翻翻卡", value: "flip"},
  ]

  isPreviewTemplate = false;




  customTypeGroupArr = [
    {
      name: '输入型文本',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "fontName", title:"字体"},
        {key: "fontSize", title:"大小"},
        {key: "fontColor", title:"颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '自动换行', value:'warp'}
        ]
      }
    },


    {
      name: '固定型文本',
      text: true,
      audio: true,
      isShowPos: true,
      labelArr: [
        {key: "fontName", title:"字体"},
        {key: "fontSize", title:"大小"},
        {key: "fontColor", title:"颜色"},
      ]
    },


    {
      name: '输入型图片',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputPic", key: "title", title:"标题"},
        {key: "key", title:"key", value:""},
      ]
    },


    {
      name: '固定型图片',
      pic: true,
      audio: true,
      anchorGroup: true,
      isShowPos: true,
    },


    {
      name: '输入型动画',
      rect: true,
      isShowPos: true,
      labelArr: [
        {key: "title", title:"标题"},
      ]
    },

   
    {
      name: '固定型动画',
      rect: true,
      anima: true,
      audio: true,
      isShowPos: true,
    }, 


    {
      name: '输入型音频',
      rect: true,
      isShowPos: true,
      labelArr: [
        {type:"inputAudio", key: "title", title:"标题"},
        {key: "key", title:"key", value:""},
      ]
    },


    {
      name: '固定型音频',
      rect: true,
      audio: true,
      pic: true,
      anim: true,
      isShowPos: true,
    },

     
    {
      name: '数据型文本',
      data: true,
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ]
    }, 


    {
      name: '数据型图片',
      // data: true,
      labelArr: [
        {type:"inputPic", key: "title",  title:"标题", value:""},
        {key: "key", title:"key", value:""},
      ]
    }, 

   
    {
      name: '翻页按钮组',
      rect: true,
      audio: true,
      // radio: {
      //   title: "按钮",
      //   list: [
      //     {label: '上一页', key: 'prev'},
      //     {label: '下一页', key: 'next'},
      //     {label: '翻页文本', key: 'text'},
      //   ]
      // },
      isShowPos: true,
    },


    {
      name: '录音按钮组',
      rect: true,
      audio: true,
      isShowPos: true,
    },


    {
      name: '文字选项组',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"inputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '适配矩形', key:'isScale'},
        ]
      },
      isOption: true,
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '图片选项组',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"inputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          {label: '适配矩形', key:'isScale'},
        ]
      },
      isOption: true,
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '音频型动画',
      rect: true,
      anima: true,
      labelArr: [
        {type:"inputAudio", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      isShowPos: true,
      isCopy: true,
    },
    

    {
      name: '选项效果组',
      picArr: [
        {title: '正确效果'},
        {title: '错误效果'},
      ],
      audioArr: [
        {title: '正确音效'},
        {title: '错误音效'},
      ],
      anchorGroup: true,
      isCopy: true,
    },


    {
      name: '数组排列区',
      rect: true,
      checkbox: {
        title: '',
        list: [
          {label: '横向排列', key:'hor'},
        ]
      },
      // select: {
      //   title: '类型',
      //   list:[
      //     {label: '拖拽开始区', value:'dragStart'},
      //     {label: '拖拽结束区', value:'dragEnd'},
      //   ]
      // },
      labelArr: [
        {key: "id",  title:"id"},
        {key: "distanceX",  title:"横向间距"},
        {key: "distanceY",  title:"纵向间距"},
      ],
      isShowPos: true,
      isShowSize: true,
      isCopy: true,
    },

    {
      name: '文字排列物',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"listInputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "id", title:"id"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],

      radio: {
        title: "文字位置",
        list: [
          {label: '开头', key: 'start'},
          {label: '中间', key: 'middle'},
          {label: '结尾', key: 'end'},
        ]
      },


      // checkbox: {
      //   title: '',
      //   list: [
      //     {label: '结束块', key:'isEndRect'},
      //   ]
      // },

      isShowPos: true,
      isCopy: true,
    },

    {
      name: '图片排列物',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"listInputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
        {key: "id", title:"id"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          // {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },

    {
      name: '拖拽文字组',
      rect: true,
      picArr: [
        {title: '默认图'},
        {title: '正确图'},
        {title: '错误图'},
      ],
      labelArr: [
        {type:"listInputText", key: "title",  title:"标题"},
        {key: "key", title:"key"},

        {key: "fontSize", title:"字体大小"},
        {key: "fontName1", title:"普通字体"},
        {key: "fontColor1", title:"普通颜色"},
        {key: "fontName2", title:"正确字体"},
        {key: "fontColor2", title:"正确颜色"},
        {key: "fontName3", title:"错误字体"},
        {key: "fontColor3", title:"错误颜色"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },


    {
      name: '拖拽图片组',
      rect: true,
      picArr: [
        {title: '输入参考图'},
        {title: '默认背景图'},
        {title: '正确背景图'},
        {title: '错误背景图'},
      ],
      labelArr: [
        {type:"listInputPic", key: "title",  title:"标题"},
        {key: "key", title:"key"},
      ],
      checkbox: {
        title: '',
        list: [
          {label: '遮罩', key:'isMask'},
          {label: '结束块', key:'isEndRect'},
        ]
      },
      isShowPos: true,
      isCopy: true,
    },
  ];
 



  curSelectItem;
  isShowKK=false;
  curSelectKK;
  KKArray = [
    "i",
    "ɪ",
    "u",
    "ʊ",
    "ɑ",
    "ʌ",
    "ɝ",
    "ə",
    "ɚ",
    "ɔ",
    "æ",
    "ɛ",
    "e",
    "aɪ",
    "ɔɪ",
    "o",


    "aʊ",
    "p",
    "b",
    "t",
    "d",
    "k",
    "g",
    "tʃ",
    "dʒ",
    "f",
    "v",
    "θ",
    "ð",
    "s",
    "z",
    "ʃ",
    "ʒ",
    "h",
    "m",
    "n",
    "ŋ",
    "l",
    "r",
    "w",
    "j",
  ]
  customTypeGroupArr2 = [
    {
      name: '星星区域',
      rect: true,
    },
    {
      name: '选择区域',
      rect: true,
    },
  ]

  stepArr = [
    {label: '视频时间', value: 'ques'},
  ];

  videoSizeArr = [
    {key: '1920_1080', value: '1920 x 1080'},
    {key: '1280_720', value: '1280 x 720'},
    {key: '940_600', value: '940 x 600'},
  ]

  audioTypeArr = [
    {key: 'begin', info: '第一遍开始音频'},
    {key: 'begin_2', info: '第二遍开始音频'},
    {key: 'finish', info: '第二遍结束音频'},
  ]


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef, 
    private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {


      if (data) {
        this.item = data;
      }

      this.initItem();


      console.log("this.item: ", JSON.stringify(this.item));
      
      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
      
    }, this.saveKey);
  }

  initItem() {
   
  }

  init() {

    if (!this.item.pageArr) {
      this.item.pageArr = [];
    }
    

    if (!this.item.mode) {
      this.item.mode = 'single';
    }
    
    this.test();

  }

  test() {

    this.splitTextIntoObjects('aaa [bbb] ccc eeefff aaa [ddd] [zzz].')
  }

  splitTextIntoObjects(text) {
    const regex = /[\[\]]/;

    // 使用split方法分割文本
    // 注意：split方法会移除分隔符，只保留分隔符之间的文本
    // 但由于我们想要知道哪里被分割了，所以实际上我们可能不需要直接这样做
    // 然而，如果你只是想要分割后的文本块（不包括'['和']'），下面这样就可以了
    const result = text.split(regex);

    const resultArr = [];
    result.forEach((it, i) => {
      const obj = {
        text : it,
        isUnderline: i % 2 == 1,
      }
      resultArr.push(obj);
    });
    return resultArr;
  }
  
  savePartText(part) {
    console.log('part: ' , part);
    part.textArr = this.splitTextIntoObjects(part.text);
    this.save();
  }



  templateTypeChange(e) {
    console.log("in templateTypeChange e: ", e);
    this.item.templateType = e;
    this.save();
  }






  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }


  itemSplitTypeChange(e, it) {
    it.splitType = e;
    this.save();
  }
  videoTypeChange(e) {
    console.log('e: ', e);
    this.item.videoType = e;
    this.save();
  }

  addBtnClick() {
    this.item.quesArr.push({
      itemType: 'jump'
    });
    this.save();
  }



  deleteBtnClick(i) {
    this.item.quesArr.splice(i, 1);
    this.save();
  }



  radioChange(e, item, key) {

    console.log('e: ', e);
    item[key] = e;

    this.save();
  }

  onVideoUploadSuccess(e, item, key) {
    console.log('e: ', e);
    item[key] = e.url;
    this.save();
  }

  videoSeeked(e) {

  }

  videoError(e) {

  }

  videoLoaded(e, it) {

  }


  saveHotZone(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    this.save();
  }

  saveHotZone2(group, e) {
    console.log('e2: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem2 = bgItem;
    group.hotZoneItemArr2 = hotZoneItemArr;

    this.save();
  }


  getLRC(evt) {
    this.item.lrcData = evt;
    this.save();

  }

  onVideoUploaded(res, key, item) {
    if (!item) {
      item = this.item;
    }
    console.log('onVideoUploaded: ', res);

    item[key] = res.url;
    this.save();
  }

  isTurnPageChange(e) {
    console.log("e: ", e);
  }
  

  onItemImgUploadSuccess(e, item, key='pic_url') {
    item[key] = e.url;
    // console.log('item: ', item);
    this.save();
  }

  onItemAudioUploadSuccess(e, item, key='audio_url') {
    item[key] = e.url;
    this.save();
    // console.log('item: ', item);
  }

  onDeletaImg(item, key) {
    delete item[key];
    this.save();
  }
  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item) {

    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, it) {
    it[key] = e.url;
    this.save();
  }

  KKBtnClick(it) {
    this.curSelectItem = it;
    this.isShowKK = true
  }

  KKHandleCancel() {
    this.isShowKK = false;
    this.curSelectKK = null;
    this.curSelectItem = null;
  }

  KKHandleOk() {

    // if (!this.curSelectItem.KKText) {
    //   this.curSelectItem.KKText = '';
    // }
    this.curSelectItem.KKText = this.curSelectKK;
   
    this.KKHandleCancel();

    this.save();
  }
 
  saveItemText(it, key) {
    console.log('it: ', it);
    this.save();
  }

  getItemHasInputPic(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputPic';
  }

  getItemHasInputAudio(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputAudio';
  }

  getItemHasInputText(it) {
    return it.labelArr && it.labelArr[0]?.type == 'inputText';
  }

  getItemHasTargetType(it, targetType) {
    return it.labelArr && it.labelArr[0]?.type == targetType;
  }

  addListItem(it, key) {

    if (!it[key]) {
      it[key] = [];
    }
    it[key].push({});
  }

  deleteListItem(arr, i) {
    arr.splice(i, 1);
    // this.save();
  }
 

  showPreviewTemplate() {
    this.isPreviewTemplate = true;

      //正常模板显示 赋值数据
      if (this.baseData && this.item.tempItem) {

        this.tempItem = this.item.tempItem;
      } else {
        
        this.tempItem = {}
        this.tempItem.quesArr = [];
        // this.addOnePageBtnClick();
      }

  }

  hidePreviewTemplate() {
    this.isPreviewTemplate = false;
  }

  addOnePartBtnClick(page) {
    if (!page.partArr) {
      page.partArr = [];
    }
    page.partArr.push( 
      {
        type: "text"
      }
    );
    
    this.save();
  }

  addOnePageBtnClick() {
 
    this.item.pageArr.push( 
      {
        quesArr: []
      }
    );
    
    this.save();
  }

  addOneQuesBtnClick(page) {
 
    page.quesArr.push( 
      {
     
      }
    );
    
    this.save();
  }

  addOneOption(ques) {
    if (!ques.optionArr) {
      ques.optionArr = [];
    }
    ques.optionArr.push({
    });
    this.save();
  }

  deleteQuesBtnClick(arr, i) {
    arr.splice(i, 1);
    this.save();
  }

  deletePartBtnClick(i, it=null) {
    if (!it) {
      it = this.item;
    }
    it.partArr.splice(i, 1);

    this.syncDataPage1();
    this.save();
  }

  syncDataPage1() {
    
    if (this.item.mode != 'single') {
      return;
    }

    const pageDataOne = this.item.pageArr[0];

    for (let i=1; i<this.item.pageArr.length; i++) {
      const curPageData = this.item.pageArr[i];
      if (curPageData) {
        curPageData.partArr = JSON.parse(JSON.stringify(pageDataOne.partArr));
        curPageData.audio_url = this.item.pageArr[0].audio_url;
      }
    }
  }

  deletePageBtnClick(i) {
    this.item.quesArr.splice(i, 1);
    this.save();
  }

  checkboxChange(e, it, key) {
    console.log('e: ', e);

    it[key] = e;
    this.save();
  }

  

  deleteArr(arr, i) {
    arr.splice(i, 1);
    this.save();
  }

  /**
   * 储存数据
   */
  save() {

    // if (this.tempItem) {
    //   this.item.tempItem = this.tempItem;
    // }

    // if (this.customTypeGroupArr) {
    //   this.item.customTypeGroupArr = this.customTypeGroupArr;
    // }

    this.syncDataPage1();   

    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));

    this.message.create('success', "保存成功");

  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}