import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  ApplicationRef,
  ChangeDetectorRef,
  AfterViewInit
} from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy, AfterViewInit {

  // 储存数据用
  saveKey = "JM_MATH01";
  // 储存对象
  item;
  // 公式键盘
  fboard = null;
  customTypeGroupArr = [

    {
      name: '轮播图片',
      audio: true,
      pic: true,
      // rect: true,
      // isShowPos: true,
      // isCopy: true,

      // label: '比对',
    },
    {
      name: '选择题区域',
      rect: true,
    },
    {
      name: '简答问题',
      pic: true,
    },
    {
      name: '简答填空区',
      rect: true,
      mathLabel: '答案',
    },
    {
      name: '讲解按钮',
      rect: true,
    },
    {
      name: '填过程按钮',
      rect: true,
    },
    {
      name: '过程展示区域',
      rect: true,
    },
  ];
   testValue = '123';


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {
    // @ts-ignore
    window.fff = this;
  }

  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      console.log('this.item: ', this.item);

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }
  ngAfterViewInit() {



  }
  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

    if (!this.item.sentenceArr) {
      this.item.sentenceArr = [];
    }
    if (!this.item.templateArr) {
     this.item.templateArr = [];
    }

    if (!this.item.optionArr) {
      this.item.optionArr = [
        {id: 'A', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'B', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'C', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'D', optionArr: [{id: 'A'}, {id: 'B'}]},
      ];
    }


    if (!this.item.answer_obj) {
      this.item.answer_obj = {};
    }

    if (!this.item.choice_obj) {
      this.item.choice_obj = {};

      this.item.choice_obj.optionArr = [
        {id: 'A', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'B', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'C', optionArr: [{id: 'A'}, {id: 'B'}]},
        {id: 'D', optionArr: [{id: 'A'}, {id: 'B'}]},
      ];
    }

  


    if (!this.item.ques_type) {
      this.item.ques_type = 'single_choice'
    }


  }

  addSubTemplate() {
    this.item.templateArr.push({
    })

    this.save();
  }

  onDeleteTemplate(e, index) {
    this.item.templateArr[index] = {};
    this.item.templateArr.splice(index, 1);
    this.save();
  }

  onSaveTemplate(e, index) {

    this.item.templateArr[index] = e;
    this.save();
  }



  addBtnClick() {
    this.item.sentenceArr.push({});
    this.save();
  }

  deleteBtnClick(index) {
    this.item.sentenceArr.splice(index, 1);
    this.save();

  }

  onSaveCustomAction(e) {
    console.log('e:', e);
    this.item.customAction = e;
    this.save();
  }


  saveHotZone(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    this.save();
  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item=null) {
    if (!item) {
      item = this.item;
    }

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, item=null) {
    if (item == null) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }

  onVideoUploadSuccess(e, item=null) {

    console.log(' in onVideoUploadSuccess')
    if (!item) {
      item = this.item;
    }
    item.video_url = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}
