// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class BoardCardItem extends cc.Component {
    _cardId: number;
    _rjumpId: number;
    _wjumpId: number;
    _cardUrl: string;
    _word: string;
    letter: string = '';

    set cardData(data: { id: number, rJumpId: number, wJumpId?: number, url: string, word: string }) {

        this._cardId = data.id;
        this._rjumpId = data.rJumpId;
        this._wjumpId = data.wJumpId;
        this._cardUrl = data.url;
        this._word = data.word;

    }
    get Id() {
        return this._cardId;
    }
    get rjumpId() {
        return this._rjumpId;
    }
    get wjumpId() {
        return this._wjumpId;
    }
    get word() {
        return this._word;
    }
}
