import BoardCardItem from "../scene/boardCardItem";
import { NetworkHelper } from "./NetworkHelper";
import { asyncDelay } from "./util";

export class AI {
  networkHelper: NetworkHelper;
  playerData: any;
  _status = {
    state: -1,// -1:未开始 0 准备阶段  1 roll 2 判定
    Red: -1,
    Blue: 0,
    step: 0,
    current: "Blue",
    jump: null,
  };

  constructor(networkHelper: NetworkHelper, playerData: any) {
    this.networkHelper = networkHelper;
    this.playerData = playerData;
  }

  async onFrameEvent(data) {
    console.log("AI get event: " + JSON.stringify(data));

    if (data.type == "SERVER_updateStatus") {

      this._status = JSON.parse(JSON.stringify(data.status));

      if (this.playerData.color != this._status.current) return

      if (!this._status.step) {
        await asyncDelay(Math.random() * 3 + 2);

        console.log("AI rolling");
        this.networkHelper.sendFrame({
          type: "roll",
          uuid: this.playerData.uuid,
        });
      } else {
        await asyncDelay(Math.random() * 3 + 2);
        if (Math.random() < 0.7) {
          this.networkHelper.sendFrame({
            type: "right",
            uuid: this.playerData.uuid,
          });
        } else {
          this.networkHelper.sendFrame({
            type: "wrong",
            uuid: this.playerData.uuid,
          });
        }
      }
    }
  }

}
