import { MsgType, PlayerData } from "./msgType_L5R1_bingo";

export default class MsgData {

    _playerList: Array<PlayerData>;
    _redScore: number = 0;
    _buleSocre: number = 0;
    _time: number = 0;
    _round: number = 0;
    _answerList: Array<any> = [];
    _leftList: Array<any> = [];

    constructor(data?: {
        playerList,
        redScore,
        buleSocre,
        time,
        round,
        answerList,
        leftList,
    }) {
        this._playerList = data?.playerList || [];
        this._redScore = data?.redScore || 0;
        this._buleSocre = data?.buleSocre || 0;
        this._time = data?.time || 0;
        this._round = data?.round || 0;
        this._answerList = data?.answerList || [];
        this._leftList = data?.leftList || [];
    }

    get PlayerList() {
        return this._playerList;
    }

    addPlayer(val: PlayerData) {
        this._playerList.push(val);
    }



    get Time() {
        return this._time;
    }
    set Time(val: number) {
        this._time = val;
    }

    get Round() {
        return this._round;
    }
    set Round(val: number) {
        this._round = val;
    }


    get RedScore() {
        return this._redScore;
    }
    set RedScore(val: number) {
        this._redScore = val;
    }

    get BuleSocre() {
        return this._buleSocre;
    }
    set BuleSocre(val: number) {
        this._buleSocre = val;
    }

    get LeftList() {
        return this._leftList;
    }
    set LeftList(val) {
        this._leftList = val;
    }

    getAnswerList() {
        return this._answerList;
    }
    addAnswerList(val: { word?: string, uuid: string, index?: number }) {
        this._answerList.push(val);
    }
    clearAnswerList() {
        this._answerList = [];
    }

    get Msg() {
        let data =
        {
            playerList: this._playerList,
            redScore: this._redScore,
            buleSocre: this._buleSocre,
            time: this._time,
            round: this._round,
            answerList: this._answerList,
            leftList: this._leftList
        }
        return JSON.stringify(data);
    }

}