// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import { asyncDelay } from "../../script/util_L5R1_bingo";

const { ccclass, property } = cc._decorator;

@ccclass
export default class EndView extends cc.Component {

    @property(cc.Node)
    frame: cc.Node = null;

    @property(cc.Node)
    winRoot: cc.Node = null;

    @property(cc.Node)
    loseRoot: cc.Node = null;

    @property(cc.Node)
    redIcon: cc.Node = null;

    @property(cc.Node)
    blueIcon: cc.Node = null;

    @property(cc.Label)
    lb_red: cc.Label = null;

    @property(cc.Label)
    lb_blue: cc.Label = null;

    @property(cc.Node)
    replayNode: cc.Node = null;

    onLoad() {
        this.node.opacity = 0;
        this.replayNode.on("click", this.replay, this)

    }

    async showView(win: boolean, redScore, blueScore, redUrl, blueUrl) {

        this.node.opacity = 255;

        this.frame.scale = 0;

        cc.tween(this.frame).to(1, { scale: 1 }, { easing: "sineIn" }).start();
        this.winRoot.active = win;
        this.loseRoot.active = !win;
        this.lb_blue.string = blueScore;
        this.lb_red.string = redScore;

        cc.loader.load({ url: redUrl }, (err, img) => {
            this.redIcon.getComponent(cc.Sprite).spriteFrame = new cc.SpriteFrame(img)
        })
        cc.loader.load({ url: blueUrl }, (err, img) => {
            this.blueIcon.getComponent(cc.Sprite).spriteFrame = new cc.SpriteFrame(img)
        })

        if (win) {
            this.winRoot.getChildByName("ani").active = true;
            await asyncDelay(1)
            this.winRoot.getChildByName("audio").active = true;
        } else {
            this.loseRoot.getChildByName("ani").active = true;
            await asyncDelay(1)
            this.loseRoot.getChildByName("audio").active = true;
        }

    }

    replay() {
        cc.director.loadScene("L5R1_bingo");
    }

}
