import BoardCardItem from "../scene/boardCardItem";
import MsgData from "./msgDate";
import { MsgType } from "./msgType";
import { NetworkHelper } from "./NetworkHelper";
import { asyncDelay } from "./util";

const countDelay = 4; // 距离上次答对 间隔4s 开始答题下一题
export class AI {
  networkHelper: NetworkHelper;
  playerData: any;

  _startAi: boolean = false;
  _answerpro = 0;
  private _gameData: MsgData;
  private _countDelay: number;
  private _stepIndex: any;
  constructor(networkHelper: NetworkHelper, playerData: any) {
    this.networkHelper = networkHelper;
    this.playerData = playerData;
  }

  async onFrameEvent(data) {
    // console.log("AI get event: " + data);

    let type: MsgType = data.type;
    let msgData = data.data;

    if (type == MsgType.ROOM_ST) {

      this._gameData = new MsgData(JSON.parse(msgData));

      if (!this._startAi) return;

      if (this._gameData.Round == 1 && this._gameData.BuleSocre < 14) {
        cc.log("ai check")
        this._countDelay--;
        if (this._countDelay <= 0) {
          let wordList = this._gameData.LeftList;
          let word = wordList[Math.floor(Math.random() * wordList.length * 0.99)]
          cc.log("ai answer word" + word)
          this._sendMsg({ type: MsgType.USER_REQ_ERQ, data: { word: word, uuid: this.playerData.uuid } })
          this._countDelay = Math.floor(10 + Math.random() * 10);;

        }
      } else if (this._gameData.Round == 2) {

        this._countDelay--;
        if (this._countDelay <= 0) {
          this._sendMsg({ type: MsgType.USER_REQ_ERQ, data: { index: this._stepIndex, uuid: this.playerData.uuid } })
          this._countDelay = 10000
        }
      }
    }
    else if (type == MsgType.ROUND_START_EV) {
      let data = msgData;
      if (data.round == 1) {
        this._startAi = true;
        this._countDelay = Math.floor(10 + Math.random() * 10);
      } else {
        this._startAi = true;
        this._stepIndex = data.index;
        this._countDelay = Math.floor(6 + Math.random() * 7);
      }
    } else if (type == MsgType.ROUND_END_EV) {
      let data = msgData;
      if (data.round == 1) {
        this._countDelay = 500000000;
      } else {
        this._countDelay = 500000000;
      }
    }
  }

  _sendMsg(data: { type: MsgType, data: any }) {
    this.networkHelper.sendFrame({
      type: data.type,
      data: data.data
    });
  }

}
