// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class Keyboard extends cc.Component {

    @property(cc.Label)
    lb_input: cc.Label = null;

    @property(cc.Node)
    btnRoot: cc.Node = null;

    @property(cc.Node)
    btnOkNode: cc.Node = null;

    @property(cc.Node)
    btnbackNode: cc.Node = null;

    @property(cc.Node)
    btnShowNode: cc.Node = null;

    @property(cc.Node)
    btnHideNode: cc.Node = null;


    _wordList = [];
    private _normaly: number;
    private _moving: boolean;
    private _endCall: any;

    onLoad() {

        this._wordList = [];
        this.lb_input.string = "";
        let btnList = this.btnRoot.children;

        for (let i = 0; i < btnList.length; ++i) {
            let btnNode = btnList[i];
            let key = btnNode.name;
            btnNode.getChildByName("btn").on("click", this.enterWord.bind(this, key), this);
        }

        this.btnOkNode.on("click", this.sendWords, this)
        this.btnbackNode.on("click", this.backWord, this)

        this.btnShowNode.on("click", this.showIn, this)
        this.btnHideNode.on("click", this.showOut.bind(this, false), this)

        this.btnShowNode.active = false;
        this.btnHideNode.active = false;
    }

    setNormalData(posy: number) {
        this._normaly = posy;
        this.node.y = posy;
    }
    enterWord(word: string) {

        this._wordList.push(word);
        this._updateInputs();

    }
    backWord() {
        this._wordList.pop();
        this._updateInputs();
    }
    _updateInputs() {
        this.lb_input.string = this._wordList.join("");
    }
    sendWords() {

        console.log(this._wordList.join(""));
        this._endCall && this._endCall(this._wordList.join(""));
        this.showOut();
        this.btnShowNode.active = true;
        this.btnHideNode.active = false;

    }
    set InputEndCall(endCall: Function) {
        this._endCall = endCall;
    }
    showIn() {

        if (this._moving) return;
        this._moving = true;
        cc.tween(this.node).to(0.3, { y: this._normaly + this.node.height }, { easing: "sineIn" }).call(() => {
            this._moving = false;
            this.btnShowNode.active = false;
            this.btnHideNode.active = true;
        }).start();

    }
    showOut(hideMini = false) {
        if (this._moving) return;
        this._moving = true;
        this._wordList = [];
        this._updateInputs();
        cc.tween(this.node).to(0.3, { y: this._normaly }, { easing: "sineOut" }).call(() => {
            this._moving = false;
        }).start();
        if (hideMini) {
            this.btnShowNode.active = false;
            this.btnHideNode.active = false;
        } else {
            this.btnShowNode.active = true;
            this.btnHideNode.active = false;
        }
    }
}
