cc.Class({
  extends: cc.Component,

  properties: {
  },

  start() {
    const BtnExit = cc.find('BtnFrame/BtnExit', this.node);
    this.buttonOnClick(BtnExit, () => {
      const middleLayer = cc.find('middleLayer');
      if (middleLayer) {
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        if (middleLayerComponent.onClickExitBtn) {
          middleLayerComponent.onClickExitBtn();
        }
      } else {
        cc.director.getScene().destroy();
        cc.audioEngine.stopAll();
        if (window.courseware) {
          window.courseware.freeAllOcMethod();
        }
        var bundle = cc.assetManager.bundles.find((obj) => {
          return obj.getSceneInfo('debug_shell');
        });
        if (bundle) {
          cc.director.loadScene("debug_shell", null, null, (err, scene) => { });
        } else {
          cc.director.loadScene("OXFORDCORE", null, null, (err, scene) => { });
        }
      }
    });
    const BtnPlayAgain = cc.find('BtnFrame/BtnPlayAgain', this.node);
    this.buttonOnClick(BtnPlayAgain, () => {
      const middleLayer = cc.find('middleLayer');
      if (middleLayer) {
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        if (middleLayerComponent) {
          middleLayerComponent.reloadBundle();
        }
      } else {
        const sceneName = cc.director.getScene().name;
        cc.director.getScene().destroy();
        cc.audioEngine.stopAll();
        if (window.courseware) {
          window.courseware.freeAllOcMethod();
        }
        cc.director.loadScene(sceneName, null, null, (err, scene) => { });
      }
    });
  },

  buttonOnClick(button, callback, scale = 1.0) {
    button.on('click', () => {
      if (button['cantClick']) {
        return;
      }
      button['cantClick'] = true;
      cc.tween(button)
        .to(0.1, { scale: scale * 1.1 })
        .to(0.1, { scale: scale })
        .call(() => {
          button['cantClick'] = false;
          callback && callback();
        })
        .start();
    });
  }
});
