
import EndView from "../prefabs/endView/EndView";
import Keyboard from "../prefabs/keyboards/Keyboard";
import LoadingLayer from "../script/BoardGame_yyh_LoadingLayer";
import MsgData from "../script/msgDate";
import { MsgType, PlayerData, resultType } from "../script/msgType";
import { MyCocosSceneComponent } from "../script/MyCocosSceneComponent";
import { NetworkHelper } from "../script/NetworkHelper";
import { GameServer } from "../script/Server";
import { asyncTweenTo, asyncDelay, onHomeworkFinish, asyncPlayDragonBoneAnimation } from "../script/util";
import BoardCardItem from "./boardCardItem";

const DOLOG = false;

const { ccclass, property } = cc._decorator;

@ccclass
export default class SceneComponent extends MyCocosSceneComponent {
    @property(cc.Prefab)
    loadingLayerPrefab = null;
    @property(cc.Prefab)
    keyboardLayerPrefab = null
    @property(cc.Prefab)
    endViewPrefab = null
    @property(cc.Node)
    cat = null
    @property(cc.Node)
    bfly: cc.Node = null
    @property(cc.Node)
    cover = null
    @property(cc.Node)
    recordCat = null
    @property(cc.Node)
    btn_keyboard: cc.Node = null

    _cardList: Array<cc.Node> = [];

    private _isRolling: any;

    _gameWordList = [];
    excellent: any;
    _nowData: any;
    private _loadingDone: boolean = false;
    private _loadingCall: Function
    private _recordBefore: boolean = false;
    private _coinNode: cc.Node;
    private _springNode: cc.Node;
    private _leftTime: number;
    private _redLb: cc.Label;
    private _blueLb: cc.Label;
    private _keyboard: Keyboard;
    private _blueHeadIcon: cc.Node;
    private _redHeadIcon: cc.Node;
    private _clockNode: any;
    private _clockTime: any;
    private _wordCardRoot: cc.Node;
    private _redLightList: any;
    private _blueLightList: any;
    private _round2WordList: Array<{ word: string, uuid: string }>;
    private _stepWord: string;
    private _birdsRoot: cc.Node;
    private _redUrl: any;
    private _blueUrl: any;
    lb_round2: cc.Node;
    private _localAudioRoot: cc.Node;
    private _round: number;
    private _catSpeaking: boolean;
    private _audioNode: cc.Node;


    onLoad() {
        super.onLoad();

        this._localAudioRoot = this.node.getChildByName("audio")
        this.addLoadingLayer();
    }
    addLoadingLayer() {
        const loadingLayerNode = cc.instantiate(this.loadingLayerPrefab);
        loadingLayerNode.parent = this.node;
        loadingLayerNode.zIndex = 100;
        this.loadingLayer = loadingLayerNode.getComponent(LoadingLayer);
    }
    addKeyboard() {

        const keyboard = cc.instantiate(this.keyboardLayerPrefab);
        keyboard.parent = this.node;
        keyboard.zIndex = 100;
        this._keyboard = keyboard.getComponent(Keyboard);
        this._keyboard.setNormalData(-cc.winSize.height / 2)
        this._keyboard.InputEndCall = this._inputWords.bind(this);
    }

    _inputWords(word) {
        this._sendMsg(MsgType.USER_REQ_ERQ, { word: word, uuid: this.playerId })
    }
    addPreloadImage() {
        // TODO 根据自己的配置预加载图片资源
        // this._imageResList.push({ url: this.data.pic_url });
    }

    addPreloadAudio() {
        // TODO 根据自己的配置预加载音频资源
        //     猫咪读条音频（匹配界面开始匹配前）: audioUrl_loading
        // 猫咪开始音频（刚进入游戏）: audioUrl_start
        // 猫咪第一轮答题待机音频（第一轮游戏过程中点击猫咪）: audioUrl_waiting_firstRound
        // 填词被抢先语音（填写完单词发现别人填写过）: audioUrl_filled
        // 第一次弹出键盘音频: audioUrl_keyboard_pop
        // 第一轮因时间到而结束语音（第一轮结束时）: audioUrl_timeout_firstround
        // 第一轮因填写完成而结束语音（第一轮结束时）: audioUrl_finish_firstRound
        // 猫咪第二轮答题开始音频（第二轮游戏开始后): audioUrl_waiting_secondRound
        // 猫咪胜利结束音频（两轮游戏都结束）: audioUrl_win
        // 猫咪失败结束音频（两轮游戏都结束）: audioUrl_lose

        this._audioResList.push({ url: this.data.audioUrl_loading });
        this._audioResList.push({ url: this.data.audioUrl_start });
        this._audioResList.push({ url: this.data.audioUrl_waiting_firstRound });
        this._audioResList.push({ url: this.data.audioUrl_waiting_secondRound });
        this._audioResList.push({ url: this.data.audioUrl_filled });
        this._audioResList.push({ url: this.data.audioUrl_keyboard_pop });
        this._audioResList.push({ url: this.data.audioUrl_timeout_firstround });
        this._audioResList.push({ url: this.data.audioUrl_finish_firstRound });
        this._audioResList.push({ url: this.data.audioUrl_win });
        this._audioResList.push({ url: this.data.audioUrl_lose });

    }

    addPreloadAnima() { }

    onLoadEnd() {
        // TODO 加载完成后的逻辑写在这里, 下面的代码仅供参考
        this.log("onLoadEnd");
        this.initView();
        this.initNetSever();

    }
    loadingLayer: LoadingLayer;
    initLoadingLayer() {
        this.loadingLayer.setMaxPlayerNumber(2);
        this.loadingLayer.onLoadFinished(() => {
            // this.playAudioByUrl(this.data.audioUrl_start);
            this._loadingDone = true;
            if (this._loadingCall) {
                this._loadingCall();
                this._loadingCall = null;
            }
        });

        this.playAudioByUrl(this.data.audioUrl_loading);
    }
    initView() {
        this.initProtory();
        this.addKeyboard();
        this.initLoadingLayer();
    }

    initProtory() {
        const bgNode = cc.find('Canvas/bg');
        bgNode.scale = this._mapScaleMax;

        this.cover.width = cc.winSize.width;
        this.cover.height = cc.winSize.height;
        this.cover.getChildByName("bg").scale = this._mapScaleMax;

        let topRoot = cc.find("Canvas/topRoot");

        this._redLightList = topRoot.getChildByName("lights").getChildByName("red");
        this._blueLightList = topRoot.getChildByName("lights").getChildByName("blue");
        this._blueHeadIcon = topRoot.getChildByName("blue").getChildByName("headIcon");
        this._redHeadIcon = topRoot.getChildByName("red").getChildByName("headIcon");
        this._redLb = topRoot.getChildByName("lb_red").getComponent(cc.Label)
        this._blueLb = topRoot.getChildByName("lb_blue").getComponent(cc.Label)

        this._clockNode = this.cat.parent.getChildByName("clock");
        this._clockTime = this._clockNode.getChildByName("lb").getComponent(cc.Label);
        this._wordCardRoot = cc.find("Canvas/center/wordBgRoot");
        this._birdsRoot = cc.find("Canvas/center/birdsRoot");
        this.lb_round2 = cc.find("Canvas/lb_round2");

        this.cat.getChildByName("btn").on("click", () => {
            if (this._catSpeaking) {
                return;
            }
            this._catSpeaking = true;
            this.catAni();
        })
    }

    loadPlayerHeadImage() {
        this._playerList.forEach((player) => {
            this.getSpriteFrimeByUrl(player.headUrl, (sf) => {
                if (player.side == "Red") {
                    this._redHeadIcon.getComponent(cc.Sprite).spriteFrame = sf;
                    this._redUrl = player.headUrl
                } else {
                    this._blueHeadIcon.getComponent(cc.Sprite).spriteFrame = sf;
                    this._blueUrl = player.headUrl
                }
            });
        });
    }

    catAni() {

        if (this._round == 1) {
            asyncPlayDragonBoneAnimation(this.cat, "begin", 0);
            this.playAudioByUrl(this.data.audioUrl_waiting_firstRound, () => {
                asyncPlayDragonBoneAnimation(this.cat, "normal", 0);
                this._catSpeaking = false;
            })

        } else if (this._round == 2) {
            asyncPlayDragonBoneAnimation(this.cat, "begin", 0);
            this.playAudioByUrl(this.data.audioUrl_waiting_secondRound, () => {
                asyncPlayDragonBoneAnimation(this.cat, "normal", 0);
                this._catSpeaking = false;
            })
        }
    }
    playerId;
    isRoomOwner;
    server: GameServer;
    networkHelper: NetworkHelper;
    async initNetSever() {

        this._initGameData()

        this.networkHelper = new NetworkHelper();
        this.initNetworkListener();
        do {
            this.playerId = await this.networkHelper.init("op_L5_R1_bingo", 2);
            if (this.playerId === null) {
                this.log("onDestroy");
                this.networkHelper.onDestroy();
            }
            this.log("this.playerId = " + this.playerId);
        } while (this.playerId === null);

        const room = this.networkHelper.room;
        if (this.playerId == room.roomInfo.owner) {
            this.log("房主");
            this.isRoomOwner = true;
            this.server = new GameServer(2, this.networkHelper);

            this.server.wordList = this._gameWordList;

            await this.networkHelper.startFrameSync();

            this.server.startMatch();
        }
        await this.initHeadImgAndName();
    }

    async initHeadImgAndName() {
        const playerInfo: any = {
            playerHeadUrl: "http://staging-teach.cdn.ireadabc.com/0751c28419a0e8ffb1f0e84435b081ce.png",
            playerName: "test",
        };
        const middleLayer = cc.find("middleLayer");
        if (middleLayer) {
            const middleLayerComponent = middleLayer.getComponent("middleLayer");
            middleLayerComponent.log("这里 打log?");
            if (middleLayerComponent.getUserInfo && middleLayerComponent.getHeadUrl) {
                const kidInfo = await middleLayerComponent.getUserInfo();
                const playerHeadUrl = middleLayerComponent.getHeadUrl(kidInfo.avatar_url || kidInfo.id);
                playerInfo.playerHeadUrl = playerHeadUrl;
                playerInfo.playerName = kidInfo.nick_name || '拼读达人';
            }
        }

        let playData: PlayerData = {
            playerId: this.playerId,
            uuid: this.playerId,
            name: playerInfo.playerName,
            headUrl: playerInfo.playerHeadUrl,
            side: "",
            isAI: false,
        };
        this._sendMsg(MsgType.USER_JOIN_ERQ, playData);
    }

    _initGameData() {
        let cardRoot = cc.find("Canvas/center/cardRoot");
        let cards = cardRoot.children;
        for (let i = 0; i < cards.length; ++i) {
            let card = cards[i];
            this._gameWordList.push(card.name)
        }

    }
    _sendMsg(type: MsgType, data: any) {
        this.networkHelper.sendFrame({
            type: type,
            data: data
        });
    }
    _isSeverMsgType(type) {
        return type == MsgType.USER_JOIN_ERQ ||
            type == MsgType.USER_REQ_ERQ ||
            type == MsgType.USER_PREPARE_REQ;
    }
    _playerList;
    initNetworkListener() {
        this.networkHelper.on("playerJoin", (event) => {
            // if (this.server) {

            //     this.server.onPlayerJoin({ data: { joinPlayerId: event.playerId } });
            // }
            this.log("playerJoin" + JSON.stringify(event, null, 2));
        });
        this.networkHelper.on("playerLeave", (event) => {
            cc.log("playerLeave" + JSON.stringify(event));
            cc.find("Canvas/PlayerOffLineLayer").active = true;
            this.networkHelper.leaveRoom();
        });
        this.networkHelper.on("playerOffLine", (event) => {
            cc.find("Canvas/PlayerOffLineLayer").active = true;
            this.networkHelper.leaveRoom();
            this.log("playerOffLine" + JSON.stringify(event));
        });
        this.networkHelper.on("gameStart", (event) => { });
        this.networkHelper.on("frameEvent", (event) => {
            event.data.frame.items.forEach(async (item) => {
                let type: MsgType = item.data.type;
                let msgData: MsgData = item.data.data;
                console.log("msg type: " + MsgType[item.data.type]);
                DOLOG && console.log("msg data :\n" + item.data.data);
                DOLOG && this.log("msg type: " + item.data.type);
                DOLOG && this.log("msg data :\n" + item.data.data)
                // 服务器只处理用户消息， 用户只处理广播消息
                if (this.server && this._isSeverMsgType(item.data.type)) {
                    this.server.onFrameEvent(item.data);
                } else {
                    let msg = typeof msgData == "string" ? JSON.parse(msgData) : msgData
                    this._onSeverMsg(type, msg);
                }

            });
        });
    }

    _onSeverMsg(type: MsgType, data: any) {

        if (type == MsgType.USER_JOIN_EV) {
            this._updateUserJoin(new MsgData(data));
        } else if (type == MsgType.ROOM_INIT_DONE) {

            this._doStartGameAni(new MsgData(data));

        } else if (type == MsgType.ROOM_ST) {

            this._updateRootSt(new MsgData(data));
        }
        else if (type == MsgType.ROUND_START_EV) {
            if (data.round == 1) {
                this._round = 1
            } else {
                this._round = 2
                let index = data.index;
                this._stepWord = this._round2WordList[index].word;
                cc.audioEngine.stopAllEffects();
                this.playLocalAudio(this._stepWord);
                this.unschedule(this._cyclePlayAudio)

                this.schedule(this._cyclePlayAudio, 2.5, 3, 2.2)

                // this.lb_round2.getComponent(cc.Label).string = "当前发音单词：" + this._stepWord
                console.log("========setp word ===========" + this._stepWord);

            }
        }
        else if (type == MsgType.USER_REQ_EV) {
            this._checkUserAnswer(data)
        } else if (type == MsgType.ROUND_END_EV) {
            this._round = -1
            this._roundEndCheck(data);
        }
    }

    _cyclePlayAudio() {
        this.playLocalAudio(this._stepWord);
    }

    _updateUserJoin(data: MsgData) {
        data.PlayerList.forEach((player) => {
            if (!this._playerList) {
                this._playerList = [];
            }

            if (
                !this._playerList.find(
                    (listPlayer) => listPlayer.uuid == player.uuid
                )
            ) {
                this._playerList.push({
                    uuid: player.uuid,
                    name: player.name,
                    side: player.side,
                    headUrl: player.headUrl,
                });
            }

            this.loadPlayerHeadImage();

            this.loadingLayer.addPlayer(
                player.name,
                player.uuid == this.playerId,
                player.headUrl,
                player.uuid
            );
        });
    }

    _cardsAni() {

        let cardRoot = cc.find("Canvas/center/cardRoot");
        let cards = cardRoot.children;
        for (let i = 0; i < cards.length; ++i) {
            cc.tween(cards[i]).delay(0.25 * i).by(0.3, { scale: 1.05 }).to(0.1, { scale: 1 }).start();

        }

    }
    _doStartGameAni(data: MsgData) {

        this.log("_doStartGameAni")
        this._updateClock(data.Time);


        let aniCall = () => {
            let wp1 = this.bfly.convertToWorldSpaceAR(cc.Vec2.ZERO);
            let wp2 = this.btn_keyboard.convertToWorldSpaceAR(cc.Vec2.ZERO)
            let offsetX = wp2.x - wp1.x;
            console.log("offset  x =" + offsetX)
            cc.tween(this.bfly).by(1, { x: offsetX }).call(() => {
                this.bfly.getComponent(dragonBones.ArmatureDisplay).playAnimation("begin", 1);
            }).delay(1.5).call(() => {
                this.playLocalAudio("flyd")
            }).delay(1.5).call(() => {

                this._sendMsg(MsgType.USER_PREPARE_REQ, {});
                this.playAudioByUrl(this.data.audioUrl_keyboard_pop)
                this._keyboard.showIn();
            }).by(1, { x: -offsetX }).start();
        }

        let doneLoadCall = async () => {
            this._cardsAni();
            asyncPlayDragonBoneAnimation(this.cat, "begin", 0)
            this._catSpeaking = true;
            this.playAudioByUrl(this.data.audioUrl_start, () => {
                aniCall();
                this._catSpeaking = false;
                asyncPlayDragonBoneAnimation(this.cat, "normal", 0)
            })

        }

        if (this._loadingDone) {
            doneLoadCall();
        } else {
            this._loadingCall = doneLoadCall;
        }
    }
    _updateRootSt(data: MsgData) {
        DOLOG && console.log(data);
        if (data.Round == 1) {

            this._updateCards(data.getAnswerList())

        } else {
            this._updateRound2Cards(data.getAnswerList())
        }
        this._updateClock(data.Time);
        this._updateProgrss(data.RedScore, data.BuleSocre, data.Round)
    }
    async _roundEndCheck(data) {

        if (data.round == 1) {
            this._round2WordList = data.answerList
            console.log("====_round2WordList====");
            console.log(this._round2WordList);
            // reason 1 全部完成， 2 时间到了
            this._keyboard.showOut(true);
            this._clockTime.string = "0";

            console.log("_roundEndCheck");
            console.log(data);
            if (data.reason == 1) {
                cc.audioEngine.stopAllEffects();
                this._catSpeaking = false;
                asyncPlayDragonBoneAnimation(this.cat, "begin", 0)
                this._catSpeaking = true;
                this.playAudioByUrl(this.data.audioUrl_finish_firstRound, () => {
                    this._reInitCards();
                    this.playAudioByUrl(this.data.audioUrl_waiting_secondRound, () => {
                        asyncPlayDragonBoneAnimation(this.cat, "normal", 0)
                        this._catSpeaking = false;
                        aniCall();
                    })
                })

            } else {
                cc.audioEngine.stopAllEffects();
                this._catSpeaking = false;
                asyncPlayDragonBoneAnimation(this.cat, "begin", 0)
                this._catSpeaking = true;
                this.playAudioByUrl(this.data.audioUrl_timeout_firstround, async () => {
                    await this._updateCards(data.answerList, true)
                    this._reInitCards();
                    this.playAudioByUrl(this.data.audioUrl_waiting_secondRound, () => {
                        asyncPlayDragonBoneAnimation(this.cat, "normal", 0)
                        this._catSpeaking = false;
                        aniCall();
                    })

                })
            }



            let aniCall = () => {


                let wp1 = this.bfly.convertToWorldSpaceAR(cc.Vec2.ZERO);
                let wp2 = this.btn_keyboard.convertToWorldSpaceAR(cc.Vec2.ZERO)
                let offsetX = wp2.x - wp1.x;
                console.log("offset  x =" + offsetX)
                cc.tween(this.bfly).by(1, { x: offsetX }).call(() => {
                    this.bfly.getComponent(dragonBones.ArmatureDisplay).playAnimation("begin", 1);
                }).delay(1.5).call(() => {
                    this.playLocalAudio("flyd")
                }).delay(1.5).call(() => {
                    this._sendMsg(MsgType.USER_PREPARE_REQ, {});

                    this._initCardClickEvent();

                }).by(1, { x: -offsetX }).start();
            }


        } else {

            this.unschedule(this._cyclePlayAudio);
            cc.audioEngine.stopAllEffects();
            // 鸟飞走

            await this._birdsFly(data.ary);


            let endview = cc.instantiate(this.endViewPrefab);
            endview.parent = this.node;
            endview.zIndex = 1000;
            let endViewCom: EndView = endview.getComponent(EndView);

            let realRedScore = (Math.floor(data.redScore / 100) + data.redScore % 100);
            let realBlueScore = (Math.floor(data.blueScore / 100) + data.blueScore % 100);

            if (this.playerId == data.uuid) {

                cc.audioEngine.stopAllEffects();
                this._catSpeaking = false;
                asyncPlayDragonBoneAnimation(this.cat, "begin", 0)
                this.playAudioByUrl(this.data.audioUrl_win, () => {
                    asyncPlayDragonBoneAnimation(this.cat, "normal", 0)
                    this._catSpeaking = false;
                    endViewCom.showView(
                        true,
                        realRedScore,
                        realBlueScore,
                        this._redUrl,
                        this._blueUrl
                    )
                })
            } else {
                cc.audioEngine.stopAllEffects();
                this._catSpeaking = false;
                asyncPlayDragonBoneAnimation(this.cat, "begin", 0)
                this.playAudioByUrl(this.data.audioUrl_lose, () => {
                    asyncPlayDragonBoneAnimation(this.cat, "normal", 0)
                    this._catSpeaking = false;
                    endViewCom.showView(
                        false,
                        realRedScore,
                        realBlueScore,
                        this._redUrl,
                        this._blueUrl
                    )
                })
            }



        }
    }
    async _birdsFly(list) {

        console.log("fly list=====");
        console.log(list);

        let len = list[1] - list[0];
        let x = 1; let y = 1;
        if (len == 1) {
            x = 0;
        } else if (len == 4) {
            x = 0;
        } else if (len == 5) {
            x = -1
        } else if (len == 3) {
            x = 1
        }

        this.playLocalAudio("line");
        for (let i = 0; i < list.length; ++i) {
            let bird = this._birdsRoot.getChildByName("bird" + list[i])
            let card = this._wordCardRoot.getChildByName("bird" + list[i])
            cc.tween(bird).by(2, { x: x * 3000, y: y * 3000 }).start();
            asyncPlayDragonBoneAnimation(bird, "right", 0);
            cc.tween(card).by(2, { x: x * 3000, y: y * 3000 }).start()
        }
        await asyncDelay(2)

    }
    _initCardClickEvent() {
        this._wordCardRoot.children.forEach((card, index) => {
            if (!card.getComponent(cc.Button)) {
                card.addComponent(cc.Button)
            }
            card.on("click", () => {

                console.log("===click birds===");
                this._sendMsg(
                    MsgType.USER_REQ_ERQ,
                    {
                        uuid: this.playerId,
                        index: index,
                    }
                )

            })

        })
    }
    _updateProgrss(redScore, blueScore, round) {

        let realRedScore = (Math.floor(redScore / 100) + redScore % 100);
        let realBlueScore = (Math.floor(blueScore / 100) + blueScore % 100);
        this._redLb.string = "" + realRedScore;
        this._blueLb.string = "" + realBlueScore;

        if (round == 1) {
            this._redLightList.children.forEach((node) => {
                node.active = +node.name <= redScore % 100
            })
            this._blueLightList.children.forEach((node) => {
                node.active = +node.name <= blueScore % 100
            })
        } else {
            this._redLightList.children.forEach((node) => {
                node.active = +node.name <= Math.floor(redScore / 100)
            })
            this._blueLightList.children.forEach((node) => {
                node.active = +node.name <= Math.floor(blueScore / 100)
            })
        }
    }
    async _updateCards(list, delay?) {

        for (let i = 0; i < list.length; ++i) {
            let data = list[i];
            let word = data.word;
            let uuid = data.uuid;
            let cardBg = this._wordCardRoot.children[i];

            if (cardBg.getChildByName("word")) {
                continue;
            } else {

                if (delay) {
                    await asyncDelay(0.2)
                }
                let wordNode = this.getSprNode(word)
                wordNode.parent = cardBg;
                wordNode.name = "word";
                wordNode.x = 0;
                wordNode.y = 0;
                wordNode.zIndex = 10;
                let side = this._getSideByUuid(uuid);

                if (side == "Red") {

                    let coverBg = this.getSprNode("RedBox");
                    coverBg.parent = cardBg;
                    coverBg.name = "cover"
                    coverBg.x = 0;
                    coverBg.y = 0;

                } else if (side == "Blue") {
                    let coverBg = this.getSprNode("BlueBox");
                    coverBg.parent = cardBg;
                    coverBg.name = "cover"
                    coverBg.x = 0;
                    coverBg.y = 0;
                }
            }
        }

    }

    async _reInitCards() {
        for (let i = 0; i < 16; ++i) {
            let cardBg = this._wordCardRoot.children[i];
            let cover = cardBg.getChildByName("cover");
            cover && (cover.parent = null);
        }
    }
    async _updateRound2Cards(list) {

        list.forEach((val) => {
            let index = val.index;
            let uuid = val.uuid;
            let cardBg = this._wordCardRoot.children[index];
            if (cardBg.getChildByName("cover1")) {

            } else {
                let side = this._getSideByUuid(uuid);
                if (side == "Red") {
                    let coverBg = this.getSprNode("RedBox");
                    coverBg.parent = cardBg;
                    coverBg.name = "cover1"
                    coverBg.zIndex = 5;
                    coverBg.x = 0;
                    coverBg.y = 0;

                } else if (side == "Blue") {
                    let coverBg = this.getSprNode("BlueBox");
                    coverBg.parent = cardBg;
                    coverBg.name = "cover1";
                    coverBg.zIndex = 5
                    coverBg.x = 0;
                    coverBg.y = 0;
                }
            }

        })

    }
    _getSideByUuid(uuid) {
        let side = "";
        this._playerList.forEach((player) => {
            if (player.uuid == uuid) {
                side = player.side
            }
        });
        return side;
    }
    _updateClock(time: number) {

        if (this._leftTime == time) return
        this._leftTime = time;
        this._clockTime.string = "" + Math.round(time);
        cc.tween(this._clockTime.node).to(0.3, { scale: 1.2 }).to(0.7, { scale: 1 }).start();
    }
    _checkUserAnswer(data: { round: number, uuid: string, index: number, result: resultType }) {

        if (data.round == 1) {
            if (this.playerId == data.uuid) {

                if (data.result == resultType.REPEAT) {
                    cc.log("这个单词已经存在了");

                    this.playAudioByUrl(this.data.audioUrl_filled)

                } else if (data.result == resultType.WRONG) {
                    cc.log("抱歉 你答错了");
                    this.playLocalAudio("wordCardwrong")
                } else if (data.result == resultType.RIGHT) {
                    this.playLocalAudio("wordRight")
                    cc.log("恭喜你答对了");
                }
            }
        } else {

            let bird = this._birdsRoot.children[data.index]
            if (this.playerId == data.uuid) {
                if (data.result == resultType.WRONG) {
                    cc.log("抱歉 你答错了");
                    this.playLocalAudio("birdwrong")

                    asyncPlayDragonBoneAnimation(bird, "wrong").then(() => {
                        bird.getComponent(dragonBones.ArmatureDisplay).playAnimation("normal", 0);
                    })

                } else if (data.result == resultType.RIGHT) {

                    this.playLocalAudio("birdHappy")
                    asyncPlayDragonBoneAnimation(bird, "right").then(() => {
                        bird.getComponent(dragonBones.ArmatureDisplay).playAnimation("normal", 0);
                    })
                    cc.log("恭喜你答对了");
                }
            }
        }
    }

    async openCoursView(node, word) {
        this.cover.active = true;
        this.cat.active = false;
        this._clockNode.active = false;
        let probar = this.cover.getChildByName("bg").getChildByName("probar");
        let pass = this.cover.getChildByName("bg").getChildByName("pass");
        let loss = this.cover.getChildByName("bg").getChildByName("loss");
        this.cover.getChildByName("bg").getChildByName("bar").removeAllChildren();
        let icon = cc.instantiate(node);
        icon.parent = this.cover.getChildByName("bg").getChildByName("bar");
        icon.x = 0;
        icon.y = 0;
        icon.scale = Math.min(600 / icon.width, 600 / icon.height);
        pass.active = false;
        loss.active = false;

        probar.getComponent(cc.ProgressBar).unscheduleAllCallbacks();
        let total = 1;
        probar.getComponent(cc.ProgressBar).progress = total;

        if (!this._recordBefore && this.data.recordWait) {//
            this._recordBefore = true;
            await new Promise((resolve) => {
                this.recordCat.getComponent(dragonBones.ArmatureDisplay).playAnimation("normal", 0);
                this.playAudioByUrl(this.data.recordWait, () => {
                    this.recordCat.getComponent(dragonBones.ArmatureDisplay).playAnimation("record", 0);
                    console.log("record audio done==============");
                    resolve("")
                });
            })
        } else {
            this.recordCat.getComponent(dragonBones.ArmatureDisplay).playAnimation("record", 0);
        }

        this._startCourseware(word);
        await asyncDelay(0.5);
        // 6s 
        probar.getComponent(cc.ProgressBar).schedule(() => {
            probar.getComponent(cc.ProgressBar).progress = total;
            total -= 1 / 30;
            if (total < 0) {
                probar.getComponent(cc.ProgressBar).unscheduleAllCallbacks();
                this._coursewareStoped();
            }
        }, 0.1, 61, 0.1)
    }

    async _startCourseware(word) {
        if (!cc.sys.isBrowser && window["courseware"]?.startTest) {

            this.log("录音开始 单词：" + word);
            window["courseware"]?.startTest(word);
        } else {

            console.log("web 模拟录音开始");
        }
    }
    async _coursewareStoped() {

        // this.cover.active = false;
        // cc.tween(this.cover).to(0.5, { opacity: 255 }).start();
        // await asyncDelay(0.5);

        if (!cc.sys.isBrowser && window["courseware"]?.stopTest) {
            window["courseware"]?.stopTest((res, b) => {

                if (typeof res == "string") {
                    res = JSON.parse(res);
                }
                this.log("++++++++++++ _coursewareEnd  +++++++++++++++");
                this.log("发音分数： pronunciation=== " + res.result?.pronunciation);
                this._coursewareEnd(res.result?.pronunciation || 0,)
            });
        } else {
            await asyncDelay(3);
            this.log("web 模拟录音评测 结果");
            this._coursewareEnd(Math.random() > 0.7 ? 90 : 60)
        }

    }
    async _coursewareEnd(score: number) {



        this.log("测评分数：" + score);
        if (score >= 70) {

            let pass = this.cover.getChildByName("bg").getChildByName("pass");
            pass.active = true;
            pass.scale = 0;
            cc.tween(pass).to(0.3, { scale: 0.5 }, { easing: "cubicIn" }).start();
            this.playLocalAudio("right");
            await asyncDelay(1);

            this.cover.active = false;
            this.cat.active = true;
            this._clockNode.active = true;
            this.log("====评测通过=====");
            // this.networkHelper.sendFrame({
            //     type: "right",
            //     uuid: this.myData.uuid,
            // });


        } else {

            let loss = this.cover.getChildByName("bg").getChildByName("loss");
            loss.active = true;
            loss.scale = 0;
            cc.tween(loss).to(0.3, { scale: 0.5 }, { easing: "cubicIn" }).start();
            this.playLocalAudio("wrong");
            await asyncDelay(1);
            this.cover.active = false;
            this.cat.active = true;
            this._clockNode.active = true;
            this.log("====评测不通过=====");
            // this.networkHelper.sendFrame({
            //     type: "wrong",
            //     uuid: this.myData.uuid,
            // });

        }

    }


    finish() {
        // onHomeworkFinish();
    }

    async playLocalAudio(audioName) {

        if (this._audioNode) {
            if (this._audioNode?.getComponent(cc.AudioSource)?.isPlaying) {
                this._audioNode?.getComponent(cc.AudioSource).stop();
            }
        }

        let audioNode = this._localAudioRoot.getChildByName(audioName);
        if (audioNode) {

            this._audioNode = audioNode;
            // let realTime = audioNode.getComponent(cc.AudioSource).getDuration();
            audioNode.getComponent(cc.AudioSource).play();
        } else {

            console.warn("no local audio with name " + audioName);
        }


    }
    // 生命周期
    onDestroy() {
        this.networkHelper.onDestroy();
    }
}

