import {
    MySprite, tweenChange,
    ShapeRect
} from './Unit';

export class AudioAnimation {

    private x = 0;

    private y = 0;

    images = new Map();

    bg: ShapeRect;

    playPic1;

    playPic2;

    playPic3;

    playPic4;

    curAudio;

    playing = false;

    hideFlag = true;

    /**
     * 设置播放帧图片
     * @param images 
     */
    constructor(images) {

        this.images = images;
    }

    setXY(x, y) {
        this.x = x;
        this.y = y;
    }

    /**
     * 初始化图
     * @param parent 图片显示父对象 
     * @param show 是否直接显示
     */
    initPic(parent, show: boolean) {

        if (!parent) {
            return;
        }


        const bg = new ShapeRect();

        const getAudioPic = (index) => {
            const playPic = new MySprite();
            playPic.init(this.images.get("btn_laba" + index));
            playPic.alpha = 0;
            playPic.x = playPic.getBoundingBox().width / 2;
            playPic.y = playPic.getBoundingBox().height / 2;
            bg.addChild(playPic);
            return playPic;
        };

        const playPic1 = getAudioPic(1);


        if (show) {
            playPic1.alpha = 1;

            this.hideFlag = false;
        }
        else {
            playPic1.alpha = 0;
            this.hideFlag = true;
        }
        this.playPic1 = playPic1;

        const playPic2 = getAudioPic(2);
        this.playPic2 = playPic2;

        const playPic3 = getAudioPic(3);
        this.playPic3 = playPic3;

        const playPic4 = getAudioPic(4);
        this.playPic4 = playPic4;


        bg.setSize(playPic1.getBoundingBox().width, playPic1.getBoundingBox().height);
        bg.alpha = 0;
        this.bg = bg;
        bg.x = this.x;
        bg.y = this.y;

        if (parent instanceof Array) {
            parent.push(bg);
        }
        else {
            parent.addChild(bg);
        }
    }

    /**
     * 显示播放状态
     */
    showPlayStauts() {

        this.hideFlag = false;

        const setPause = () => {

            if (this.hideFlag) {
                this.playPic1.alpha = 0;
            }
            else {
                this.playPic1.alpha = 1;
            }

            this.playPic2.alpha = 0;
            this.playPic3.alpha = 0;
            this.playPic4.alpha = 0;
        }

        const show1 = () => {

            if (this.playing) {
                this.playPic1.alpha = 0;
                this.playPic2.alpha = 1;
                this.playPic3.alpha = 0;
                this.playPic4.alpha = 0;

                setTimeout(() => {
                    show2();
                }, 500);
            }
            else {
                setPause();
            }

        };

        const show2 = () => {

            if (this.playing) {
                this.playPic1.alpha = 0;
                this.playPic2.alpha = 0;
                this.playPic3.alpha = 1;
                this.playPic4.alpha = 0;

                setTimeout(() => {
                    show3();
                }, 500);
            }
            else {
                setPause();
            }

        };

        const show3 = () => {
            if (this.playing) {
                this.playPic1.alpha = 0;
                this.playPic2.alpha = 0;
                this.playPic3.alpha = 0;
                this.playPic4.alpha = 1;

                setTimeout(() => {
                    show4();
                }, 500);
            }
            else {
                setPause();
            }

        };

        const show4 = () => {
            if (this.playing) {
                this.playPic1.alpha = 1;
                this.playPic2.alpha = 0;
                this.playPic3.alpha = 0;
                this.playPic4.alpha = 0;

                setTimeout(() => {
                    show1();
                }, 500);
            }
            else {
                setPause();
            }

        };

        show1();
    }


    /**
     * 
     * @param audio 播放音频
     * @param callback 
     */
    playAudio(audio, callback = null) {
        //console.log(audio);
        if (!audio) {
            return;
        }

        this.curAudio = audio;

        audio.onended = () => {

            this.playing = false;
            if (callback) {
                callback();
            }

        };

        audio.play();

        this.playing = true;

        this.showPlayStauts();
    }

    /**
     * 
     * @param reset 是否重置
     * @param callback 暂停后执行方法
     */
    pauseAudio(reset = false, callback = null) {

        const audio = this.curAudio;

        if (audio) {

            this.playing = false;

            if (reset) {
                audio.currentTime = 0;
            }

            audio.pause();

            if (callback) {
                callback();
            }
        }
    }

    /**
     * 隐藏音频播放动画
     * @param reset 是否重置
     */
    hide(reset = false) {

        this.hideFlag = true;

        this.pauseAudio(reset);

        this.playPic1.alpha = 0;
        this.playPic2.alpha = 0;
        this.playPic3.alpha = 0;
        this.playPic4.alpha = 0;
    }

    /**
     * 显示播放动画
     */
    show() {

        this.hideFlag = false;

        this.playPic1.alpha = 1;
        this.playPic2.alpha = 0;
        this.playPic3.alpha = 0;
        this.playPic4.alpha = 0;
    }
}