import { playAudio } from './AudioUtil';
import { MySprite, ShapeRect, tweenChange } from './Unit';

export class Celebrate{
    bg: ShapeRect;

    images;

    audioObj;

    bigStar :MySprite;

    smallStar : MySprite;

    pic : MySprite;

    init(images, audioObj){
        this.images = images;

        this.audioObj = audioObj;

        const bg = new ShapeRect();
        this.bg = bg;
        bg.alpha = 0;

        this.initPic();
    }

    initPic(){
        const pic = new MySprite();
        pic.init(this.images.get('bg_goodiob'), 0.5, 0.5);
        pic.x = pic.width / 2;
        pic.y = pic.height / 2;
        this.bg.addChild(pic);
        this.pic = pic;
        this.bg.setSize(pic.width, pic.height);
;
        const bigStar = new MySprite();
        this.bigStar = bigStar
        bigStar.init(this.images.get('icon_star2'), 0.5, 0.5);
        bigStar.x = 49 + bigStar.width / 2;
        bigStar.y = 94 + bigStar.height / 2;
        this.bg.addChild(bigStar);

        const smallStar = new MySprite();
        this.smallStar = smallStar;
        smallStar.init(this.images.get('icon_star1'));
        smallStar.x = 474 + smallStar.width / 2;
        smallStar.y = 143 + smallStar.height / 2;
        this.bg.addChild(smallStar);
    }

    show(mapscale = 1, callback = null){


        this.pic.setScaleXY(0);

        this.smallStar.setScaleXY(0);

        this.bigStar.setScaleXY(0);

        playAudio(this.audioObj['celebrate'], true);

        tweenChange(this.pic, {scaleX : 1, scaleY : 1}, 0.5, ()=>{
            tweenChange(this.smallStar, {scaleX : 1 * 1.3, scaleY : 1 * 1.3}, 0.3, ()=>{
                tweenChange(this.smallStar, {scaleX : 1, scaleY : 1}, 0.3)
            });

            tweenChange(this.bigStar, {scaleX : 1 * 1.3, scaleY : 1 * 1.3}, 0.3, ()=>{
                tweenChange(this.bigStar, {scaleX : 1, scaleY : 1}, 0.3, callback)
            });
        })
    }
}