import { MySprite, ShapeRect } from './Unit';

export class Answer {

    bg: ShapeRect;

    images;

    audioObj;

    data;

    width = 394;

    height = 490;

    pic : MySprite;

    init(data, images, audioObj) {

        this.audioObj = audioObj;

        this.images = images;

        this.data = data;

        const bg = new ShapeRect();
        bg.setSize(this.width, this.height);
        bg.alpha = 0;
        this.bg = bg;

        this.initPic();
    }

    initPic() {
        const setMaxScale = (target: MySprite, maxW, maxH) => {
            const sx = maxW / target.width;
            const sy = maxH / target.height;
            const s = Math.min(sx, sy);
            target.setScaleXY(Math.round(s * 1000) / 1000);
        }

        const pic = new MySprite();
        pic.init(this.images.get(this.data.picUrl));
        pic.x = this.width / 2;
        pic.y = this.height / 2;
        this.pic = pic;
        setMaxScale(pic, this.width, this.height);
        this.bg.addChild(pic);
    }
}