import { AudioAnimation } from './AudioAnimation';
import { playAudio } from './AudioUtil';
import { Answer } from './Exercises';
import {
    ShapeRect,
    MySprite,
    Label,
    tweenChange
} from './Unit';

export class Stage {

    bg: ShapeRect;

    images;

    audioObj;

    data;

    width = 1280;

    height = 720;

    lGuardPic1: MySprite;

    lGuardPic2: MySprite;

    rGuardPic1: MySprite;

    rGuardPic2: MySprite;

    numberPic: MySprite;

    leftCrownPic: MySprite;

    rightCrownPic: MySprite;

    leftChoicePic: MySprite;

    rightChoicePic: MySprite;

    numberLabel: Label;

    total: any = 0;

    totalPage : any = 0;

    curPage :any = 0;

    lIconRight: MySprite;

    rIconRight: MySprite;

    rightScroll: MySprite;

    wrongScroll: MySprite;

    nextPagePic: MySprite;

    lastPagePic : MySprite;

    resultArr: Array<ExercisesResult> = [];

    lastBtn: MySprite;

    nextBtn: MySprite;

    leftAnswer: Answer;

    rightAnswer: Answer;

    audioAni: AudioAnimation;

    leftBg : ShapeRect;

    rightBg : ShapeRect;


    init(images, audioObj, data) {
        console.log(data);
        this.images = images;

        this.audioObj = audioObj;

        this.data = {};

        if (data) {
            this.data = data;
        }

        this.total = this.data.exercisesArr ? this.data.exercisesArr.length : 0;

        this.totalPage = Math.ceil(this.total / 12);

        this.bg = new ShapeRect();
        this.bg.setSize(this.width, this.height);
        this.bg.alpha = 0;

        this.initPic();

        this.initChoice();

        this.initGuard();

        this.initCrown();


    }

    initPic() {

        const star = new MySprite();
        star.init(this.images.get('bg_star'));
        star.x = this.bg.getBoundingBox().width / 2;
        star.y = star.getBoundingBox().height / 2;
        this.bg.addChild(star);

        const pic = new MySprite();
        pic.init(this.images.get('bg_di'), 0.5, 1);
        pic.x = this.bg.getBoundingBox().width / 2;
        pic.y = this.bg.getBoundingBox().height + 22;
        this.bg.addChild(pic);


        const numberPic = new MySprite();
        numberPic.init(this.images.get('bg_number'), 0.5, 0);
        numberPic.x = this.bg.getBoundingBox().width / 2;
        numberPic.y = 0;
        this.bg.addChild(numberPic);
        this.numberPic = numberPic;

        const numberLabel = new Label();
        this.numberLabel = numberLabel;
        numberLabel.fontColor = "#af5954";
        numberLabel.fontName = "CSMB";
        numberLabel.fontSize = 50;
        this.numberLabel.textAlign = 'center';
        this.setNumber(0);
        numberLabel.y = 29 + numberLabel.getBoundingBox().height / 2;
        numberLabel.x = this.bg.getBoundingBox().width / 2;
        this.bg.addChild(numberLabel);


        this.lastBtn = new MySprite();
        this.lastBtn.init(this.images.get('btn_last'), 0, 0);
        this.lastBtn.x = 66;
        this.lastBtn.y = 194;
        this.lastBtn.alpha = 0;
        this.bg.addChild(this.lastBtn);

        this.nextBtn = new MySprite();
        this.nextBtn.init(this.images.get('btn_next'), 1, 0);
        this.nextBtn.x = this.bg.width - 66;
        this.nextBtn.y = this.lastBtn.y;
        this.nextBtn.alpha = 0;
        this.bg.addChild(this.nextBtn);

        const audioAni = new AudioAnimation(this.images);
        audioAni.setXY(1129, 78);
        audioAni.initPic(this.bg, true);
        this.audioAni = audioAni;

        this.nextPagePic = new MySprite();
        this.nextPagePic.init(this.images.get('btn_fanye'), 1, 1);
        this.nextPagePic.x = this.bg.width - 78;
        this.nextPagePic.y = this.bg.height - 58;
        this.bg.addChild(this.nextPagePic);
        this.nextPagePic.visible = false;

        this.lastPagePic = new MySprite();
        this.lastPagePic.init(this.images.get('btn_fanye2'), 1, 1);
        this.lastPagePic.x = this.nextPagePic.x;
        this.lastPagePic.y = this.bg.height - 94 - this.nextPagePic.height;
        this.bg.addChild(this.lastPagePic);
        this.lastPagePic.visible = false;
    }

    initGuard() {

        const lGuardPic1 = new MySprite();
        lGuardPic1.init(this.images.get('bg_monkeyleft1'), 0, 1);
        lGuardPic1.x = 4;
        lGuardPic1.y = this.bg.getBoundingBox().height - 19;
        this.bg.addChild(lGuardPic1);
        this.lGuardPic1 = lGuardPic1;

        const lGuardPic2 = new MySprite();
        lGuardPic2.init(this.images.get('bg_monkeyleft2'), 0, 1);
        lGuardPic2.x = lGuardPic1.x;
        lGuardPic2.y = lGuardPic1.y;
        lGuardPic2.alpha = 0;
        this.bg.addChild(lGuardPic2);
        this.lGuardPic2 = lGuardPic2;

        const lIconRight = new MySprite();
        lIconRight.init(this.images.get('icon_right'), 0.5, 1);
        lIconRight.y = this.bg.height - 320;
        lIconRight.visible = false;
        lIconRight.x = 43 + lIconRight.width / 2;
        this.bg.addChild(lIconRight);
        this.lIconRight = lIconRight;

        const rGuardPic1 = new MySprite();
        rGuardPic1.init(this.images.get('bg_monkeyright1'), 1, 1);
        rGuardPic1.x = this.bg.getBoundingBox().width - 4;
        rGuardPic1.y = this.bg.getBoundingBox().height - 19;
        this.bg.addChild(rGuardPic1);
        this.rGuardPic1 = rGuardPic1;

        const rGuardPic2 = new MySprite();
        rGuardPic2.init(this.images.get('bg_monkeyright2'), 1, 1);
        rGuardPic2.x = rGuardPic1.x;
        rGuardPic2.y = rGuardPic1.y;
        rGuardPic2.alpha = 0;
        this.bg.addChild(rGuardPic2);
        this.rGuardPic2 = rGuardPic2;

        const rIconRight = new MySprite();
        rIconRight.init(this.images.get('icon_right'), 0.5, 1);
        rIconRight.y = this.bg.height - 320;
        rIconRight.visible = false;
        rIconRight.x = (this.bg.width - 43) - rIconRight.getBoundingBox().width / 2;
        this.bg.addChild(rIconRight);
        this.rIconRight = rIconRight;
    }

    initCrown() {
        const leftCrownPic = new MySprite();
        leftCrownPic.init(this.images.get('bg_fu'), 0, 0);
        leftCrownPic.x = 351;
        leftCrownPic.y = -20;
        this.bg.addChild(leftCrownPic);
        this.leftCrownPic = leftCrownPic;

        const rightCrownPic = new MySprite();
        rightCrownPic.init(this.images.get('bg_fu'), 1, 0);
        rightCrownPic.x = this.bg.getBoundingBox().width - 351;
        rightCrownPic.y = leftCrownPic.y;
        this.bg.addChild(rightCrownPic);
        this.rightCrownPic = rightCrownPic;
    }

    initChoice() {

        const leftChoicePic = new MySprite();
        leftChoicePic.init(this.images.get('bg_xuanxiang1'), 0.5, 0.5);
        leftChoicePic.x = 200 + leftChoicePic.width / 2;
        leftChoicePic.y = 112 + leftChoicePic.height / 2;
        this.bg.addChild(leftChoicePic);
        this.leftChoicePic = leftChoicePic;

        this.leftBg = new ShapeRect();
        this.leftBg.setSize(leftChoicePic.width, leftChoicePic.height);
        this.leftBg.alpha = 0;
        this.leftBg.x = 200;
        this.leftBg.y = 112;
        this.bg.addChild(this.leftBg);

        const rightChoicePic = new MySprite();
        rightChoicePic.init(this.images.get('bg_xuanxiang2'), 0.5, 0.5);
        rightChoicePic.x = 640 + rightChoicePic.width / 2;
        rightChoicePic.y = leftChoicePic.y;
        this.bg.addChild(rightChoicePic);
        this.rightChoicePic = rightChoicePic;

        this.rightBg = new ShapeRect();
        this.rightBg.setSize(rightChoicePic.width, rightChoicePic.height);
        this.rightBg.alpha = 0;
        this.rightBg.x = 640;
        this.rightBg.y = this.leftBg.y;
        this.bg.addChild(this.rightBg);
    }

    setNumber(val) {

        let text = "";

        if (!val) {
            text += 0;
        }
        else {
            text += val;
        }

        text += "/" + this.total;

        this.numberLabel.text = text;
        this.numberLabel.refreshSize();


    }

    hide() {
        this.numberLabel.visible = false;
        this.numberPic.visible = false;

        this.leftChoicePic.visible = false;
        this.rightChoicePic.visible = false;

        this.lGuardPic1.visible = false;
        this.lGuardPic2.visible = false;

        this.rGuardPic1.visible = false;
        this.rGuardPic2.visible = false;

        this.leftCrownPic.visible = false;
        this.rightCrownPic.visible = false;

        this.rIconRight.visible = false;
        this.lIconRight.visible = false;

        this.audioAni.hide(true);

        if (this.rightScroll) {
            this.bg.removeChild(this.rightScroll);
            this.rightScroll = null;
        }

        if (this.wrongScroll) {
            this.bg.removeChild(this.wrongScroll);
            this.wrongScroll = null;
        }

        if (this.leftAnswer) {
            this.leftBg.removeChild(this.leftAnswer.bg);
            this.leftAnswer = null;
        }

        if (this.rightAnswer) {
            this.rightBg.removeChild(this.rightAnswer.bg);
            this.rightAnswer = null;
        }

    

        if (this.lastBtn) {
            this.lastBtn.alpha = 0;
        }

        if (this.nextBtn) {
            this.nextBtn.alpha = 0;
        }
    }

    initPage() {
        if (this.rightScroll) {
            this.bg.removeChild(this.rightScroll);
        }

        if (this.wrongScroll) {
            this.bg.removeChild(this.wrongScroll);
        }


        this.numberLabel.visible = true;
        this.numberPic.visible = true;

        this.leftChoicePic.visible = true;
        this.rightChoicePic.visible = true;

        this.lGuardPic1.visible = true;
        this.lGuardPic2.visible = true;

        this.rGuardPic1.visible = true;
        this.rGuardPic2.visible = true;

        this.leftCrownPic.visible = true;
        this.rightCrownPic.visible = true;

        this.lGuardPic1.alpha = 1;
        this.lGuardPic2.alpha = 0;

        this.rGuardPic1.alpha = 1;
        this.rGuardPic2.alpha = 0;

        this.leftCrownPic.alpha = 1;
        this.rightCrownPic.alpha = 1;

        this.rIconRight.visible = false;
        this.lIconRight.visible = false;

        if (this.audioAni.hideFlag) {
            this.audioAni.show();
        }
    }

    showRight(flag, callback = null) {

        const getIcon = () => {
            const iconRight = new MySprite();
            iconRight.init(this.images.get('icon_right'), 0.5, 1);
            iconRight.y = this.bg.height - 320;
            this.bg.addChild(iconRight);

            return iconRight;
        }

        const getRightScroll = () => {
            const rightScroll = new MySprite();
            rightScroll.init(this.images.get('bg_right'), 0.5, 1);
            rightScroll.y = 0;
            this.bg.addChild(rightScroll);

            return rightScroll;
        }

        this.rightScroll = getRightScroll();

        playAudio(this.audioObj['right'], true);

        if (flag == 'L') {

            this.lIconRight.visible = true;;

            this.leftCrownPic.alpha = 0;

            this.rightScroll.x = this.leftCrownPic.x + this.rightScroll.width / 2;
        }
        else if (flag == 'R') {

            this.rIconRight.visible = true;
            this.rightCrownPic.alpha = 0;
            this.rightScroll.x = this.rightCrownPic.x - this.rightScroll.width / 2;
        }

        tweenChange(this.rightScroll, { y: this.rightScroll.height }, 0.5, () => {
            if (callback) {
                callback();
            }
        })


    }

    showWrong(flag, callback = null) {

        playAudio(this.audioObj['wrong'], true);

        const getWrongScroll = () => {
            const wrongScroll = new MySprite();
            wrongScroll.init(this.images.get('bg_wrong'), 0.5, 1);
            wrongScroll.y = 0;
            this.bg.addChild(wrongScroll);

            return wrongScroll;
        }


        this.wrongScroll = getWrongScroll();

        if (flag == 'L') {

            this.lGuardPic1.alpha = 0;
            this.lGuardPic2.alpha = 1;

            this.wrongScroll.x = this.leftCrownPic.x + this.wrongScroll.width / 2;
        }
        else if (flag == 'R') {
            this.rGuardPic1.alpha = 0;
            this.rGuardPic2.alpha = 1;
            this.wrongScroll.x = this.rightCrownPic.x - this.wrongScroll.width / 2;
        }

        tweenChange(this.wrongScroll, { y: this.wrongScroll.height }, 0.5, () => {
            if (callback) {
                callback();
            }
        })
    }

    initSummary(page = 0) {

        //隐藏其它内容
        this.hide();

        if (this.resultArr) {
            for (let i = 0; i < this.resultArr.length; ++i) {
                this.bg.removeChild(this.resultArr[i].bg);
            }
        }

        this.curPage = page;

        this.resultArr = [];


        var dW = 303;

        var dH = 132;

        let rows = 4;

        var startX = 200;

        var startY = 121;

        var tempY = startY;

        let start = page * 12;

        let limit = (page + 1) * 12;

        let total = this.data.exercisesArr.length;
        console.log(start, limit);
        if (start > total) {
            start = total;
        }

        if (limit > total) {
            limit = total;
        }

        for (let i = start; i < limit; ++i) {

            let item = this.data.exercisesArr[i];

            const result = new ExercisesResult();

            this.resultArr.push(result)

            result.init(this.images, this.audioObj, item);

            result.bg.x = startX;
            result.bg.y = startY;

            //换行
            if ((i + 1) % 4 != 0) {

                startY += dH;
            }
            else {
                startX += dW;
                startY = tempY;

            }

            this.bg.addChild(result.bg);

        }

        this.refreshPageBtn();
    }

    hideSummary() {
        if (this.resultArr) {
            for (let i = 0; i < this.resultArr.length; ++i) {
                this.bg.removeChild(this.resultArr[i].bg);
            }
        }

        this.resultArr = [];

        this.nextPagePic.visible = false;

        this.lastPagePic.visible = false;
    }

    refreshPageBtn(){
        if(this.curPage == 0){
            this.lastPagePic.visible = false;
        }
        else{
            this.lastPagePic.visible = true;
        }

        if(this.curPage < this.totalPage - 1){
            this.nextPagePic.visible = true;
        }
        else{
            this.nextPagePic.visible = false;
        }
    }

    setAnswer(leftAnswer: Answer, rightAnswer: Answer, callback = null) {

        this.initPage();

        let toY = 16;

        leftAnswer.bg.x = 15;
        leftAnswer.bg.y = toY;

        rightAnswer.bg.x = 31;
        rightAnswer.bg.y = toY;

        if (this.leftAnswer) {
            tweenChange(this.leftAnswer.pic, { alpha: 0 }, 0.5, () => {

                this.leftBg.removeChild(this.leftAnswer.bg);
                leftAnswer.pic.alpha = 0;
                this.leftBg.addChild(leftAnswer.bg);
                tweenChange(leftAnswer.pic, { alpha: 1 }, 0.5, () => {

                    this.leftAnswer = leftAnswer;
                })

            });

            tweenChange(this.rightAnswer.pic, { alpha: 0 }, 0.5, () => {

                this.rightBg.removeChild(this.rightAnswer.bg);
                rightAnswer.pic.alpha = 0;
                this.rightBg.addChild(rightAnswer.bg);
                tweenChange(rightAnswer.pic, { alpha: 1 }, 0.5, () => {


                    this.rightAnswer = rightAnswer;

                    if (callback) {
                        callback();
                    }
                })
            })
        }
        else {

            this.leftBg.addChild(leftAnswer.bg);
            this.leftAnswer = leftAnswer;

            this.rightBg.addChild(rightAnswer.bg);
            this.rightAnswer = rightAnswer;

            if (callback) {
                callback();
            }
        }

    }

}

export class ExercisesResult {
    bg: ShapeRect;

    pic: MySprite;

    images;

    audioObj;

    exercises;

    init(images, audioObj, exercises) {

        this.images = images;

        this.audioObj = audioObj;

        this.exercises = exercises;

        this.bg = new ShapeRect();

        this.bg.alpha = 0;

        this.initPic();

        this.bg.setSize(this.pic.width, this.pic.height);

        this.initIndexLabel();

        this.showFlag();
    }

    initPic() {

        const pic = new MySprite();

        pic.init(this.images.get('btn_ti'), 0, 0);

        pic.x = 0;
        pic.y = 0;

        this.pic = pic;

        this.bg.addChild(this.pic);

    }

    initIndexLabel() {
        const indexLabel = new Label();
        indexLabel.fontColor = "#f8d591";
        indexLabel.fontName = "BRLNSDB";
        indexLabel.text = this.exercises.index + 1;
        indexLabel.fontSize = 70;
        indexLabel.refreshSize();
        indexLabel.x = 29;
        indexLabel.y = this.bg.height / 2;
        this.bg.addChild(indexLabel);

    }

    showFlag() {

        let isRight = this.exercises.isRight;

        const icon = new MySprite();

        if (isRight == "1") {

            icon.init(this.images.get('icon_tiright'));

        }
        else {
            icon.init(this.images.get('icon_tiwrong'));
        }

        icon.x = this.bg.width / 2;
        icon.y = this.bg.height / 2;

        this.bg.addChild(icon);
    }
}