import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  ApplicationRef,
  ChangeDetectorRef,
} from "@angular/core";
import { JsonPipe } from "@angular/common";

@Component({
  selector: "app-form",
  templateUrl: "./form.component.html",
  styleUrls: ["./form.component.css"],
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "andy_ww01";
  // 储存对象
  item;
  aniEnter: any = {
    skeJsonData: {},
    texJsonData: {},
    texPngData: {},
    audioUrl: null,
    time: 1,
  }
  group = [];

  constructor(
    private appRef: ApplicationRef,
    private changeDetectorRef: ChangeDetectorRef
  ) { }

  createShell() {
    this.item.wordList.push({
      word: "",
      audio: "",
      backWord: "",
      backWordAudio: "",
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {
    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {
      if (data) {
        if (data.aniEnter) {
          this.aniEnter = data.aniEnter;
        }
        this.item = data.item ? data.item : {};
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
    }, this.saveKey);
  }

  ngOnChanges() { }

  ngOnDestroy() { }

  init() {
    if (this.item.group) {
      this.group = this.item.group;
    }
  }

  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }



  saveAniEnter(e) {
    console.log(e);
    this.save();
  }
  onAudioUploadAniEnter(e) {
    this.aniEnter.audioUrl = e.url
    this.save();
  }
  onTxtChangeAniEnter() {
    this.save()
  }




  /**
   * 储存数据
   */
  save() {
    this.item.group = this.group;

    let obj: any = {
      aniEnter: this.aniEnter,
      item: this.item
    };
    (<any>window).courseware.setData(obj, null, this.saveKey);

    this.refresh();
    console.log("this.item = " + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

  onImageUploadSuccessByItem(e, item, id = null) {
    item["pic_url"] = e.url;
    this.save();
  }

  onAudioUploadSuccessByItem(e, item, id = null) {
    item["audio_url"] = e.url;
    this.save();
  }

  /**
   * 添加选项组
   */
  addGroup() {
    if (this.group.length >= 8) {
      return;
    }

    const data = {
      up: {
        type: 0,
        pic_url: "",
        text: "",
        audio_url: "",
      },
      down: {
        type: 1,
        pic_url: "",
        text: "",
        audio_url: "",
      },
    };

    this.group.push(data);

    this.save();
  }

  deleteItem(data) {
    const index = this.group.indexOf(data);
    if (index !== -1) {
      this.group.splice(index, 1);
    }

    this.save();
  }





}
