// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import Game from "../../scene/Game";
import pg from "../../scene/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    // LIFE-CYCLE CALLBACKS:
    onLoad() {
        pg.event.on("mouse_add", () => {
            this.showBigStar();
        })
        pg.event.on("mouse_num", (max: number) => {
            this.initStar(max);
        })
    }
    init(max) {
    }
    reviceMouse() {
    }

    start() {

    }
    //-----------------------STAR-----------------------------
    bigStarArr: cc.Node[];
    canvas: cc.Node;
    curGroupIndex: number
    @property(cc.Vec2)
    position: cc.Vec2;
    @property(cc.AudioClip)
    bigStarClip: cc.AudioClip;
    @property(cc.AudioClip)
    starCountClip: cc.AudioClip;
    //搭配res中的star_bg star等使用
    initStar(max) {
        this.curGroupIndex = 0;
        this.canvas = cc.find('Canvas');
        const gArr = [];
        gArr.length = max;
        if (gArr.length < 1) {
            return;
        }

        this.cleanStar();

        this.bigStarArr = [];

        let baseX = this.position.x;
        let baseY = this.position.y;
        let disW = 80;// * this._mapScaleMin
        // let disH = 80 * this._mapScaleMin;
        let disScale = 1;
        if (gArr.length > 5) {
            // disH = (400 / gArr.length) * this._mapScaleMin;
            disScale = 5 / gArr.length;
        }
        for (let i = 0; i < gArr.length; i++) {
            const starBg = this.getSprNode('star_bg');
            this.canvas.addChild(starBg, 10);
            // starBg.x = baseX;
            // starBg.y = baseY - i * disH;
            starBg.x = baseX - i * disW;
            starBg.y = baseY
            starBg.scale = disScale;

            const starTop = this.getSprNode('star');
            starBg.addChild(starTop);
            starTop.active = false;
            starBg.star = starTop;

            const starBig = this.getSprNode('icon_bigstar');
            starTop.addChild(starBig);
            starBig.angle = -90;
            starBg.starBig = starBig;

            this.bigStarArr.push(starBg);
        }

        console.log("bigStarArr: ", this.bigStarArr);
    }

    cleanStar() {
        if (this.bigStarArr && this.bigStarArr.length > 0) {
            for (let i = 0; i < this.bigStarArr.length; i++) {
                this.bigStarArr[i].removeFromParent();
            }
        }
    }

    showBigStar() {
        if (!this.bigStarArr || this.bigStarArr.length <= 0) {
            // this.checkGameEnd();
            return;
        }
        const bigStarBg = this.bigStarArr[this.curGroupIndex++];

        const starBig = bigStarBg.starBig;
        starBig.scale = 1;
        const star = bigStarBg.star;
        star.active = true;
        star.scaleX = 0.7 / bigStarBg.scale;
        star.scaleY = 1 / bigStarBg.scale;
        star.angle = 90;
        const canvas = cc.find('Canvas');
        const startPos = this.exchangeNodePos(star.parent, canvas);
        const middlePos = this.exchangeNodePos(star.parent, canvas);
        star.x = startPos.x;
        star.y = startPos.y - starBig.height;

        console.log('middlePos = ' + JSON.stringify(middlePos));
        const time = 1;
        cc.tween(star)
            .to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
            .to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
            .to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
            .delay(0.1)
            .to(0.8, { angle: -720, scale: 1 })
            .start();

        cc.tween(star)
            .delay(0.6)
            .to(0.8, { x: 0 }, { easing: 'quadIn' })
            .start();
        cc.tween(star)
            .delay(0.6)
            .to(0.8, { y: 0 }, { easing: 'quadOut' })
            .start();

        cc.tween(starBig)
            .delay(0.6)
            .to(0.8, { scale: 0 }, { easing: 'quadOut' })
            .call(() => {
                pg.event.emit("mouse_num_game_end")
                // this.playAudio(this.starCountClip);
            })
            .start();

        this.playAudio(this.bigStarClip);
    }
    //-----------------------STAR-----------------------------
    getSprNode(resName) {
        const sf = pg.view.find(this, `img/${resName}`).getComponent(cc.Sprite).spriteFrame;
        const node = new cc.Node();
        node.addComponent(cc.Sprite).spriteFrame = sf;
        return node;
    }
    exchangeNodePos(baseNode, targetNode) {
        return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
    }
    playAudio(audioClip, cb = null) {
        if (audioClip) {
            const audioId = cc.audioEngine.playEffect(audioClip, false);
            if (cb) {
                cc.audioEngine.setFinishCallback(audioId, () => {
                    cb();
                });
            }
        }
    }
    // update (dt) {}
}
