// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import Game from "../../scene/Game";
import pg from "../../scene/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class MouseStart extends cc.Component {
    @property(cc.Vec2)
    startPosition: cc.Vec2 = cc.v2(0, 0)
    @property(cc.Vec2)
    targetPosition: cc.Vec2 = cc.v2(0, 0)
    @property(cc.Float)
    moveInTime: number = 1;

    private ske: cc.Node;
    private block: cc.Node;
    private shadow: cc.Node;
    onLoad() {
        //修改ske的信息
        this.ske = this.node.getChildByName("ske");
        this.block = this.node.getChildByName("block");
        this.shadow = this.node.getChildByName("shadow");
        this.ske.x = this.startPosition.x;
        this.ske.y = this.startPosition.y;
        pg.event.on("mouse_start_play", (data) => {
            this.play(data).then(() => {
                pg.event.emit("mouse_start_play_success");
            })
        })
    }
    play({ voice, time }: any) {
        this.node.active = true;
        this.block.active = true;
        this.ske.active = true;
        this.ske.x = this.startPosition.x;
        this.ske.y = this.startPosition.y;
        this.moveInTime = time || 5;
        return new Promise((resolve, reject) => {
            let isPlaying = true;
            let load = false;
            pg.load.loadDB(this.ske, { ske: Game.getIns().aniEnter.skeJsonData.url, tex: Game.getIns().aniEnter.texJsonData.url, png: Game.getIns().aniEnter.texPngData.url }).then((animationName) => {
                if (load) return;
                load = true;
                cc.Tween.stopAllByTarget(this.ske);
                this.playLocalAudio('enter').then(() => {
                    this.playAudioByUrl(voice)
                })
                cc.tween(this.ske).to(0.5, { x: this.targetPosition.x, y: this.targetPosition.y }).delay(0.9).call(() => {
                    let db = this.ske.getComponent(dragonBones.ArmatureDisplay);
                    db.playAnimation('normal', 0);
                }).delay(this.moveInTime).call(() => {
                    this.playLocalAudio('leave')
                    cc.tween(this.ske).by(0.1, { y: 200 }).by(1, { y: -10000 }).call(() => {
                        this.ske.active = false;
                        this.node.active = false;
                        this.block.active = false;
                        resolve('');
                    }).start();
                }).start();
            })
        });

        // this.moveInTime = Game.getIns().aniEnter.time || 5;
        // return new Promise((resolve, reject) => {
        //     let isPlaying = true;
        //     this.ske.x = this.startPosition.x;
        //     this.ske.y = this.startPosition.y;
        //     this.ske.active = true;
        //     this.node.active = true;
        //     this.block.active = true;
        //     pg.load.loadDB(this.ske, { ske: Game.getIns().aniEnter.skeJsonData.url, tex: Game.getIns().aniEnter.texJsonData.url, png: Game.getIns().aniEnter.texPngData.url }).then((animationName) => {
        //         cc.tween(this.ske).to(1.3, { x: this.targetPosition.x, y: this.targetPosition.y }).call(() => {
        //             audioUrl = audioUrl ? audioUrl : Game.getIns().aniEnter.audioUrl;
        //             if (audioUrl) {
        //                 pg.audio.playAudioByUrl(audioUrl).then(() => {
        //                     isPlaying = false;
        //                     resolve('');
        //                 })
        //             }
        //             let db = this.ske.getComponent(dragonBones.ArmatureDisplay);
        //             db.playAnimation('normal', 1111111);
        //             db.addEventListener("loopComplete", () => {
        //                 if (!isPlaying) {
        //                     this.block.active = false;
        //                     resolve('');
        //                 }
        //             })
        //         }).delay(this.moveInTime).call(() => {
        //             this.ske.active = false;
        //             this.node.active = false;
        //             this.block.active = false;
        //         }).start();
        //     })
        // });
    }


    playAudioByUrl(audio_url, cb = null) {
        if (audio_url) {
            cc.assetManager.loadRemote(audio_url, (err, audioClip: any) => {
                const audioId = cc.audioEngine.play(audioClip, false, 0.8);
                if (cb) {
                    cc.audioEngine.setFinishCallback(audioId, () => {
                        cb();
                    });
                }
            });
        } else {
            cb && cb();
        }
    }
    playLocalAudio(audioName) {
        const audio = this.node.getChildByName("audio").getChildByName(audioName).getComponent(cc.AudioSource);
        return new Promise((resolve, reject) => {
            const id = cc.audioEngine.playEffect(audio.clip, false);
            cc.audioEngine.setFinishCallback(id, () => {
                resolve(id);
            });
        })
    }

}
