import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
	selector: 'app-form',
	templateUrl: './form.component.html',
	styleUrls: ['./form.component.css']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {

	// 储存数据用
	saveKey = "et_13";
	// 储存对象
	item;

	customTypeGroupArr = [
		{
			name: '发音动画',
			rect: true,
			animaSmall: true,
			audio: true,
		},
		{
			name: '发音图片',
			pic: true,
			audio: true,
		},
		{
			name: '发音区块',
			rect: true,
			audio: true,
		},
		{
			name: '变化文本',
			action: {
				type: 'text',
				option: [
					['fontColor', '#000000'],
					['fontSize', '100'],
					['opacity', '0', '100']
				]
			},
		},
		{
			name: '变化图片',
			action: {
				type: 'pic',
				option: [
					// ['scale', '1'],
					['opacity', '0', '100']
				]
			},
		},
		{
			name: '变化动画',
			action: {
				type: 'anima',
				option: [
					// ['scale', '1'],
					['opacity', '0', '100']
				]
			},
		},
	]

	constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

	}

	createShell() {
		this.item.wordList.push({
			word: '',
			audio: '',
			backWord: '',
			backWordAudio: '',
		});
		this.save();
	}

	removeShell(idx) {
		this.item.wordList.splice(idx, 1);
		this.save();
	}

	ngOnInit() {

		this.item = {};
		this.item.queArr = [];
		this.item.starArr = [];

		// 获取存储的数据
		(<any>window).courseware.getData((data) => {

			if (data) {
				this.item = data;
			}

			this.init();
			this.changeDetectorRef.markForCheck();
			this.changeDetectorRef.detectChanges();
			this.refresh();

		}, this.saveKey);
	}

	ngOnChanges() {
	}

	ngOnDestroy() {
	}

	init() {
	}

	onSaveCustomAction(e) {
		console.log('e:', e);
		this.item.customAction = e;
		this.save();
	}


	saveHotZone(group, e) {
		console.log('e: ', e);
		const { bgItem, hotZoneItemArr } = e;

		group.bgItem = bgItem;
		group.hotZoneItemArr = hotZoneItemArr;

		this.save();
	}

	//星星组
	addStar() {
		let queArr = { queArr: [] }
		this.item.starArr.push(queArr);
		this.save();
	}

	delStar(index) {
		if (index !== -1) {
			this.item.starArr.splice(index, 1);
			this.save();
		}
	}

	//红路灯组
	addSheepfold(item) {
		item.queArr.push({ bgItem: "", hotZoneItemArr: "", title: "", title_audio_url: "" });
		this.save();
	}

	delSheepfold(index, item) {
		if (index !== -1) {
			item.queArr.splice(index, 1);
			this.save();
		}
	}

	/**
	 * 储存图片数据
	 * @param e
	 */
	onImageUploadSuccess(e, key) {

		this.item[key] = e.url;
		this.save();
	}

	/**
	 * 储存音频数据
	 * @param e
	 */
	onAudioUploadSuccess(e, item, key) {
		item[key] = e.url;
		this.save();
	}

	onWordAudioUploadSuccess(e, idx) {
		this.item.wordList[idx].audio = e.url;
		this.save();
	}

	onBackWordAudioUploadSuccess(e, idx) {
		this.item.wordList[idx].backWordAudio = e.url;
		this.save();
	}

	/**
	 * 储存数据
	 */
	save() {
		(<any>window).courseware.setData(this.item, null, this.saveKey);

		this.refresh();
		console.log('this.item = ' + JSON.stringify(this.item));
	}

	/**
	 * 刷新 渲染页面
	 */
	refresh() {
		setTimeout(() => {
			this.appRef.tick();
		}, 1);
	}

}