import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-upload-dragon-bone',
  templateUrl: './upload-dragon-bone.component.html',
  styleUrls: ['./upload-dragon-bone.component.scss']
})
export class UploadDragonBoneComponent implements OnDestroy, OnChanges {
  uploading = false;
  progress = 0;
  @Input()
  btnName = '配置龙骨动画';
  @Input()
  animaNames = [];

  @Input()
  skeJsonData = {};
  @Input()
  texJsonData = {};
  @Input()
  texPngData = {};
  
  @Output()
  save = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();

  // @Input()
  // picUrl;
  // @Input()
  // canDelete = false;
  // @Output()
  // imageUploaded = new EventEmitter();
  // @Output()
  // imageUploadFailure = new EventEmitter();
  // @Output()
  // delete = new EventEmitter();
  // @Input()
  // picItem = null;
  // @Input()
  // iconSize = 2;
  // @Input()
  // TIP = 'Click here to upload image';
  // @Input()
  // disableUpload = false;


  uploadUrl;
  uploadData;

  animaPanelVisible = false;

  isSkeJsonLoading = false;
  isTexJsonLoading = false;
  isTexPngLoading = false;

  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    this.uploadUrl = (<any> window).courseware.uploadUrl();
    this.uploadData = (<any> window).courseware.uploadData();

    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };

  }
  ngOnChanges() {
 
  }

  setAnimaBtnClick() {
    this.animaPanelVisible = true;
    this.refresh();
  }

  animaPanelCancel() {
    this.animaPanelVisible = false;
    this.refresh();
  }

  animaPanelOk() {
    this.sendItemDragonBoneData();
    this.animaPanelVisible = false;
    this.refresh();
  }

  sendItemDragonBoneData() {
    const data = {};
    data['skeJsonData'] = this.skeJsonData;
    data['texJsonData'] = this.texJsonData;
    data['texPngData'] = this.texPngData;
    this.save.emit(data);
  }


  skeJsonHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isSkeJsonLoading = true;
        break;

      case 'success':
        this.skeJsonData['url'] = e.file.response.url;
        this.skeJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isSkeJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texJsonHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isTexJsonLoading = true;
        break;

      case 'success':
        this.texJsonData['url'] = e.file.response.url;
        this.texJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texPngHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isTexPngLoading = true;
        break;

      case 'success':
        this.texPngData['url'] = e.file.response.url;
        this.texPngData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexPngLoading = false; 
        break;

      case 'progress':
        break;
    }
  }



  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  closePanel() {
    console.log(' in closePanel ');
    this.refresh();
  }



  ngOnDestroy() {
  }

}
