import { asyncCallNetworkApiGet, buttonOnClick, asyncGetSpriteFrimeByUrl, jumpToCourseWare } from "../script/util";
import { MyCocosSceneComponent } from "../script/MyCocosSceneComponent";

const { ccclass, property } = cc._decorator;

@ccclass
export default class SceneComponent extends MyCocosSceneComponent {

    addPreloadImage() {
    }

    addPreloadAudio() {
    }

    addPreloadAnima() {

    }

    async onLoadEnd() {
        this.initBg();
        await this.initView();
        this.initListener();
    }

    rows: any;
    level: any;
    async initView() {
        const middleLayer = cc.find('middleLayer');
        if (!middleLayer) {
            const levelNode = cc.find(`Canvas/L1`);
            levelNode.active = true;
            this.level = 'L1';
            return;
        }
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        const folderId = middleLayerComponent.getData('NJ_MoreGames_CourseList').folderId;
        console.log('folderId = ' + folderId);
        const level = middleLayerComponent.getData('NJ_MoreGames').Level || 'L1';
        this.level = level;

        const levelNode = cc.find(`Canvas/${level}`);
        levelNode.active = true;

        const resStr = await asyncCallNetworkApiGet('/api/syllabus/v1/list', {
            pid: folderId
        });
        const res = JSON.parse(resStr);
        this.rows = res.rows;

        for (let i=1; i<=5; i++) {
            const row = this.rows[i-1];
            if (!row) {
                continue;
            }
            const item = cc.find(`item${i}`, levelNode);
            item.attr({syllabusId: row.id});
            const coverFrame: any = await asyncGetSpriteFrimeByUrl(row.cover);
            cc.find(`cover`, item).getComponent(cc.Sprite).spriteFrame = coverFrame;
        }
    }

    initBg() {
        const bg1 = cc.find('Canvas/L1/bg');
        bg1.scale = this._mapScaleMax;
        const bg2 = cc.find('Canvas/L2/bg');
        bg2.scale = this._mapScaleMax;
        const bg3 = cc.find('Canvas/L3/bg');
        bg3.scale = this._mapScaleMax;
    }

    initListener() {
        const btnReturn = cc.find('Canvas/btn_return');
        buttonOnClick(btnReturn, () => {
            const middleLayer = cc.find('middleLayer');
            if (middleLayer) {
                middleLayer.getComponent('middleLayer').loadOnlineBundle("NJ_MoreGames");
            }
        }, 0.6);

        const levelNode = cc.find(`Canvas/${this.level}`);
        for (let i = 1; i <= 5; i++) {
            const item = cc.find(`item${i}`, levelNode);
            buttonOnClick(item, () => {
                const syllabusId = item["syllabusId"];
                const middleLayer = cc.find('middleLayer');
                if (!middleLayer) {
                    return;
                }
                const middleLayerComponent = middleLayer.getComponent('middleLayer');
                if (!syllabusId) {
                    middleLayerComponent.showTips("未解锁 [101]");
                    return;
                }
                middleLayerComponent.setData('NJ_MoreGames_CourseList', {
                    syllabusId,
                });
                jumpToCourseWare(syllabusId);
            });
        }
    }
}
